/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.lib.McJtyLib;
import mcjty.lib.base.ModBase;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GuiSideWindow;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.Tools;
import net.minecraft.block.Block;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public abstract class GenericGuiContainer<T extends GenericTileEntity, C extends Container>
extends ContainerScreen<C> {
    protected ModBase modBase;
    protected SimpleChannel network;
    protected Window window;
    private WindowManager windowManager;
    protected final T tileEntity;
    private GuiSideWindow sideWindow;

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public void setWindowDimensions(int x, int y) {
        this.field_146999_f = x;
        this.field_147000_g = y;
    }

    public GenericGuiContainer(ModBase mod, SimpleChannel network, T tileEntity, C container, PlayerInventory inventory, int manual, String manualNode) {
        super(container, inventory, (ITextComponent)new StringTextComponent("test"));
        this.modBase = mod;
        this.network = network;
        this.tileEntity = tileEntity;
        this.sideWindow = new GuiSideWindow(manual, manualNode);
        this.windowManager = null;
    }

    public List<Rectangle> getSideWindowBounds() {
        if (this.sideWindow.getWindow() == null || this.sideWindow.getWindow().getToplevel() == null) {
            Logging.getLogger().error((Object)new RuntimeException("Internal error! getSideWindowBounds() called before initGui!"));
            return Collections.emptyList();
        }
        return Collections.singletonList(this.sideWindow.getWindow().getToplevel().getBounds());
    }

    public void init() {
        this.windowManager = null;
        super.init();
        this.sideWindow.initGui(this.modBase, this.network, this.minecraft, (Screen)this, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
    }

    protected void registerWindows(WindowManager mgr) {
    }

    protected WindowManager getWindowManager() {
        if (this.windowManager == null) {
            if (this.sideWindow.getWindow() == null) {
                RuntimeException e = new RuntimeException("Internal error! getWindowManager() called before initGui!");
                Logging.getLogger().error((Object)e);
                throw e;
            }
            this.windowManager = new WindowManager((Screen)this);
            this.windowManager.addWindow(this.sideWindow.getWindow());
            this.windowManager.addWindow(this.window);
            this.registerWindows(this.windowManager);
        }
        return this.windowManager;
    }

    protected void func_146979_b(int i, int i2) {
        this.getWindowManager().drawTooltips();
    }

    public static String escapeString(String s) {
        return s.replace("@", "@@");
    }

    private static List<Object> parseString(String s, List<ItemStack> items) {
        ArrayList<Object> l = new ArrayList<Object>();
        String current = "";
        for (int i = 0; i < s.length(); ++i) {
            String c = s.substring(i, i + 1);
            if ("@".equals(c)) {
                ItemStack e;
                int itemIdx;
                if ((itemIdx = s.charAt(++i) - 48) == 16) {
                    current = current + "@";
                    continue;
                }
                if (itemIdx < 0 || itemIdx > 9) {
                    throw new IllegalArgumentException(s);
                }
                if (!current.isEmpty()) {
                    l.add(current);
                    current = "";
                }
                if ((e = items.get(itemIdx)).func_190926_b()) continue;
                l.add(e);
                continue;
            }
            current = current + c;
        }
        if (!current.isEmpty()) {
            l.add(current);
        }
        return l;
    }

    public void drawHoveringText(List<String> textLines, List<ItemStack> items, int x, int y, FontRenderer font) {
        if (!textLines.isEmpty()) {
            GlStateManager.disableRescaleNormal();
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
            GlStateManager.disableLighting();
            GlStateManager.disableDepthTest();
            int i = 0;
            int linesWithItemStacks = 0;
            for (String s : textLines) {
                int j;
                if (s != null && items != null && s.contains("@") && !items.isEmpty()) {
                    List<Object> list = GenericGuiContainer.parseString(s, items);
                    boolean lineHasItemStacks = false;
                    j = 0;
                    for (Object o : list) {
                        if (o instanceof String) {
                            j += font.func_78256_a((String)o);
                            continue;
                        }
                        j += 20;
                        lineHasItemStacks = true;
                    }
                    if (lineHasItemStacks) {
                        ++linesWithItemStacks;
                    }
                } else {
                    j = font.func_78256_a(s);
                }
                if (j <= i) continue;
                i = j;
            }
            int xx = x + 12;
            int yy = y - 12;
            int k = 8;
            if (textLines.size() > 1) {
                k += 2 + (textLines.size() - 1) * 10 + linesWithItemStacks * 8;
            }
            if (xx > this.width - this.field_147003_i - i - 5) {
                xx -= 28 + i;
            }
            if (xx < 4 - this.field_147003_i) {
                xx = 4 - this.field_147003_i;
            }
            if (yy > this.height - this.field_147009_r - k - 4) {
                yy = this.height - this.field_147009_r - k - 4;
            } else if (yy < 4 - this.field_147009_r) {
                yy = 4 - this.field_147009_r;
            }
            this.itemRenderer.field_77023_b = 300.0f;
            int l = -267386864;
            this.fillGradient(xx - 3, yy - 4, xx + i + 3, yy - 3, l, l);
            this.fillGradient(xx - 3, yy + k + 3, xx + i + 3, yy + k + 4, l, l);
            this.fillGradient(xx - 3, yy - 3, xx + i + 3, yy + k + 3, l, l);
            this.fillGradient(xx - 4, yy - 3, xx - 3, yy + k + 3, l, l);
            this.fillGradient(xx + i + 3, yy - 3, xx + i + 4, yy + k + 3, l, l);
            int i1 = 0x505000FF;
            int j1 = (i1 & 0xFEFEFE) >> 1 | i1 & 0xFF000000;
            this.fillGradient(xx - 3, yy - 3 + 1, xx - 3 + 1, yy + k + 3 - 1, i1, j1);
            this.fillGradient(xx + i + 2, yy - 3 + 1, xx + i + 3, yy + k + 3 - 1, i1, j1);
            this.fillGradient(xx - 3, yy - 3, xx + i + 3, yy - 3 + 1, i1, i1);
            this.fillGradient(xx - 3, yy + k + 2, xx + i + 3, yy + k + 3, j1, j1);
            for (int k1 = 0; k1 < textLines.size(); ++k1) {
                String s1 = textLines.get(k1);
                if (s1 != null && items != null && s1.contains("@") && !items.isEmpty()) {
                    List<Object> list = GenericGuiContainer.parseString(s1, items);
                    int curx = xx;
                    boolean lineHasItemStacks = false;
                    for (Object o : list) {
                        if (o instanceof String) {
                            String s2 = (String)o;
                            font.func_175063_a(s2, (float)curx, (float)yy, -1);
                            curx += font.func_78256_a(s2);
                            continue;
                        }
                        RenderHelper.renderObject(this.getMinecraft(), curx + 1, yy, o, false);
                        curx += 20;
                        lineHasItemStacks = true;
                    }
                    if (lineHasItemStacks) {
                        yy += 8;
                    }
                } else {
                    font.func_175063_a(s1, (float)xx, (float)yy, -1);
                }
                if (k1 == 0) {
                    yy += 2;
                }
                yy += 10;
            }
            this.itemRenderer.field_77023_b = 0.0f;
            GlStateManager.enableLighting();
            GlStateManager.enableDepthTest();
            net.minecraft.client.renderer.RenderHelper.func_74519_b();
            GlStateManager.enableRescaleNormal();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.drawWindow();
    }

    protected void drawWindow() {
        if (this.window == null) {
            return;
        }
        this.renderBackground();
        this.getWindowManager().draw();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.window == null) {
            return;
        }
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.drawStackTooltips(mouseX, mouseY);
    }

    public void func_146977_a(Slot slotIn) {
        if (!this.isPartiallyCoveredByModalWindow(slotIn)) {
            super.func_146977_a(slotIn);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        Slot slot = this.getSlotUnderMouse();
        if (this.isPartiallyCoveredByModalWindow(slot)) {
            return false;
        }
        return super.isMouseOver(mouseX, mouseY);
    }

    private boolean isPartiallyCoveredByModalWindow(Slot slotIn) {
        int xPos = slotIn.field_75223_e + this.window.getToplevel().getBounds().x;
        int yPos = slotIn.field_75221_f + this.window.getToplevel().getBounds().y;
        return this.getWindowManager().getModalWindows().anyMatch(window -> window.getToplevel().getBounds().intersects(new Rectangle(xPos, yPos, 18, 18)));
    }

    protected void drawStackTooltips(int mouseX, int mouseY) {
        BlockRender blockRender;
        Object renderItem;
        ItemStack itemStack;
        MouseHelper mouse = this.getMinecraft().field_71417_B;
        int x = (int)mouse.func_198024_e() * this.width / this.getMinecraft().field_195558_d.func_198105_m();
        int y = this.height - (int)mouse.func_198026_f() * this.height / this.getMinecraft().field_195558_d.func_198083_n() - 1;
        Widget<?> widget = this.window.getToplevel().getWidgetAtPosition(x, y);
        if (widget instanceof BlockRender && !(itemStack = (renderItem = (blockRender = (BlockRender)widget).getRenderItem()) instanceof ItemStack ? (ItemStack)renderItem : (renderItem instanceof Block ? new ItemStack((IItemProvider)((Block)renderItem)) : (renderItem instanceof Item ? new ItemStack((IItemProvider)((Item)renderItem)) : ItemStack.field_190927_a))).func_190926_b()) {
            this.customRenderToolTip(blockRender, itemStack, mouseX, mouseY);
        }
    }

    protected List<String> addCustomLines(List<String> oldList, BlockRender blockRender, ItemStack stack) {
        return oldList;
    }

    protected void customRenderToolTip(BlockRender blockRender, ItemStack stack, int x, int y) {
        List<String> list;
        if (stack.func_77973_b() == null) {
            list = new ArrayList<String>();
        } else {
            ITooltipFlag.TooltipFlags flag = this.getMinecraft().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            list = stack.func_82840_a((PlayerEntity)this.getMinecraft().field_71439_g, (ITooltipFlag)flag).stream().map(s -> s.func_150254_d()).collect(Collectors.toList());
        }
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77953_t().field_77937_e + list.get(i));
                continue;
            }
            list.set(i, TextFormatting.GRAY + list.get(i));
        }
        list = this.addCustomLines(list, blockRender, stack);
        FontRenderer font = null;
        if (stack.func_77973_b() != null) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        this.renderTooltip(list, x, y, font == null ? this.getMinecraft().field_71466_p : font);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        super.onClose();
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean rc = super.mouseClicked(x, y, button);
        if (this.window != null) {
            this.getWindowManager().mouseClicked((int)x, (int)y, button);
        }
        return rc;
    }

    public boolean mouseDragged(double x, double y, int button, double scaledX, double scaledY) {
        boolean rc = super.mouseDragged(x, y, button, scaledX, scaledY);
        if (this.window != null) {
            this.getWindowManager().handleMouseInput(button);
        }
        return rc;
    }

    public boolean mouseReleased(double x, double y, int state) {
        boolean rc = super.mouseReleased(x, y, state);
        if (this.window != null) {
            this.getWindowManager().mouseReleased((int)x, (int)y, state);
        }
        return rc;
    }

    public Window getWindow() {
        return this.window;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean b;
        boolean bl = b = this.window == null || this.getWindowManager().keyTyped(keyCode, scanCode);
        if (b) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public void keyTypedFromEvent(int keyCode, int scanCode) {
        if (this.window != null && this.getWindowManager().keyTyped(keyCode, scanCode)) {
            super.keyPressed(keyCode, scanCode, 0);
        }
    }

    public void charTypedFromEvent(char codePoint) {
        if (this.window == null || this.getWindowManager().charTyped(codePoint)) {
            // empty if block
        }
    }

    public void sendServerCommand(SimpleChannel network, String command, TypedMap params) {
        network.sendToServer((Object)new PacketServerCommandTyped(this.tileEntity.func_174877_v(), null, command, params));
    }

    public void sendServerCommand(SimpleChannel network, DimensionType dimensionId, String command, TypedMap params) {
        network.sendToServer((Object)new PacketServerCommandTyped(this.tileEntity.func_174877_v(), dimensionId, command, params));
    }

    public void sendServerCommand(String modid, String command, @Nonnull TypedMap arguments) {
        this.network.sendToServer((Object)new PacketSendServerCommand(modid, command, arguments));
    }

    public void sendServerCommand(String modid, String command) {
        this.network.sendToServer((Object)new PacketSendServerCommand(modid, command, TypedMap.EMPTY));
    }

    public static <C extends GenericContainer, S extends GenericGuiContainer<T, C>, T extends GenericTileEntity> void register(ContainerType<C> type, GuiSupplier<C, S, T> guiSupplier) {
        ScreenManager.IScreenFactory factory = (container, inventory, title) -> {
            TileEntity te = McJtyLib.proxy.getClientWorld().func_175625_s(container.getPos());
            return Tools.safeMap(te, tile -> guiSupplier.create(tile, container, inventory), "Invalid tile entity!");
        };
        ScreenManager.func_216911_a(type, (ScreenManager.IScreenFactory)factory);
    }

    @FunctionalInterface
    public static interface GuiSupplier<C extends GenericContainer, S extends GenericGuiContainer, T extends GenericTileEntity> {
        public S create(T var1, C var2, PlayerInventory var3);
    }
}

