/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotRanges;
import mcjty.lib.container.SlotType;
import mcjty.lib.gui.GuiParser;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ContainerFactory {
    private Map<Integer, SlotDefinition> indexToType = new HashMap<Integer, SlotDefinition>();
    private Map<SlotDefinition, SlotRanges> slotRangesMap = new HashMap<SlotDefinition, SlotRanges>();
    private List<SlotFactory> slots = new ArrayList<SlotFactory>();
    public static final String CONTAINER_CONTAINER = "container";
    public static final String CONTAINER_PLAYER = "player";
    private boolean setupDone = false;
    private boolean slotsSetup = false;
    private int[] accessibleSlots;
    private int[] accessibleInputSlots;
    private int[] accessibleOutputSlots;
    private final int containerSlots;

    public ContainerFactory(int containerSlots) {
        this.containerSlots = containerSlots;
    }

    public int getContainerSlots() {
        return this.containerSlots;
    }

    protected void setup() {
    }

    private void handleSlotCommand(GuiParser.GuiCommand slotCmd) {
        String typen = slotCmd.getOptionalPar(0, SlotType.SLOT_CONTAINER.getName());
        SlotType type = SlotType.findByName(typen);
        if (type == null) {
            throw new RuntimeException("Unknown slot type: " + typen + "!");
        }
        ArrayList stacks = new ArrayList();
        slotCmd.findCommand("items").ifPresent(cmd -> cmd.parameters().forEach(par -> {
            Item item;
            String itemName = par.toString();
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(itemName));
            ItemStack stack = block != null && block != Blocks.field_150350_a ? new ItemStack((IItemProvider)block) : ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))) != null ? new ItemStack((IItemProvider)item) : ItemStack.field_190927_a);
            stacks.add(stack);
        }));
        SlotDefinition slotDefinition = new SlotDefinition(type, stacks.toArray(new ItemStack[stacks.size()]));
        int[] pos = new int[2];
        slotCmd.findCommand("pos").ifPresent(cmd -> {
            pos[0] = cmd.getOptionalPar(0, 0);
            pos[1] = cmd.getOptionalPar(1, 0);
        });
        int[] dim = new int[]{1, 1};
        slotCmd.findCommand("dim").ifPresent(cmd -> {
            dim[0] = cmd.getOptionalPar(0, 0);
            dim[1] = cmd.getOptionalPar(1, 0);
        });
        this.box(slotDefinition, CONTAINER_CONTAINER, this.slots.size(), pos[0], pos[1], dim[0], dim[1]);
    }

    public void doSetup() {
        if (!this.setupDone) {
            this.setupDone = true;
            this.setup();
        }
    }

    protected void setupAccessibleSlots() {
        if (this.slotsSetup) {
            return;
        }
        this.doSetup();
        this.slotsSetup = true;
        ArrayList<Integer> s = new ArrayList<Integer>();
        ArrayList<Integer> si = new ArrayList<Integer>();
        ArrayList<Integer> so = new ArrayList<Integer>();
        int index = 0;
        for (SlotFactory slotFactory : this.slots) {
            if (slotFactory.getSlotType() == SlotType.SLOT_INPUT) {
                s.add(index);
                si.add(index);
            }
            if (slotFactory.getSlotType() == SlotType.SLOT_OUTPUT) {
                s.add(index);
                so.add(index);
            }
            ++index;
        }
        this.accessibleSlots = ContainerFactory.convertList(s);
        this.accessibleInputSlots = ContainerFactory.convertList(si);
        this.accessibleOutputSlots = ContainerFactory.convertList(so);
    }

    private static int[] convertList(List<Integer> list) {
        int[] s = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            s[i] = list.get(i);
        }
        return s;
    }

    public Map<SlotDefinition, SlotRanges> getSlotRangesMap() {
        return this.slotRangesMap;
    }

    public int[] getAccessibleSlots() {
        this.setupAccessibleSlots();
        return this.accessibleSlots;
    }

    public int[] getAccessibleInputSlots() {
        this.setupAccessibleSlots();
        return this.accessibleInputSlots;
    }

    public int[] getAccessibleOutputSlots() {
        this.setupAccessibleSlots();
        return this.accessibleOutputSlots;
    }

    public Iterable<SlotFactory> getSlots() {
        return this.slots;
    }

    public SlotType getSlotType(int index) {
        SlotDefinition slotDefinition = this.indexToType.get(index);
        if (slotDefinition == null) {
            return SlotType.SLOT_UNKNOWN;
        }
        return slotDefinition.getType();
    }

    public boolean isContainerSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_CONTAINER;
    }

    public boolean isOutputSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_OUTPUT;
    }

    public boolean isInputSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_INPUT;
    }

    public boolean isGhostSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_GHOST;
    }

    public boolean isGhostOutputSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_GHOSTOUT;
    }

    public boolean isCraftResultSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_CRAFTRESULT;
    }

    public boolean isPlayerInventorySlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_PLAYERINV;
    }

    public boolean isSpecificItemSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_SPECIFICITEM;
    }

    public boolean isPlayerHotbarSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_PLAYERHOTBAR;
    }

    public void slot(SlotDefinition slotDefinition, String inventoryName, int index, int x, int y) {
        SlotFactory slotFactory = new SlotFactory(slotDefinition, inventoryName, index, x, y);
        int slotIndex = this.slots.size();
        this.slots.add(slotFactory);
        SlotRanges slotRanges = this.slotRangesMap.get(slotDefinition);
        if (slotRanges == null) {
            slotRanges = new SlotRanges(slotDefinition);
            this.slotRangesMap.put(slotDefinition, slotRanges);
        }
        slotRanges.addSingle(slotIndex);
        this.indexToType.put(slotIndex, slotDefinition);
    }

    public int range(SlotDefinition slotDefinition, String inventoryName, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.slot(slotDefinition, inventoryName, index, x, y);
            x += dx;
            ++index;
        }
        return index;
    }

    public int box(SlotDefinition slotDefinition, String inventoryName, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.range(slotDefinition, inventoryName, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    public int box(SlotDefinition slotDefinition, String inventoryName, int index, int x, int y, int horAmount, int verAmount) {
        return this.box(slotDefinition, inventoryName, index, x, y, horAmount, 18, verAmount, 18);
    }

    protected void playerSlots(int leftCol, int topRow) {
        this.box(new SlotDefinition(SlotType.SLOT_PLAYERINV, new ItemStack[0]), CONTAINER_PLAYER, 9, leftCol, topRow, 9, 3);
        this.range(new SlotDefinition(SlotType.SLOT_PLAYERHOTBAR, new ItemStack[0]), CONTAINER_PLAYER, 0, leftCol, topRow += 58, 9, 18);
    }
}

