/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.blocks;

import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.varia.LogicFacing;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class LogicSlabBlock
extends BaseBlock {
    public static IntegerProperty META_INTERMEDIATE = IntegerProperty.func_177719_a((String)"intermediate", (int)0, (int)3);
    public static EnumProperty<LogicFacing> LOGIC_FACING = EnumProperty.func_177709_a((String)"logic_facing", LogicFacing.class);
    public static final AxisAlignedBB BLOCK_DOWN = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.3f, 1.0);
    public static final AxisAlignedBB BLOCK_UP = new AxisAlignedBB(0.0, (double)0.7f, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB BLOCK_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.3f);
    public static final AxisAlignedBB BLOCK_SOUTH = new AxisAlignedBB(0.0, 0.0, (double)0.7f, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB BLOCK_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.3f, 1.0, 1.0);
    public static final AxisAlignedBB BLOCK_EAST = new AxisAlignedBB((double)0.7f, 0.0, 0.0, 1.0, 1.0, 1.0);

    public LogicSlabBlock(String name, BlockBuilder builder) {
        super(name, builder);
    }

    public static Direction rotateLeft(Direction downSide, Direction inputSide) {
        switch (downSide) {
            case DOWN: {
                return inputSide.func_176746_e();
            }
            case UP: {
                return inputSide.func_176735_f();
            }
            case NORTH: {
                return inputSide.func_176732_a(Direction.Axis.Z);
            }
            case SOUTH: {
                return inputSide.func_176734_d().func_176732_a(Direction.Axis.Z);
            }
            case WEST: {
                return inputSide.func_176732_a(Direction.Axis.X);
            }
            case EAST: {
                return inputSide.func_176734_d().func_176732_a(Direction.Axis.X);
            }
        }
        return inputSide;
    }

    public static Direction rotateRight(Direction downSide, Direction inputSide) {
        return LogicSlabBlock.rotateLeft(downSide.func_176734_d(), inputSide);
    }

    @Override
    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        LogicFacing facing;
        Vec3d hit = context.func_221532_j();
        double dx = Math.abs(0.5 - hit.field_72450_a);
        double dy = Math.abs(0.5 - hit.field_72448_b);
        double dz = Math.abs(0.5 - hit.field_72449_c);
        Direction side = context.func_196000_l().func_176734_d();
        switch (side) {
            case DOWN: {
                if (dx < dz) {
                    facing = hit.field_72449_c < 0.5 ? LogicFacing.DOWN_TOSOUTH : LogicFacing.DOWN_TONORTH;
                    break;
                }
                facing = hit.field_72450_a < 0.5 ? LogicFacing.DOWN_TOEAST : LogicFacing.DOWN_TOWEST;
                break;
            }
            case UP: {
                if (dx < dz) {
                    facing = hit.field_72449_c < 0.5 ? LogicFacing.UP_TOSOUTH : LogicFacing.UP_TONORTH;
                    break;
                }
                facing = hit.field_72450_a < 0.5 ? LogicFacing.UP_TOEAST : LogicFacing.UP_TOWEST;
                break;
            }
            case NORTH: {
                if (dx < dy) {
                    facing = hit.field_72448_b < 0.5 ? LogicFacing.NORTH_TOUP : LogicFacing.NORTH_TODOWN;
                    break;
                }
                facing = hit.field_72450_a < 0.5 ? LogicFacing.NORTH_TOEAST : LogicFacing.NORTH_TOWEST;
                break;
            }
            case SOUTH: {
                if (dx < dy) {
                    facing = hit.field_72448_b < 0.5 ? LogicFacing.SOUTH_TOUP : LogicFacing.SOUTH_TODOWN;
                    break;
                }
                facing = hit.field_72450_a < 0.5 ? LogicFacing.SOUTH_TOEAST : LogicFacing.SOUTH_TOWEST;
                break;
            }
            case WEST: {
                if (dy < dz) {
                    facing = hit.field_72449_c < 0.5 ? LogicFacing.WEST_TOSOUTH : LogicFacing.WEST_TONORTH;
                    break;
                }
                facing = hit.field_72448_b < 0.5 ? LogicFacing.WEST_TOUP : LogicFacing.WEST_TODOWN;
                break;
            }
            case EAST: {
                if (dy < dz) {
                    facing = hit.field_72449_c < 0.5 ? LogicFacing.EAST_TOSOUTH : LogicFacing.EAST_TONORTH;
                    break;
                }
                facing = hit.field_72448_b < 0.5 ? LogicFacing.EAST_TOUP : LogicFacing.EAST_TODOWN;
                break;
            }
            default: {
                facing = LogicFacing.DOWN_TOWEST;
            }
        }
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((IProperty)META_INTERMEDIATE, (Comparable)Integer.valueOf(facing.getMeta()))).func_206870_a(LOGIC_FACING, (Comparable)((Object)facing));
    }

    protected int getInputStrength(World world, BlockPos pos, Direction side) {
        BlockState blockState;
        Block b;
        int power = world.func_175651_c(pos.func_177972_a(side), side);
        if (power < 15 && (b = (blockState = world.func_180495_p(pos.func_177972_a(side))).func_177230_c()) == Blocks.field_150488_af) {
            power = Math.max(power, (Integer)blockState.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O));
        }
        return power;
    }

    @Override
    @Deprecated
    protected void checkRedstone(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof LogicTileEntity) {
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            Direction inputSide = logicTileEntity.getFacing(world.func_180495_p(pos)).getInputSide();
            int power = this.getInputStrength(world, pos, inputSide);
            logicTileEntity.setPowerInput(power);
        }
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof LogicSlabBlock && te instanceof LogicTileEntity) {
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            Direction direction = logicTileEntity.getFacing(state).getInputSide();
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    return side == Direction.NORTH || side == Direction.SOUTH;
                }
                case WEST: 
                case EAST: {
                    return side == Direction.WEST || side == Direction.EAST;
                }
                case DOWN: 
                case UP: {
                    return side == Direction.DOWN || side == Direction.UP;
                }
            }
        }
        return false;
    }

    protected int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof LogicSlabBlock && te instanceof LogicTileEntity) {
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            return logicTileEntity.getRedstoneOutput(state, world, pos, side);
        }
        return 0;
    }

    @Override
    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rot) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof LogicSlabBlock && te instanceof LogicTileEntity) {
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            LogicFacing facing = logicTileEntity.getFacing(state);
            int meta = facing.getMeta();
            switch (meta) {
                case 0: {
                    meta = 2;
                    break;
                }
                case 1: {
                    meta = 3;
                    break;
                }
                case 2: {
                    meta = 1;
                    break;
                }
                case 3: {
                    meta = 0;
                }
            }
            LogicFacing newfacing = LogicFacing.getFacingWithMeta(facing, meta);
            logicTileEntity.setFacing(newfacing);
            BlockState newstate = (BlockState)state.func_177230_c().func_176223_P().func_206870_a((IProperty)META_INTERMEDIATE, (Comparable)Integer.valueOf(meta));
            world.func_180501_a(pos, newstate, 3);
            logicTileEntity.rotateBlock(rot);
            return newstate;
        }
        return state;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{LOGIC_FACING}).func_206894_a(new IProperty[]{META_INTERMEDIATE});
    }
}

