/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.google.common.collect.ImmutableList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;

public final class PlayerUtils {
    private PlayerUtils() {
    }

    public static void giveItem(PlayerEntity player, ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        if (!player.field_71071_by.func_70441_a(copy)) {
            ItemEntity entityItem = new ItemEntity(player.field_70170_p, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, copy);
            entityItem.func_174868_q();
            entityItem.func_200217_b(player.func_110124_au());
            player.field_70170_p.func_217376_c((Entity)entityItem);
        }
    }

    public static void removeItem(PlayerEntity player, ItemStack stack) {
        ImmutableList inventories = ImmutableList.of((Object)player.field_71071_by.field_70462_a, (Object)player.field_71071_by.field_184439_c, (Object)player.field_71071_by.field_70460_b);
        for (NonNullList inv : inventories) {
            for (int i = 0; i < inv.size(); ++i) {
                if (stack != inv.get(i)) continue;
                inv.set(i, (Object)ItemStack.field_190927_a);
                return;
            }
        }
    }

    public static CompoundNBT getPersistedDataSubcompound(PlayerEntity player, String subcompoundKey) {
        CompoundNBT persistedData;
        CompoundNBT forgeData = player.getPersistentData();
        if (!forgeData.func_74764_b("PlayerPersisted")) {
            forgeData.func_218657_a("PlayerPersisted", (INBT)new CompoundNBT());
        }
        if (!(persistedData = forgeData.func_74775_l("PlayerPersisted")).func_74764_b(subcompoundKey)) {
            persistedData.func_218657_a(subcompoundKey, (INBT)new CompoundNBT());
        }
        return persistedData.func_74775_l(subcompoundKey);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(PlayerEntity player) {
        return PlayerUtils.getNonEmptyStacks(player, true, true, true, s -> true);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(PlayerEntity player, Predicate<ItemStack> predicate) {
        return PlayerUtils.getNonEmptyStacks(player, true, true, true, predicate);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(PlayerEntity player, boolean includeMain, boolean includeOffHand, boolean includeArmor) {
        return PlayerUtils.getNonEmptyStacks(player, includeMain, includeOffHand, includeArmor, s -> true);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(PlayerEntity player, boolean includeMain, boolean includeOffHand, boolean includeArmor, Predicate<ItemStack> predicate) {
        NonNullList list = NonNullList.func_191196_a();
        if (includeMain) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack.func_190926_b() || !predicate.test(stack)) continue;
                list.add((Object)stack);
            }
        }
        if (includeOffHand) {
            for (ItemStack stack : player.field_71071_by.field_184439_c) {
                if (stack.func_190926_b() || !predicate.test(stack)) continue;
                list.add((Object)stack);
            }
        }
        if (includeArmor) {
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                if (stack.func_190926_b() || !predicate.test(stack)) continue;
                list.add((Object)stack);
            }
        }
        return list;
    }

    @Nonnull
    public static ItemStack getFirstValidStack(PlayerEntity player, boolean includeMain, boolean includeOffHand, boolean includeArmor, Predicate<ItemStack> predicate) {
        if (includeOffHand) {
            for (ItemStack stack : player.field_71071_by.field_184439_c) {
                if (stack.func_190926_b() || !predicate.test(stack)) continue;
                return stack;
            }
        }
        if (includeArmor) {
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                if (stack.func_190926_b() || !predicate.test(stack)) continue;
                return stack;
            }
        }
        if (includeMain) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack.func_190926_b() || !predicate.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }
}

