/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class StartupMessageManager {
    private static final EnumMap<MessageType, List<Message>> messages = new EnumMap(MessageType.class);

    public static List<Pair<Integer, Message>> getMessages() {
        long ts = System.nanoTime();
        return messages.values().stream().flatMap(Collection::stream).sorted(Comparator.comparingLong(Message::getTimestamp).thenComparing(Message::getText).reversed()).map(m -> Pair.of((Object)((int)((double)(ts - ((Message)m).timestamp) / 1000000.0)), (Object)m)).collect(Collectors.toList());
    }

    public static void addModMessage(String message) {
        String safeMessage = Ascii.truncate((CharSequence)CharMatcher.ascii().retainFrom((CharSequence)message), (int)80, (String)"~");
        List<Message> messages = StartupMessageManager.messages.get((Object)MessageType.MOD);
        messages.subList(0, Math.max(0, messages.size() - 20)).clear();
        messages.add(new Message(safeMessage, MessageType.MOD));
    }

    static Optional<Consumer<String>> modLoaderConsumer() {
        return Optional.of(s -> messages.get((Object)MessageType.ML).add(new Message((String)s, MessageType.ML)));
    }

    static Optional<Consumer<String>> mcLoaderConsumer() {
        return Optional.of(s -> messages.get((Object)MessageType.MC).add(new Message((String)s, MessageType.MC)));
    }

    static {
        Arrays.stream(MessageType.values()).forEach(mt -> messages.computeIfAbsent((MessageType)((Object)mt), k -> new CopyOnWriteArrayList()));
    }

    static enum MessageType {
        MC(0.0f, 0.0f, 0.0f),
        ML(0.0f, 0.0f, 0.5f),
        MOD(0.5f, 0.0f, 0.0f);

        private final float[] colour;

        private MessageType(float r, float g, float b) {
            this.colour = new float[]{r, g, b};
        }

        public float[] colour() {
            return this.colour;
        }
    }

    public static class Message {
        private final String text;
        private final MessageType type;
        private final long timestamp;

        public Message(String text, MessageType type) {
            this.text = text;
            this.type = type;
            this.timestamp = System.nanoTime();
        }

        public String getText() {
            return this.text;
        }

        MessageType getType() {
            return this.type;
        }

        long getTimestamp() {
            return this.timestamp;
        }

        public float[] getTypeColour() {
            return this.type.colour();
        }
    }
}

