/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability;

import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class CapabilityFluidHandler {
    @CapabilityInject(value=IFluidHandler.class)
    public static Capability<IFluidHandler> FLUID_HANDLER_CAPABILITY = null;
    @CapabilityInject(value=IFluidHandlerItem.class)
    public static Capability<IFluidHandlerItem> FLUID_HANDLER_ITEM_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IFluidHandler.class, new DefaultFluidHandlerStorage(), () -> new FluidTank(1000));
        CapabilityManager.INSTANCE.register(IFluidHandlerItem.class, new DefaultFluidHandlerStorage(), () -> new FluidHandlerItemStack(new ItemStack((IItemProvider)Items.field_151133_ar), 1000));
    }

    private static class DefaultFluidHandlerStorage<T extends IFluidHandler>
    implements Capability.IStorage<T> {
        private DefaultFluidHandlerStorage() {
        }

        @Override
        public INBT writeNBT(Capability<T> capability, T instance, Direction side) {
            if (!(instance instanceof FluidTank)) {
                throw new RuntimeException("Cannot serialize to an instance that isn't the default implementation");
            }
            CompoundNBT nbt = new CompoundNBT();
            FluidTank tank = (FluidTank)instance;
            FluidStack fluid = tank.getFluid();
            fluid.writeToNBT(nbt);
            nbt.func_74768_a("Capacity", tank.getCapacity());
            return nbt;
        }

        @Override
        public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
            if (!(instance instanceof FluidTank)) {
                throw new RuntimeException("Cannot deserialize to an instance that isn't the default implementation");
            }
            CompoundNBT tags = (CompoundNBT)nbt;
            FluidTank tank = (FluidTank)instance;
            tank.setCapacity(tags.func_74762_e("Capacity"));
            tank.readFromNBT(tags);
        }
    }
}

