/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.power.BlutricityStorage;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.api.power.IPowerBase;
import com.bluepowermod.block.power.BlockBlulectricFurnace;
import com.bluepowermod.container.ContainerBlulectricFurnace;
import com.bluepowermod.helper.EnergyHelper;
import com.bluepowermod.tile.BPTileEntityType;
import com.bluepowermod.tile.TileMachineBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileBlulectricFurnace
extends TileMachineBase
implements ISidedInventory,
INamedContainerProvider {
    private final BlutricityStorage storage = new BlutricityStorage(1000.0, 100.0);
    private LazyOptional<IPowerBase> blutricityCap;
    private boolean isActive;
    private int currentProcessTime;
    public static final int SLOTS = 2;
    private ItemStack inventory;
    private ItemStack outputInventory;
    private FurnaceRecipe currentRecipe;
    private boolean updatingRecipe = true;
    protected final IIntArray fields = new IIntArray(){

        public int func_221476_a(int i) {
            switch (i) {
                case 0: {
                    return (int)TileBlulectricFurnace.this.storage.getEnergy();
                }
                case 1: {
                    return TileBlulectricFurnace.this.currentProcessTime;
                }
                case 2: {
                    return (int)TileBlulectricFurnace.this.storage.getMaxEnergy();
                }
            }
            return 0;
        }

        public void func_221477_a(int i, int value) {
            switch (i) {
                case 0: {
                    break;
                }
                case 1: {
                    TileBlulectricFurnace.this.currentProcessTime = value;
                    break;
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };

    public TileBlulectricFurnace() {
        super(BPTileEntityType.BLULECTRIC_FURNACE);
        this.inventory = ItemStack.field_190927_a;
        this.outputInventory = ItemStack.field_190927_a;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.storage.resetCurrent();
            for (Direction facing : Direction.values()) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile == null) continue;
                tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, facing.func_176734_d()).ifPresent(exStorage -> EnergyHelper.balancePower(exStorage, this.storage));
            }
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.updatingRecipe) {
                this.currentRecipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)this, this.field_145850_b).isPresent() ? (FurnaceRecipe)this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)this, this.field_145850_b).get() : null;
                this.updatingRecipe = false;
            }
            if (this.currentRecipe != null) {
                if (this.storage.getEnergy() / this.storage.getMaxEnergy() > 0.5) {
                    int n;
                    this.storage.addEnergy(-1.0, false);
                    this.setIsActive(true);
                    ++this.currentProcessTime;
                    if ((double)n >= 100.0 / (this.storage.getEnergy() / this.storage.getMaxEnergy()) && (this.outputInventory.func_77973_b() == this.currentRecipe.func_77571_b().func_77973_b() && this.outputInventory.func_190916_E() + this.currentRecipe.func_77572_b((IInventory)this).func_190916_E() <= 64 || this.outputInventory.func_190926_b())) {
                        this.currentProcessTime = 0;
                        if (!this.outputInventory.func_190926_b()) {
                            this.outputInventory.func_190920_e(this.outputInventory.func_190916_E() + this.currentRecipe.func_77572_b((IInventory)this).func_190916_E());
                        } else {
                            this.outputInventory = this.currentRecipe.func_77572_b((IInventory)this).func_77946_l();
                        }
                        this.func_70298_a(0, 1);
                        this.updatingRecipe = true;
                    }
                } else {
                    this.setIsActive(false);
                }
            } else {
                this.currentProcessTime = 0;
                this.setIsActive(false);
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityBlutricity.BLUTRICITY_CAPABILITY) {
            if (this.blutricityCap == null) {
                this.blutricityCap = LazyOptional.of(() -> this.storage);
            }
            return this.blutricityCap.cast();
        }
        return LazyOptional.empty();
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.blutricityCap != null) {
            this.blutricityCap.invalidate();
            this.blutricityCap = null;
        }
    }

    @Override
    public void readFromPacketNBT(CompoundNBT tag) {
        super.readFromPacketNBT(tag);
        this.isActive = tag.func_74767_n("isActive");
        this.currentProcessTime = tag.func_74762_e("currentProcessTime");
        this.markForRenderUpdate();
        if (tag.func_74764_b("energy")) {
            INBT nbtstorage = tag.func_74781_a("energy");
            CapabilityBlutricity.BLUTRICITY_CAPABILITY.getStorage().readNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Object)this.storage, null, nbtstorage);
        }
    }

    @Override
    public void writeToPacketNBT(CompoundNBT tag) {
        super.writeToPacketNBT(tag);
        tag.func_74768_a("currentProcessTime", this.currentProcessTime);
        tag.func_74757_a("isActive", this.isActive);
        INBT nbtstorage = CapabilityBlutricity.BLUTRICITY_CAPABILITY.getStorage().writeNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Object)this.storage, null);
        tag.func_218657_a("energy", nbtstorage);
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean _isActive) {
        if (_isActive != this.isActive) {
            this.isActive = _isActive;
            BlockBlulectricFurnace.setState(this.isActive, this.field_145850_b, this.field_174879_c);
            this.sendUpdatePacket();
        }
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int var1) {
        this.updatingRecipe = true;
        if (var1 == 0) {
            return this.inventory;
        }
        if (var1 == 1) {
            return this.outputInventory;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (!itemStack.func_190926_b()) {
            if (itemStack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else if ((itemStack = itemStack.func_77979_a(amount)).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int index) {
        return this.func_70301_a(index);
    }

    public void func_70299_a(int var1, ItemStack itemStack) {
        if (var1 == 0) {
            this.inventory = itemStack;
        } else {
            this.outputInventory = itemStack;
        }
        this.updatingRecipe = true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return player.func_180425_c().func_218141_a((Vec3i)this.field_174879_c, 64.0);
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return slot == 0;
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        if (!this.outputInventory.func_190926_b()) {
            drops.add((Object)this.outputInventory);
        }
        if (!this.inventory.func_190926_b()) {
            drops.add((Object)this.inventory);
        }
        return drops;
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    }

    public boolean func_180462_a(int slot, ItemStack item, Direction direction) {
        return this.func_94041_b(slot, item);
    }

    public boolean func_180461_b(int slot, ItemStack stack, Direction direction) {
        return slot == 1;
    }

    public boolean func_191420_l() {
        return this.inventory.func_190926_b();
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("blulectric_furnace");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
        return new ContainerBlulectricFurnace(id, inventory, (IInventory)this, this.fields);
    }
}

