/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.block.machine.BlockLampRGB;
import com.bluepowermod.helper.MathHelper;
import com.bluepowermod.tile.BPTileEntityType;
import com.bluepowermod.tile.TileBase;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileLamp
extends TileBase {
    private byte[] bundledPower = new byte[16];

    public TileLamp() {
        super(BPTileEntityType.LAMP);
    }

    @Override
    protected void writeToPacketNBT(CompoundNBT tCompound) {
        if (this.func_195044_w().func_177230_c() instanceof BlockLampRGB) {
            tCompound.func_74774_a("red", this.bundledPower[MinecraftColor.RED.ordinal()]);
            tCompound.func_74774_a("green", this.bundledPower[MinecraftColor.GREEN.ordinal()]);
            tCompound.func_74774_a("blue", this.bundledPower[MinecraftColor.BLUE.ordinal()]);
        }
    }

    @Override
    protected void readFromPacketNBT(CompoundNBT tCompound) {
        if (tCompound.func_74764_b("red")) {
            byte[] pow = this.bundledPower;
            pow[MinecraftColor.RED.ordinal()] = tCompound.func_74771_c("red");
            pow[MinecraftColor.GREEN.ordinal()] = tCompound.func_74771_c("green");
            pow[MinecraftColor.BLUE.ordinal()] = tCompound.func_74771_c("blue");
            this.bundledPower = pow;
        }
    }

    public World func_145831_w() {
        return this.field_145850_b;
    }

    public BlockPos func_174877_v() {
        return this.field_174879_c;
    }

    public int getColor() {
        int r = MathHelper.map(this.bundledPower[MinecraftColor.RED.ordinal()] & 0xFF, 0, 255, 20, 235);
        int g = MathHelper.map(this.bundledPower[MinecraftColor.GREEN.ordinal()] & 0xFF, 0, 255, 20, 235);
        int b = MathHelper.map(this.bundledPower[MinecraftColor.BLUE.ordinal()] & 0xFF, 0, 255, 20, 235);
        return (r << 16) + (g << 8) + b;
    }

    @Override
    protected void onTileLoaded() {
        this.field_145850_b.func_180495_p(this.field_174879_c).func_215697_a(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), this.field_174879_c, true);
    }
}

