/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.functions.ApplyBonus;
import net.minecraft.world.storage.loot.functions.CopyName;
import net.minecraft.world.storage.loot.functions.CopyNbt;
import net.minecraft.world.storage.loot.functions.EnchantRandomly;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.ExplorationMap;
import net.minecraft.world.storage.loot.functions.ExplosionDecay;
import net.minecraft.world.storage.loot.functions.FillPlayerHead;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LimitCount;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetAttributes;
import net.minecraft.world.storage.loot.functions.SetContents;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetLootTable;
import net.minecraft.world.storage.loot.functions.SetLore;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraft.world.storage.loot.functions.SetName;
import net.minecraft.world.storage.loot.functions.SetStewEffect;
import net.minecraft.world.storage.loot.functions.Smelt;

public class LootFunctionManager {
    private static final Map<ResourceLocation, ILootFunction.Serializer<?>> field_186584_a = Maps.newHashMap();
    private static final Map<Class<? extends ILootFunction>, ILootFunction.Serializer<?>> field_186585_b = Maps.newHashMap();
    public static final BiFunction<ItemStack, LootContext, ItemStack> field_216242_a = (itemStack, lootContext) -> itemStack;

    public static <T extends ILootFunction> void func_186582_a(ILootFunction.Serializer<? extends T> serializer) {
        ResourceLocation resourceLocation = serializer.func_186529_a();
        Class<T> \u26032 = serializer.func_186531_b();
        if (field_186584_a.containsKey(resourceLocation)) {
            throw new IllegalArgumentException("Can't re-register item function name " + resourceLocation);
        }
        if (field_186585_b.containsKey(\u26032)) {
            throw new IllegalArgumentException("Can't re-register item function class " + \u26032.getName());
        }
        field_186584_a.put(resourceLocation, serializer);
        field_186585_b.put(\u26032, serializer);
    }

    public static ILootFunction.Serializer<?> func_186583_a(ResourceLocation resourceLocation) {
        ILootFunction.Serializer<?> serializer = field_186584_a.get(resourceLocation);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown loot item function '" + resourceLocation + "'");
        }
        return serializer;
    }

    public static <T extends ILootFunction> ILootFunction.Serializer<T> func_186581_a(T t) {
        ILootFunction.Serializer<?> serializer = field_186585_b.get(t.getClass());
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown loot item function " + t);
        }
        return serializer;
    }

    public static BiFunction<ItemStack, LootContext, ItemStack> func_216241_a(BiFunction<ItemStack, LootContext, ItemStack>[] biFunctionArray2) {
        BiFunction<ItemStack, LootContext, ItemStack>[] biFunctionArray2;
        switch (biFunctionArray2.length) {
            case 0: {
                return field_216242_a;
            }
            case 1: {
                return biFunctionArray2[0];
            }
            case 2: {
                BiFunction<ItemStack, LootContext, ItemStack> biFunction = biFunctionArray2[0];
                \u2603 = biFunctionArray2[1];
                return (itemStack, lootContext) -> (ItemStack)\u2603.apply((ItemStack)biFunction.apply((ItemStack)itemStack, (LootContext)lootContext), (LootContext)lootContext);
            }
        }
        return (itemStack2, lootContext) -> {
            ItemStack itemStack2;
            for (BiFunction biFunction : biFunctionArray2) {
                itemStack2 = (ItemStack)biFunction.apply(itemStack2, lootContext);
            }
            return itemStack2;
        };
    }

    static {
        LootFunctionManager.func_186582_a(new SetCount.Serializer());
        LootFunctionManager.func_186582_a(new EnchantWithLevels.Serializer());
        LootFunctionManager.func_186582_a(new EnchantRandomly.Serializer());
        LootFunctionManager.func_186582_a(new SetNBT.Serializer());
        LootFunctionManager.func_186582_a(new Smelt.Serializer());
        LootFunctionManager.func_186582_a(new LootingEnchantBonus.Serializer());
        LootFunctionManager.func_186582_a(new SetDamage.Serializer());
        LootFunctionManager.func_186582_a(new SetAttributes.Serializer());
        LootFunctionManager.func_186582_a(new SetName.Serializer());
        LootFunctionManager.func_186582_a(new ExplorationMap.Serializer());
        LootFunctionManager.func_186582_a(new SetStewEffect.Serializer());
        LootFunctionManager.func_186582_a(new CopyName.Serializer());
        LootFunctionManager.func_186582_a(new SetContents.Serializer());
        LootFunctionManager.func_186582_a(new LimitCount.Serializer());
        LootFunctionManager.func_186582_a(new ApplyBonus.Serializer());
        LootFunctionManager.func_186582_a(new SetLootTable.Serializer());
        LootFunctionManager.func_186582_a(new ExplosionDecay.Serializer());
        LootFunctionManager.func_186582_a(new SetLore.Serializer());
        LootFunctionManager.func_186582_a(new FillPlayerHead.Serializer());
        LootFunctionManager.func_186582_a(new CopyNbt.Serializer());
    }

    public static class Serializer
    implements JsonDeserializer<ILootFunction>,
    JsonSerializer<ILootFunction> {
        public ILootFunction deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "function");
            ResourceLocation \u26032 = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "function"));
            try {
                ILootFunction.Serializer<?> serializer = LootFunctionManager.func_186583_a(\u26032);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonSyntaxException("Unknown function '" + \u26032 + "'");
            }
            return serializer.func_212870_b_(jsonObject, jsonDeserializationContext);
        }

        public JsonElement serialize(ILootFunction iLootFunction, Type type, JsonSerializationContext jsonSerializationContext) {
            ILootFunction.Serializer<ILootFunction> serializer = LootFunctionManager.func_186581_a(iLootFunction);
            JsonObject \u26032 = new JsonObject();
            \u26032.addProperty("function", serializer.func_186529_a().toString());
            serializer.func_186532_a(\u26032, iLootFunction, jsonSerializationContext);
            return \u26032;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((ILootFunction)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

