/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.ScatteredStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.SwampHutPiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SwampHutStructure
extends ScatteredStructure<NoFeatureConfig> {
    private static final List<Biome.SpawnListEntry> field_202384_d = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_200759_ay, 1, 1, 1)});
    private static final List<Biome.SpawnListEntry> field_214559_aS = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_220360_g, 1, 1, 1)});

    public SwampHutStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> function) {
        super(function);
    }

    @Override
    public String func_143025_a() {
        return "Swamp_Hut";
    }

    @Override
    public int func_202367_b() {
        return 3;
    }

    @Override
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    @Override
    protected int func_202382_c() {
        return 14357620;
    }

    @Override
    public List<Biome.SpawnListEntry> func_202279_e() {
        return field_202384_d;
    }

    @Override
    public List<Biome.SpawnListEntry> func_214469_f() {
        return field_214559_aS;
    }

    public boolean func_202383_b(IWorld iWorld, BlockPos blockPos) {
        StructureStart structureStart = this.func_202364_a(iWorld, blockPos, true);
        if (structureStart == StructureStart.field_214630_a || !(structureStart instanceof Start) || structureStart.func_186161_c().isEmpty()) {
            return false;
        }
        StructurePiece \u26032 = structureStart.func_186161_c().get(0);
        return \u26032 instanceof SwampHutPiece;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int n, int n2, Biome biome, MutableBoundingBox mutableBoundingBox, int n3, long l) {
            super(structure, n, n2, biome, mutableBoundingBox, n3, l);
        }

        @Override
        public void func_214625_a(ChunkGenerator<?> chunkGenerator, TemplateManager templateManager, int n, int n2, Biome biome) {
            SwampHutPiece swampHutPiece = new SwampHutPiece(this.field_214631_d, n * 16, n2 * 16);
            this.field_75075_a.add(swampHutPiece);
            this.func_202500_a();
        }
    }
}

