/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive.fish;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class PufferfishEntity
extends AbstractFishEntity {
    private static final DataParameter<Integer> field_203716_b = EntityDataManager.func_187226_a(PufferfishEntity.class, DataSerializers.field_187192_b);
    private int field_203717_c;
    private int field_203718_bx;
    private static final Predicate<LivingEntity> field_205724_bA = livingEntity -> {
        if (livingEntity == null) {
            return false;
        }
        if (livingEntity instanceof PlayerEntity && (livingEntity.func_175149_v() || ((PlayerEntity)livingEntity).func_184812_l_())) {
            return false;
        }
        return livingEntity.func_70668_bt() != CreatureAttribute.field_203100_e;
    };

    public PufferfishEntity(EntityType<? extends PufferfishEntity> entityType, World world) {
        super((EntityType<? extends AbstractFishEntity>)entityType, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_203716_b, 0);
    }

    public int func_203715_dA() {
        return this.field_70180_af.func_187225_a(field_203716_b);
    }

    public void func_203714_a(int n) {
        this.field_70180_af.func_187227_b(field_203716_b, n);
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_203716_b.equals(dataParameter)) {
            this.func_213323_x_();
        }
        super.func_184206_a(dataParameter);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("PuffState", this.func_203715_dA());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_203714_a(compoundNBT.func_74762_e("PuffState"));
    }

    @Override
    protected ItemStack func_203707_dx() {
        return new ItemStack(Items.field_203795_aL);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, new PuffGoal(this));
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70613_aW()) {
            if (this.field_203717_c > 0) {
                if (this.func_203715_dA() == 0) {
                    this.func_184185_a(SoundEvents.field_203826_go, this.func_70599_aP(), this.func_70647_i());
                    this.func_203714_a(1);
                } else if (this.field_203717_c > 40 && this.func_203715_dA() == 1) {
                    this.func_184185_a(SoundEvents.field_203826_go, this.func_70599_aP(), this.func_70647_i());
                    this.func_203714_a(2);
                }
                ++this.field_203717_c;
            } else if (this.func_203715_dA() != 0) {
                if (this.field_203718_bx > 60 && this.func_203715_dA() == 2) {
                    this.func_184185_a(SoundEvents.field_203825_gn, this.func_70599_aP(), this.func_70647_i());
                    this.func_203714_a(1);
                } else if (this.field_203718_bx > 100 && this.func_203715_dA() == 1) {
                    this.func_184185_a(SoundEvents.field_203825_gn, this.func_70599_aP(), this.func_70647_i());
                    this.func_203714_a(0);
                }
                ++this.field_203718_bx;
            }
        }
        super.func_70071_h_();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70089_S() && this.func_203715_dA() > 0) {
            List<LivingEntity> list = this.field_70170_p.func_175647_a(MobEntity.class, this.func_174813_aQ().func_186662_g(0.3), field_205724_bA);
            for (MobEntity mobEntity : list) {
                if (!mobEntity.func_70089_S()) continue;
                this.func_205719_a(mobEntity);
            }
        }
    }

    private void func_205719_a(MobEntity mobEntity) {
        int n = this.func_203715_dA();
        if (mobEntity.func_70097_a(DamageSource.func_76358_a(this), 1 + n)) {
            mobEntity.func_195064_c(new EffectInstance(Effects.field_76436_u, 60 * n, 0));
            this.func_184185_a(SoundEvents.field_203830_gs, 1.0f, 1.0f);
        }
    }

    @Override
    public void func_70100_b_(PlayerEntity playerEntity) {
        int n = this.func_203715_dA();
        if (playerEntity instanceof ServerPlayerEntity && n > 0 && playerEntity.func_70097_a(DamageSource.func_76358_a(this), 1 + n)) {
            ((ServerPlayerEntity)playerEntity).field_71135_a.func_147359_a(new SChangeGameStatePacket(9, 0.0f));
            playerEntity.func_195064_c(new EffectInstance(Effects.field_76436_u, 60 * n, 0));
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203824_gm;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203827_gp;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_203829_gr;
    }

    @Override
    protected SoundEvent func_203701_dz() {
        return SoundEvents.field_203828_gq;
    }

    @Override
    public EntitySize func_213305_a(Pose pose) {
        return super.func_213305_a(pose).func_220313_a(PufferfishEntity.func_213806_q(this.func_203715_dA()));
    }

    private static float func_213806_q(int n) {
        switch (n) {
            case 1: {
                return 0.7f;
            }
            case 0: {
                return 0.5f;
            }
        }
        return 1.0f;
    }

    static class PuffGoal
    extends Goal {
        private final PufferfishEntity field_203789_a;

        public PuffGoal(PufferfishEntity pufferfishEntity) {
            this.field_203789_a = pufferfishEntity;
        }

        @Override
        public boolean func_75250_a() {
            List<LivingEntity> list = this.field_203789_a.field_70170_p.func_175647_a(LivingEntity.class, this.field_203789_a.func_174813_aQ().func_186662_g(2.0), field_205724_bA);
            return !list.isEmpty();
        }

        @Override
        public void func_75249_e() {
            this.field_203789_a.field_203717_c = 1;
            this.field_203789_a.field_203718_bx = 0;
        }

        @Override
        public void func_75251_c() {
            this.field_203789_a.field_203717_c = 0;
        }

        @Override
        public boolean func_75253_b() {
            List<LivingEntity> list = this.field_203789_a.field_70170_p.func_175647_a(LivingEntity.class, this.field_203789_a.func_174813_aQ().func_186662_g(2.0), field_205724_bA);
            return !list.isEmpty();
        }
    }
}

