/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageAtNightGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.AbstractGroupFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;

public class FoxEntity
extends AnimalEntity {
    private static final DataParameter<Integer> field_213523_bz = EntityDataManager.func_187226_a(FoxEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Byte> field_213524_bA = EntityDataManager.func_187226_a(FoxEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Optional<UUID>> field_213509_bB = EntityDataManager.func_187226_a(FoxEntity.class, DataSerializers.field_187203_m);
    private static final DataParameter<Optional<UUID>> field_213510_bD = EntityDataManager.func_187226_a(FoxEntity.class, DataSerializers.field_187203_m);
    private static final Predicate<ItemEntity> field_213511_bE = itemEntity -> !itemEntity.func_174874_s() && itemEntity.func_70089_S();
    private static final Predicate<Entity> field_213512_bF = entity -> {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.func_110144_aD() != null && livingEntity.func_142013_aG() < livingEntity.field_70173_aa + 600;
        }
        return false;
    };
    private static final Predicate<Entity> field_213513_bG = entity -> entity instanceof ChickenEntity || entity instanceof RabbitEntity;
    private static final Predicate<Entity> field_213514_bH = entity -> !entity.func_70093_af() && EntityPredicates.field_188444_d.test((Entity)entity);
    private Goal field_213515_bI;
    private Goal field_213516_bJ;
    private Goal field_213517_bK;
    private float field_213518_bL;
    private float field_213519_bM;
    private float field_213520_bN;
    private float field_213521_bO;
    private int field_213522_bP;

    public FoxEntity(EntityType<? extends FoxEntity> entityType, World world) {
        super((EntityType<? extends AnimalEntity>)entityType, world);
        this.field_70749_g = new LookHelperController();
        this.field_70765_h = new MoveHelperController();
        this.func_184644_a(PathNodeType.DANGER_OTHER, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_OTHER, 0.0f);
        this.func_98053_h(true);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_213509_bB, Optional.empty());
        this.field_70180_af.func_187214_a(field_213510_bD, Optional.empty());
        this.field_70180_af.func_187214_a(field_213523_bz, 0);
        this.field_70180_af.func_187214_a(field_213524_bA, (byte)0);
    }

    @Override
    protected void func_184651_r() {
        this.field_213515_bI = new NearestAttackableTargetGoal<AnimalEntity>(this, AnimalEntity.class, 10, false, false, livingEntity -> livingEntity instanceof ChickenEntity || livingEntity instanceof RabbitEntity);
        this.field_213516_bJ = new NearestAttackableTargetGoal<TurtleEntity>(this, TurtleEntity.class, 10, false, false, TurtleEntity.field_203029_bx);
        this.field_213517_bK = new NearestAttackableTargetGoal<AbstractFishEntity>(this, AbstractFishEntity.class, 20, false, false, livingEntity -> livingEntity instanceof AbstractGroupFishEntity);
        this.field_70714_bg.func_75776_a(0, new SwimGoal());
        this.field_70714_bg.func_75776_a(1, new JumpGoal());
        this.field_70714_bg.func_75776_a(2, new PanicGoal(2.2));
        this.field_70714_bg.func_75776_a(3, new AvoidEntityGoal<PlayerEntity>(this, PlayerEntity.class, 16.0f, 1.6, 1.4, livingEntity -> field_213514_bH.test((Entity)livingEntity) && !this.func_213468_c(livingEntity.func_110124_au()) && !this.func_213473_el()));
        this.field_70714_bg.func_75776_a(3, new AvoidEntityGoal<WolfEntity>(this, WolfEntity.class, 8.0f, 1.6, 1.4, livingEntity -> !((WolfEntity)livingEntity).func_70909_n() && !this.func_213473_el()));
        this.field_70714_bg.func_75776_a(4, new FollowTargetGoal());
        this.field_70714_bg.func_75776_a(5, new PounceGoal());
        this.field_70714_bg.func_75776_a(5, new MateGoal(1.0));
        this.field_70714_bg.func_75776_a(5, new FindShelterGoal(1.25));
        this.field_70714_bg.func_75776_a(6, new BiteGoal((double)1.2f, true));
        this.field_70714_bg.func_75776_a(6, new SleepGoal());
        this.field_70714_bg.func_75776_a(7, new FollowGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(8, new StrollGoal(32, 200));
        this.field_70714_bg.func_75776_a(9, new EatBerriesGoal((double)1.2f, 12, 2));
        this.field_70714_bg.func_75776_a(9, new LeapAtTargetGoal(this, 0.4f));
        this.field_70714_bg.func_75776_a(10, new WaterAvoidingRandomWalkingGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(10, new FindItemsGoal());
        this.field_70714_bg.func_75776_a(11, new WatchGoal(this, PlayerEntity.class, 24.0f));
        this.field_70714_bg.func_75776_a(12, new SitAndLookGoal());
        this.field_70715_bh.func_75776_a(3, new RevengeGoal(LivingEntity.class, false, false, livingEntity -> field_213512_bF.test((Entity)livingEntity) && !this.func_213468_c(livingEntity.func_110124_au())));
    }

    @Override
    public SoundEvent func_213353_d(ItemStack itemStack) {
        return SoundEvents.field_219634_dx;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70613_aW()) {
            Object object;
            ++this.field_213522_bP;
            ItemStack itemStack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (this.func_213464_j(itemStack)) {
                if (this.field_213522_bP > 600) {
                    object = itemStack.func_77950_b(this.field_70170_p, this);
                    if (!((ItemStack)object).func_190926_b()) {
                        this.func_184201_a(EquipmentSlotType.MAINHAND, (ItemStack)object);
                    }
                    this.field_213522_bP = 0;
                } else if (this.field_213522_bP > 560 && this.field_70146_Z.nextFloat() < 0.1f) {
                    this.func_184185_a(this.func_213353_d(itemStack), 1.0f, 1.0f);
                    this.field_70170_p.func_72960_a(this, (byte)45);
                }
            }
            if ((object = this.func_70638_az()) == null || !((LivingEntity)object).func_70089_S()) {
                this.func_213451_t(false);
                this.func_213502_u(false);
            }
        }
        if (this.func_70608_bn() || this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
            this.field_70704_bt = 0.0f;
        }
        super.func_70636_d();
        if (this.func_213473_el() && this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_184185_a(SoundEvents.field_219630_dt, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f;
    }

    private boolean func_213464_j(ItemStack itemStack) {
        return itemStack.func_77973_b().func_219971_r() && this.func_70638_az() == null && this.field_70122_E && !this.func_70608_bn();
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        if (this.field_70146_Z.nextFloat() < 0.2f) {
            float f = this.field_70146_Z.nextFloat();
            ItemStack \u26032 = f < 0.05f ? new ItemStack(Items.field_151166_bC) : (f < 0.2f ? new ItemStack(Items.field_151110_aK) : (f < 0.4f ? (this.field_70146_Z.nextBoolean() ? new ItemStack(Items.field_179556_br) : new ItemStack(Items.field_179555_bs)) : (f < 0.6f ? new ItemStack(Items.field_151015_O) : (f < 0.8f ? new ItemStack(Items.field_151116_aA) : new ItemStack(Items.field_151008_G)))));
            this.func_184201_a(EquipmentSlotType.MAINHAND, \u26032);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    @Override
    public FoxEntity func_90011_a(AgeableEntity ageableEntity) {
        FoxEntity foxEntity = EntityType.field_220356_B.func_200721_a(this.field_70170_p);
        foxEntity.func_213474_a(this.field_70146_Z.nextBoolean() ? this.func_213471_dV() : ((FoxEntity)ageableEntity).func_213471_dV());
        return foxEntity;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance2, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData2, @Nullable CompoundNBT compoundNBT) {
        DifficultyInstance difficultyInstance2;
        Biome biome = iWorld.func_180494_b(new BlockPos(this));
        Type \u26032 = Type.func_221086_a(biome);
        boolean \u26033 = false;
        if (iLivingEntityData2 instanceof FoxData) {
            \u26032 = ((FoxData)iLivingEntityData2).field_220366_a;
            if (((FoxData)iLivingEntityData2).field_220367_b >= 2) {
                \u26033 = true;
            } else {
                ++((FoxData)iLivingEntityData2).field_220367_b;
            }
        } else {
            ILivingEntityData iLivingEntityData2 = new FoxData(\u26032);
            ++((FoxData)iLivingEntityData2).field_220367_b;
        }
        this.func_213474_a(\u26032);
        if (\u26033) {
            this.func_70873_a(-24000);
        }
        this.func_213501_ej();
        this.func_180481_a(difficultyInstance2);
        return super.func_213386_a(iWorld, difficultyInstance2, spawnReason, iLivingEntityData2, compoundNBT);
    }

    private void func_213501_ej() {
        if (this.func_213471_dV() == Type.RED) {
            this.field_70715_bh.func_75776_a(4, this.field_213515_bI);
            this.field_70715_bh.func_75776_a(4, this.field_213516_bJ);
            this.field_70715_bh.func_75776_a(6, this.field_213517_bK);
        } else {
            this.field_70715_bh.func_75776_a(4, this.field_213517_bK);
            this.field_70715_bh.func_75776_a(6, this.field_213515_bI);
            this.field_70715_bh.func_75776_a(6, this.field_213516_bJ);
        }
    }

    @Override
    protected void func_175505_a(PlayerEntity playerEntity, ItemStack itemStack) {
        if (this.func_70877_b(itemStack)) {
            this.func_184185_a(this.func_213353_d(itemStack), 1.0f, 1.0f);
        }
        super.func_175505_a(playerEntity, itemStack);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        if (this.func_70631_g_()) {
            return entitySize.field_220316_b * 0.85f;
        }
        return 0.4f;
    }

    public Type func_213471_dV() {
        return Type.func_221080_a(this.field_70180_af.func_187225_a(field_213523_bz));
    }

    private void func_213474_a(Type type) {
        this.field_70180_af.func_187227_b(field_213523_bz, type.func_221083_c());
    }

    private List<UUID> func_213479_ek() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(this.field_70180_af.func_187225_a(field_213509_bB).orElse(null));
        arrayList.add(this.field_70180_af.func_187225_a(field_213510_bD).orElse(null));
        return arrayList;
    }

    private void func_213465_b(@Nullable UUID uUID) {
        if (this.field_70180_af.func_187225_a(field_213509_bB).isPresent()) {
            this.field_70180_af.func_187227_b(field_213510_bD, Optional.ofNullable(uUID));
        } else {
            this.field_70180_af.func_187227_b(field_213509_bB, Optional.ofNullable(uUID));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        super.func_213281_b(compoundNBT2);
        List<UUID> list = this.func_213479_ek();
        ListNBT \u26032 = new ListNBT();
        for (UUID uUID : list) {
            if (uUID == null) continue;
            \u26032.add(NBTUtil.func_186862_a(uUID));
        }
        compoundNBT2.func_218657_a("TrustedUUIDs", \u26032);
        compoundNBT2.func_74757_a("Sleeping", this.func_70608_bn());
        compoundNBT2.func_74778_a("Type", this.func_213471_dV().func_221082_a());
        compoundNBT2.func_74757_a("Sitting", this.func_213455_dW());
        compoundNBT2.func_74757_a("Crouching", this.func_213453_ef());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        super.func_70037_a(compoundNBT2);
        ListNBT listNBT = compoundNBT2.func_150295_c("TrustedUUIDs", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            this.func_213465_b(NBTUtil.func_186860_b(listNBT.func_150305_b(i)));
        }
        this.func_213485_x(compoundNBT2.func_74767_n("Sleeping"));
        this.func_213474_a(Type.func_221087_a(compoundNBT2.func_74779_i("Type")));
        this.func_213466_r(compoundNBT2.func_74767_n("Sitting"));
        this.func_213451_t(compoundNBT2.func_74767_n("Crouching"));
        this.func_213501_ej();
    }

    public boolean func_213455_dW() {
        return this.func_213507_r(1);
    }

    public void func_213466_r(boolean bl) {
        this.func_213505_d(1, bl);
    }

    public boolean func_213472_dX() {
        return this.func_213507_r(64);
    }

    private void func_213492_v(boolean bl) {
        this.func_213505_d(64, bl);
    }

    private boolean func_213473_el() {
        return this.func_213507_r(128);
    }

    private void func_213482_w(boolean bl) {
        this.func_213505_d(128, bl);
    }

    @Override
    public boolean func_70608_bn() {
        return this.func_213507_r(32);
    }

    private void func_213485_x(boolean bl) {
        this.func_213505_d(32, bl);
    }

    private void func_213505_d(int n, boolean bl) {
        if (bl) {
            this.field_70180_af.func_187227_b(field_213524_bA, (byte)(this.field_70180_af.func_187225_a(field_213524_bA) | n));
        } else {
            this.field_70180_af.func_187227_b(field_213524_bA, (byte)(this.field_70180_af.func_187225_a(field_213524_bA) & ~n));
        }
    }

    private boolean func_213507_r(int n) {
        return (this.field_70180_af.func_187225_a(field_213524_bA) & n) != 0;
    }

    @Override
    public boolean func_213365_e(ItemStack itemStack) {
        EquipmentSlotType equipmentSlotType = MobEntity.func_184640_d(itemStack);
        if (!this.func_184582_a(equipmentSlotType).func_190926_b()) {
            return false;
        }
        return equipmentSlotType == EquipmentSlotType.MAINHAND && super.func_213365_e(itemStack);
    }

    @Override
    protected boolean func_175448_a(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        ItemStack \u26032 = this.func_184582_a(EquipmentSlotType.MAINHAND);
        return \u26032.func_190926_b() || this.field_213522_bP > 0 && item.func_219971_r() && !\u26032.func_77973_b().func_219971_r();
    }

    private void func_213495_k(ItemStack itemStack) {
        if (itemStack.func_190926_b() || this.field_70170_p.field_72995_K) {
            return;
        }
        ItemEntity itemEntity = new ItemEntity(this.field_70170_p, this.field_70165_t + this.func_70040_Z().field_72450_a, this.field_70163_u + 1.0, this.field_70161_v + this.func_70040_Z().field_72449_c, itemStack);
        itemEntity.func_174867_a(40);
        itemEntity.func_200216_c(this.func_110124_au());
        this.func_184185_a(SoundEvents.field_219629_dC, 1.0f, 1.0f);
        this.field_70170_p.func_217376_c(itemEntity);
    }

    private void func_213486_l(ItemStack itemStack) {
        ItemEntity itemEntity = new ItemEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, itemStack);
        this.field_70170_p.func_217376_c(itemEntity);
    }

    @Override
    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.func_92059_d();
        if (this.func_175448_a(itemStack)) {
            int n = itemStack.func_190916_E();
            if (n > 1) {
                this.func_213486_l(itemStack.func_77979_a(n - 1));
            }
            this.func_213495_k(this.func_184582_a(EquipmentSlotType.MAINHAND));
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemStack.func_77979_a(1));
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a(itemEntity, itemStack.func_190916_E());
            itemEntity.func_70106_y();
            this.field_213522_bP = 0;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70613_aW()) {
            boolean bl = this.func_70090_H();
            if (bl || this.func_70638_az() != null || this.field_70170_p.func_72911_I()) {
                this.func_213454_em();
            }
            if (bl || this.func_70608_bn()) {
                this.func_213466_r(false);
            }
            if (this.func_213472_dX() && this.field_70170_p.field_73012_v.nextFloat() < 0.2f) {
                BlockPos blockPos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                BlockState \u26032 = this.field_70170_p.func_180495_p(blockPos);
                this.field_70170_p.func_217379_c(2001, blockPos, Block.func_196246_j(\u26032));
            }
        }
        this.field_213519_bM = this.field_213518_bL;
        this.field_213518_bL = this.func_213467_eg() ? (this.field_213518_bL += (1.0f - this.field_213518_bL) * 0.4f) : (this.field_213518_bL += (0.0f - this.field_213518_bL) * 0.4f);
        this.field_213521_bO = this.field_213520_bN;
        if (this.func_213453_ef()) {
            this.field_213520_bN += 0.2f;
            if (this.field_213520_bN > 3.0f) {
                this.field_213520_bN = 3.0f;
            }
        } else {
            this.field_213520_bN = 0.0f;
        }
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return itemStack.func_77973_b() == Items.field_222112_pR;
    }

    @Override
    protected void func_213406_a(PlayerEntity playerEntity, AgeableEntity ageableEntity) {
        ((FoxEntity)ageableEntity).func_213465_b(playerEntity.func_110124_au());
    }

    public boolean func_213480_dY() {
        return this.func_213507_r(16);
    }

    public void func_213461_s(boolean bl) {
        this.func_213505_d(16, bl);
    }

    public boolean func_213490_ee() {
        return this.field_213520_bN == 3.0f;
    }

    public void func_213451_t(boolean bl) {
        this.func_213505_d(4, bl);
    }

    public boolean func_213453_ef() {
        return this.func_213507_r(4);
    }

    public void func_213502_u(boolean bl) {
        this.func_213505_d(8, bl);
    }

    public boolean func_213467_eg() {
        return this.func_213507_r(8);
    }

    @Override
    public void func_70624_b(@Nullable LivingEntity livingEntity) {
        if (this.func_213473_el() && livingEntity == null) {
            this.func_213482_w(false);
        }
        super.func_70624_b(livingEntity);
    }

    @Override
    public void func_180430_e(float f, float f2) {
        BlockState blockState;
        int n = MathHelper.func_76123_f((f - 5.0f) * f2);
        if (n <= 0) {
            return;
        }
        this.func_70097_a(DamageSource.field_76379_h, n);
        if (this.func_184207_aI()) {
            for (Entity entity : this.func_184182_bu()) {
                entity.func_70097_a(DamageSource.field_76379_h, n);
            }
        }
        if (!(blockState = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 0.2 - (double)this.field_70126_B, this.field_70161_v))).func_196958_f() && !this.func_174814_R()) {
            SoundType soundType = blockState.func_215695_r();
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundType.func_185844_d(), this.func_184176_by(), soundType.func_185843_a() * 0.5f, soundType.func_185847_b() * 0.75f);
        }
    }

    private void func_213454_em() {
        this.func_213485_x(false);
    }

    private void func_213499_en() {
        this.func_213502_u(false);
        this.func_213451_t(false);
        this.func_213466_r(false);
        this.func_213485_x(false);
        this.func_213482_w(false);
        this.func_213492_v(false);
    }

    private boolean func_213478_eo() {
        return !this.func_70608_bn() && !this.func_213455_dW() && !this.func_213472_dX();
    }

    @Override
    public void func_70642_aH() {
        SoundEvent soundEvent = this.func_184639_G();
        if (soundEvent == SoundEvents.field_219636_dz) {
            this.func_184185_a(soundEvent, 2.0f, this.func_70647_i());
        } else {
            super.func_70642_aH();
        }
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        List<Entity> list;
        if (this.func_70608_bn()) {
            return SoundEvents.field_219627_dA;
        }
        if (!this.field_70170_p.func_72935_r() && this.field_70146_Z.nextFloat() < 0.1f && (list = this.field_70170_p.func_175647_a(PlayerEntity.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), EntityPredicates.field_180132_d)).isEmpty()) {
            return SoundEvents.field_219636_dz;
        }
        return SoundEvents.field_219631_du;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_219635_dy;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219633_dw;
    }

    private boolean func_213468_c(UUID uUID) {
        return this.func_213479_ek().contains(uUID);
    }

    @Override
    protected void func_213345_d(DamageSource damageSource) {
        ItemStack itemStack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (!itemStack.func_190926_b()) {
            this.func_199701_a_(itemStack);
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }
        super.func_213345_d(damageSource);
    }

    public static boolean func_213481_a(FoxEntity foxEntity, LivingEntity livingEntity) {
        double d = livingEntity.field_70161_v - foxEntity.field_70161_v;
        \u2603 = livingEntity.field_70165_t - foxEntity.field_70165_t;
        \u2603 = d / \u2603;
        int \u26032 = 6;
        for (int i = 0; i < 6; ++i) {
            double d2 = \u2603 == 0.0 ? 0.0 : d * (double)((float)i / 6.0f);
            \u2603 = \u2603 == 0.0 ? \u2603 * (double)((float)i / 6.0f) : d2 / \u2603;
            for (int j = 1; j < 4; ++j) {
                if (foxEntity.field_70170_p.func_180495_p(new BlockPos(foxEntity.field_70165_t + \u2603, foxEntity.field_70163_u + (double)j, foxEntity.field_70161_v + d2)).func_185904_a().func_76222_j()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public /* synthetic */ AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return this.func_90011_a(ageableEntity);
    }

    class WatchGoal
    extends LookAtGoal {
        public WatchGoal(MobEntity mobEntity, Class<? extends LivingEntity> clazz, float f) {
            super(mobEntity, clazz, f);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !FoxEntity.this.func_213472_dX() && !FoxEntity.this.func_213467_eg();
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && !FoxEntity.this.func_213472_dX() && !FoxEntity.this.func_213467_eg();
        }
    }

    class FollowGoal
    extends FollowParentGoal {
        private final FoxEntity field_220706_b;

        public FollowGoal(FoxEntity foxEntity2, double d) {
            super(foxEntity2, d);
            this.field_220706_b = foxEntity2;
        }

        @Override
        public boolean func_75250_a() {
            return !this.field_220706_b.func_213473_el() && super.func_75250_a();
        }

        @Override
        public boolean func_75253_b() {
            return !this.field_220706_b.func_213473_el() && super.func_75253_b();
        }

        @Override
        public void func_75249_e() {
            this.field_220706_b.func_213499_en();
            super.func_75249_e();
        }
    }

    public class LookHelperController
    extends LookController {
        public LookHelperController() {
            super(FoxEntity.this);
        }

        @Override
        public void func_75649_a() {
            if (!FoxEntity.this.func_70608_bn()) {
                super.func_75649_a();
            }
        }

        @Override
        protected boolean func_220680_b() {
            return !FoxEntity.this.func_213480_dY() && !FoxEntity.this.func_213453_ef() && !FoxEntity.this.func_213467_eg() & !FoxEntity.this.func_213472_dX();
        }
    }

    public class PounceGoal
    extends net.minecraft.entity.ai.goal.JumpGoal {
        @Override
        public boolean func_75250_a() {
            if (!FoxEntity.this.func_213490_ee()) {
                return false;
            }
            LivingEntity livingEntity = FoxEntity.this.func_70638_az();
            if (livingEntity == null || !livingEntity.func_70089_S()) {
                return false;
            }
            if (livingEntity.func_184172_bi() != livingEntity.func_174811_aO()) {
                return false;
            }
            boolean \u26032 = FoxEntity.func_213481_a(FoxEntity.this, livingEntity);
            if (!\u26032) {
                FoxEntity.this.func_70661_as().func_75494_a(livingEntity, 0);
                FoxEntity.this.func_213451_t(false);
                FoxEntity.this.func_213502_u(false);
            }
            return \u26032;
        }

        @Override
        public boolean func_75253_b() {
            LivingEntity livingEntity = FoxEntity.this.func_70638_az();
            if (livingEntity == null || !livingEntity.func_70089_S()) {
                return false;
            }
            double \u26032 = FoxEntity.this.func_213322_ci().field_72448_b;
            return !(\u26032 * \u26032 < (double)0.05f && Math.abs(FoxEntity.this.field_70125_A) < 15.0f && FoxEntity.this.field_70122_E || FoxEntity.this.func_213472_dX());
        }

        @Override
        public boolean func_220685_C_() {
            return false;
        }

        @Override
        public void func_75249_e() {
            FoxEntity.this.func_70637_d(true);
            FoxEntity.this.func_213461_s(true);
            FoxEntity.this.func_213502_u(false);
            LivingEntity livingEntity = FoxEntity.this.func_70638_az();
            FoxEntity.this.func_70671_ap().func_75651_a(livingEntity, 60.0f, 30.0f);
            Vec3d \u26032 = new Vec3d(livingEntity.field_70165_t - FoxEntity.this.field_70165_t, livingEntity.field_70163_u - FoxEntity.this.field_70163_u, livingEntity.field_70161_v - FoxEntity.this.field_70161_v).func_72432_b();
            FoxEntity.this.func_213317_d(FoxEntity.this.func_213322_ci().func_72441_c(\u26032.field_72450_a * 0.8, 0.9, \u26032.field_72449_c * 0.8));
            FoxEntity.this.func_70661_as().func_75499_g();
        }

        @Override
        public void func_75251_c() {
            FoxEntity.this.func_213451_t(false);
            FoxEntity.this.field_213520_bN = 0.0f;
            FoxEntity.this.field_213521_bO = 0.0f;
            FoxEntity.this.func_213502_u(false);
            FoxEntity.this.func_213461_s(false);
        }

        @Override
        public void func_75246_d() {
            LivingEntity livingEntity = FoxEntity.this.func_70638_az();
            if (livingEntity != null) {
                FoxEntity.this.func_70671_ap().func_75651_a(livingEntity, 60.0f, 30.0f);
            }
            if (!FoxEntity.this.func_213472_dX()) {
                Vec3d vec3d = FoxEntity.this.func_213322_ci();
                if (vec3d.field_72448_b * vec3d.field_72448_b < (double)0.03f && FoxEntity.this.field_70125_A != 0.0f) {
                    FoxEntity.this.field_70125_A = this.func_205147_a(FoxEntity.this.field_70125_A, 0.0f, 0.2f);
                } else {
                    double d = Math.sqrt(Entity.func_213296_b(vec3d));
                    \u2603 = Math.signum(-vec3d.field_72448_b) * Math.acos(d / vec3d.func_72433_c()) * 57.2957763671875;
                    FoxEntity.this.field_70125_A = (float)\u2603;
                }
            }
            if (livingEntity != null && FoxEntity.this.func_70032_d(livingEntity) <= 2.0f) {
                FoxEntity.this.func_70652_k(livingEntity);
            } else if (FoxEntity.this.field_70125_A > 0.0f && FoxEntity.this.field_70122_E && (float)FoxEntity.this.func_213322_ci().field_72448_b != 0.0f && FoxEntity.this.field_70170_p.func_180495_p(new BlockPos(FoxEntity.this)).func_177230_c() == Blocks.field_150433_aE) {
                FoxEntity.this.field_70125_A = 60.0f;
                FoxEntity.this.func_70624_b(null);
                FoxEntity.this.func_213492_v(true);
            }
        }
    }

    class SwimGoal
    extends net.minecraft.entity.ai.goal.SwimGoal {
        public SwimGoal() {
            super(FoxEntity.this);
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            FoxEntity.this.func_213499_en();
        }

        @Override
        public boolean func_75250_a() {
            return FoxEntity.this.func_70090_H() && FoxEntity.this.func_212107_bY() > 0.25 || FoxEntity.this.func_180799_ab();
        }
    }

    class StrollGoal
    extends MoveThroughVillageAtNightGoal {
        public StrollGoal(int n, int n2) {
            super(FoxEntity.this, n2);
        }

        @Override
        public void func_75249_e() {
            FoxEntity.this.func_213499_en();
            super.func_75249_e();
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && this.func_220759_g();
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && this.func_220759_g();
        }

        private boolean func_220759_g() {
            return !FoxEntity.this.func_70608_bn() && !FoxEntity.this.func_213455_dW() && !FoxEntity.this.func_213473_el() && FoxEntity.this.func_70638_az() == null;
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal(double d) {
            super(FoxEntity.this, d);
        }

        @Override
        public boolean func_75250_a() {
            return !FoxEntity.this.func_213473_el() && super.func_75250_a();
        }
    }

    class JumpGoal
    extends Goal {
        int field_220811_a;

        public JumpGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            return FoxEntity.this.func_213472_dX();
        }

        @Override
        public boolean func_75253_b() {
            return this.func_75250_a() && this.field_220811_a > 0;
        }

        @Override
        public void func_75249_e() {
            this.field_220811_a = 40;
        }

        @Override
        public void func_75251_c() {
            FoxEntity.this.func_213492_v(false);
        }

        @Override
        public void func_75246_d() {
            --this.field_220811_a;
        }
    }

    public static class FoxData
    implements ILivingEntityData {
        public final Type field_220366_a;
        public int field_220367_b;

        public FoxData(Type type) {
            this.field_220366_a = type;
        }
    }

    public class EatBerriesGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public EatBerriesGoal(double d, int n, int n2) {
            super(FoxEntity.this, d, n, n2);
        }

        @Override
        public double func_203110_f() {
            return 2.0;
        }

        @Override
        public boolean func_203108_i() {
            return this.field_179493_e % 100 == 0;
        }

        @Override
        protected boolean func_179488_a(IWorldReader iWorldReader, BlockPos blockPos) {
            BlockState blockState = iWorldReader.func_180495_p(blockPos);
            return blockState.func_177230_c() == Blocks.field_222434_lW && blockState.func_177229_b(SweetBerryBushBlock.field_220125_a) >= 2;
        }

        @Override
        public void func_75246_d() {
            if (this.func_179487_f()) {
                if (this.field_220731_g >= 40) {
                    this.func_220730_m();
                } else {
                    ++this.field_220731_g;
                }
            } else if (!this.func_179487_f() && FoxEntity.this.field_70146_Z.nextFloat() < 0.05f) {
                FoxEntity.this.func_184185_a(SoundEvents.field_219628_dB, 1.0f, 1.0f);
            }
            super.func_75246_d();
        }

        protected void func_220730_m() {
            if (!FoxEntity.this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
                return;
            }
            BlockState blockState = FoxEntity.this.field_70170_p.func_180495_p(this.field_179494_b);
            if (blockState.func_177230_c() != Blocks.field_222434_lW) {
                return;
            }
            int \u26032 = blockState.func_177229_b(SweetBerryBushBlock.field_220125_a);
            blockState.func_206870_a(SweetBerryBushBlock.field_220125_a, 1);
            int \u26033 = 1 + FoxEntity.this.field_70170_p.field_73012_v.nextInt(2) + (\u26032 == 3 ? 1 : 0);
            ItemStack \u26034 = FoxEntity.this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (\u26034.func_190926_b()) {
                FoxEntity.this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_222112_pR));
                --\u26033;
            }
            if (\u26033 > 0) {
                Block.func_180635_a(FoxEntity.this.field_70170_p, this.field_179494_b, new ItemStack(Items.field_222112_pR, \u26033));
            }
            FoxEntity.this.func_184185_a(SoundEvents.field_219693_lB, 1.0f, 1.0f);
            FoxEntity.this.field_70170_p.func_180501_a(this.field_179494_b, (BlockState)blockState.func_206870_a(SweetBerryBushBlock.field_220125_a, 1), 2);
        }

        @Override
        public boolean func_75250_a() {
            return !FoxEntity.this.func_70608_bn() && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            this.field_220731_g = 0;
            FoxEntity.this.func_213466_r(false);
            super.func_75249_e();
        }
    }

    class SitAndLookGoal
    extends BaseGoal {
        private double field_220819_c;
        private double field_220820_d;
        private int field_220821_e;
        private int field_220822_f;

        public SitAndLookGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            return FoxEntity.this.func_70643_av() == null && FoxEntity.this.func_70681_au().nextFloat() < 0.02f && !FoxEntity.this.func_70608_bn() && FoxEntity.this.func_70638_az() == null && FoxEntity.this.func_70661_as().func_75500_f() && !this.func_220814_h() && !FoxEntity.this.func_213480_dY() && !FoxEntity.this.func_213453_ef();
        }

        @Override
        public boolean func_75253_b() {
            return this.field_220822_f > 0;
        }

        @Override
        public void func_75249_e() {
            this.func_220817_j();
            this.field_220822_f = 2 + FoxEntity.this.func_70681_au().nextInt(3);
            FoxEntity.this.func_213466_r(true);
            FoxEntity.this.func_70661_as().func_75499_g();
        }

        @Override
        public void func_75251_c() {
            FoxEntity.this.func_213466_r(false);
        }

        @Override
        public void func_75246_d() {
            --this.field_220821_e;
            if (this.field_220821_e <= 0) {
                --this.field_220822_f;
                this.func_220817_j();
            }
            FoxEntity.this.func_70671_ap().func_75650_a(FoxEntity.this.field_70165_t + this.field_220819_c, FoxEntity.this.field_70163_u + (double)FoxEntity.this.func_70047_e(), FoxEntity.this.field_70161_v + this.field_220820_d, FoxEntity.this.func_184649_cE(), FoxEntity.this.func_70646_bf());
        }

        private void func_220817_j() {
            double d = Math.PI * 2 * FoxEntity.this.func_70681_au().nextDouble();
            this.field_220819_c = Math.cos(d);
            this.field_220820_d = Math.sin(d);
            this.field_220821_e = 80 + FoxEntity.this.func_70681_au().nextInt(20);
        }
    }

    class SleepGoal
    extends BaseGoal {
        private int field_220825_c;

        public SleepGoal() {
            this.field_220825_c = FoxEntity.this.field_70146_Z.nextInt(140);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        public boolean func_75250_a() {
            if (FoxEntity.this.field_70702_br != 0.0f || FoxEntity.this.field_70701_bs != 0.0f || FoxEntity.this.field_191988_bg != 0.0f) {
                return false;
            }
            return this.func_220823_j() || FoxEntity.this.func_70608_bn();
        }

        @Override
        public boolean func_75253_b() {
            return this.func_220823_j();
        }

        private boolean func_220823_j() {
            if (this.field_220825_c > 0) {
                --this.field_220825_c;
                return false;
            }
            return FoxEntity.this.field_70170_p.func_72935_r() && this.func_220813_g() && !this.func_220814_h();
        }

        @Override
        public void func_75251_c() {
            this.field_220825_c = FoxEntity.this.field_70146_Z.nextInt(140);
            FoxEntity.this.func_213499_en();
        }

        @Override
        public void func_75249_e() {
            FoxEntity.this.func_213466_r(false);
            FoxEntity.this.func_213451_t(false);
            FoxEntity.this.func_213502_u(false);
            FoxEntity.this.func_70637_d(false);
            FoxEntity.this.func_213485_x(true);
            FoxEntity.this.func_70661_as().func_75499_g();
            FoxEntity.this.func_70605_aq().func_75642_a(FoxEntity.this.field_70165_t, FoxEntity.this.field_70163_u, FoxEntity.this.field_70161_v, 0.0);
        }
    }

    abstract class BaseGoal
    extends Goal {
        private final EntityPredicate field_220816_b;

        private BaseGoal() {
            this.field_220816_b = new EntityPredicate().func_221013_a(12.0).func_221014_c().func_221012_a(new AlertablePredicate());
        }

        protected boolean func_220813_g() {
            BlockPos blockPos = new BlockPos(FoxEntity.this);
            return !FoxEntity.this.field_70170_p.func_217337_f(blockPos) && FoxEntity.this.func_180484_a(blockPos) >= 0.0f;
        }

        protected boolean func_220814_h() {
            return !FoxEntity.this.field_70170_p.func_217374_a(LivingEntity.class, this.field_220816_b, FoxEntity.this, FoxEntity.this.func_174813_aQ().func_72314_b(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class AlertablePredicate
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity livingEntity) {
            if (livingEntity instanceof FoxEntity) {
                return false;
            }
            if (livingEntity instanceof ChickenEntity || livingEntity instanceof RabbitEntity || livingEntity instanceof MonsterEntity) {
                return true;
            }
            if (livingEntity instanceof TameableEntity) {
                return !((TameableEntity)livingEntity).func_70909_n();
            }
            if (livingEntity instanceof PlayerEntity && (livingEntity.func_175149_v() || ((PlayerEntity)livingEntity).func_184812_l_())) {
                return false;
            }
            if (FoxEntity.this.func_213468_c(livingEntity.func_110124_au())) {
                return false;
            }
            return !livingEntity.func_70608_bn() && !livingEntity.func_70093_af();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((LivingEntity)object);
        }
    }

    class FindShelterGoal
    extends FleeSunGoal {
        private int field_220704_c;

        public FindShelterGoal(double d) {
            super(FoxEntity.this, d);
            this.field_220704_c = 100;
        }

        @Override
        public boolean func_75250_a() {
            if (FoxEntity.this.func_70608_bn() || this.field_75372_a.func_70638_az() != null) {
                return false;
            }
            if (FoxEntity.this.field_70170_p.func_72911_I()) {
                return true;
            }
            if (this.field_220704_c > 0) {
                --this.field_220704_c;
                return false;
            }
            this.field_220704_c = 100;
            BlockPos blockPos = new BlockPos(this.field_75372_a);
            return FoxEntity.this.field_70170_p.func_72935_r() && FoxEntity.this.field_70170_p.func_217337_f(blockPos) && !((ServerWorld)FoxEntity.this.field_70170_p).func_217483_b_(blockPos) && this.func_220702_g();
        }

        @Override
        public void func_75249_e() {
            FoxEntity.this.func_213499_en();
            super.func_75249_e();
        }
    }

    class RevengeGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        @Nullable
        private LivingEntity field_220786_j;
        private LivingEntity field_220787_k;
        private int field_220788_l;

        public RevengeGoal(Class<LivingEntity> clazz, boolean bl, boolean bl2, @Nullable Predicate<LivingEntity> predicate) {
            super(FoxEntity.this, clazz, 10, bl, bl2, predicate);
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_75308_c > 0 && this.field_75299_d.func_70681_au().nextInt(this.field_75308_c) != 0) {
                return false;
            }
            for (UUID uUID : FoxEntity.this.func_213479_ek()) {
                if (uUID == null || !(FoxEntity.this.field_70170_p instanceof ServerWorld) || !((\u2603 = ((ServerWorld)FoxEntity.this.field_70170_p).func_217461_a(uUID)) instanceof LivingEntity)) continue;
                this.field_220787_k = \u2603 = (LivingEntity)\u2603;
                this.field_220786_j = \u2603.func_70643_av();
                int n = \u2603.func_142015_aE();
                return n != this.field_220788_l && this.func_220777_a(this.field_220786_j, this.field_220779_d);
            }
            return false;
        }

        @Override
        public void func_75249_e() {
            FoxEntity.this.func_70624_b(this.field_220786_j);
            this.field_75309_a = this.field_220786_j;
            if (this.field_220787_k != null) {
                this.field_220788_l = this.field_220787_k.func_142015_aE();
            }
            FoxEntity.this.func_184185_a(SoundEvents.field_219630_dt, 1.0f, 1.0f);
            FoxEntity.this.func_213482_w(true);
            FoxEntity.this.func_213454_em();
            super.func_75249_e();
        }
    }

    class MateGoal
    extends BreedGoal {
        public MateGoal(double d) {
            super(FoxEntity.this, d);
        }

        @Override
        public void func_75249_e() {
            ((FoxEntity)this.field_75390_d).func_213499_en();
            ((FoxEntity)this.field_75391_e).func_213499_en();
            super.func_75249_e();
        }

        @Override
        protected void func_75388_i() {
            FoxEntity foxEntity = (FoxEntity)this.field_75390_d.func_90011_a(this.field_75391_e);
            if (foxEntity == null) {
                return;
            }
            ServerPlayerEntity \u26032 = this.field_75390_d.func_191993_do();
            ServerPlayerEntity \u26033 = this.field_75391_e.func_191993_do();
            ServerPlayerEntity \u26034 = \u26032;
            if (\u26032 != null) {
                foxEntity.func_213465_b(\u26032.func_110124_au());
            } else {
                \u26034 = \u26033;
            }
            if (\u26033 != null && \u26032 != \u26033) {
                foxEntity.func_213465_b(\u26033.func_110124_au());
            }
            if (\u26034 != null) {
                \u26034.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(\u26034, this.field_75390_d, this.field_75391_e, foxEntity);
            }
            int \u26035 = 6000;
            this.field_75390_d.func_70873_a(6000);
            this.field_75391_e.func_70873_a(6000);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            foxEntity.func_70873_a(-24000);
            foxEntity.func_70012_b(this.field_75390_d.field_70165_t, this.field_75390_d.field_70163_u, this.field_75390_d.field_70161_v, 0.0f, 0.0f);
            this.field_75394_a.func_217376_c(foxEntity);
            this.field_75394_a.func_72960_a(this.field_75390_d, (byte)18);
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c(new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.field_70165_t, this.field_75390_d.field_70163_u, this.field_75390_d.field_70161_v, this.field_75390_d.func_70681_au().nextInt(7) + 1));
            }
        }
    }

    class BiteGoal
    extends MeleeAttackGoal {
        public BiteGoal(double d, boolean bl) {
            super(FoxEntity.this, d, bl);
        }

        @Override
        protected void func_190102_a(LivingEntity livingEntity, double d) {
            \u2603 = this.func_179512_a(livingEntity);
            if (d <= \u2603 && this.field_75439_d <= 0) {
                this.field_75439_d = 20;
                this.field_75441_b.func_70652_k(livingEntity);
                FoxEntity.this.func_184185_a(SoundEvents.field_219632_dv, 1.0f, 1.0f);
            }
        }

        @Override
        public void func_75249_e() {
            FoxEntity.this.func_213502_u(false);
            super.func_75249_e();
        }

        @Override
        public boolean func_75250_a() {
            return !FoxEntity.this.func_213455_dW() && !FoxEntity.this.func_70608_bn() && !FoxEntity.this.func_213453_ef() && !FoxEntity.this.func_213472_dX() && super.func_75250_a();
        }
    }

    class FollowTargetGoal
    extends Goal {
        public FollowTargetGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            if (FoxEntity.this.func_70608_bn()) {
                return false;
            }
            LivingEntity livingEntity = FoxEntity.this.func_70638_az();
            return livingEntity != null && livingEntity.func_70089_S() && field_213513_bG.test(livingEntity) && FoxEntity.this.func_70068_e(livingEntity) > 36.0 && !FoxEntity.this.func_213453_ef() && !FoxEntity.this.func_213467_eg() && !FoxEntity.this.field_70703_bu;
        }

        @Override
        public void func_75249_e() {
            FoxEntity.this.func_213466_r(false);
            FoxEntity.this.func_213492_v(false);
        }

        @Override
        public void func_75251_c() {
            LivingEntity livingEntity = FoxEntity.this.func_70638_az();
            if (livingEntity != null && FoxEntity.func_213481_a(FoxEntity.this, livingEntity)) {
                FoxEntity.this.func_213502_u(true);
                FoxEntity.this.func_213451_t(true);
                FoxEntity.this.func_70661_as().func_75499_g();
                FoxEntity.this.func_70671_ap().func_75651_a(livingEntity, FoxEntity.this.func_184649_cE(), FoxEntity.this.func_70646_bf());
            } else {
                FoxEntity.this.func_213502_u(false);
                FoxEntity.this.func_213451_t(false);
            }
        }

        @Override
        public void func_75246_d() {
            LivingEntity livingEntity = FoxEntity.this.func_70638_az();
            FoxEntity.this.func_70671_ap().func_75651_a(livingEntity, FoxEntity.this.func_184649_cE(), FoxEntity.this.func_70646_bf());
            if (FoxEntity.this.func_70068_e(livingEntity) <= 36.0) {
                FoxEntity.this.func_213502_u(true);
                FoxEntity.this.func_213451_t(true);
                FoxEntity.this.func_70661_as().func_75499_g();
            } else {
                FoxEntity.this.func_70661_as().func_75497_a(livingEntity, 1.5);
            }
        }
    }

    class MoveHelperController
    extends MovementController {
        public MoveHelperController() {
            super(FoxEntity.this);
        }

        @Override
        public void func_75641_c() {
            if (FoxEntity.this.func_213478_eo()) {
                super.func_75641_c();
            }
        }
    }

    class FindItemsGoal
    extends Goal {
        public FindItemsGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            if (!FoxEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                return false;
            }
            if (FoxEntity.this.func_70638_az() != null || FoxEntity.this.func_70643_av() != null) {
                return false;
            }
            if (!FoxEntity.this.func_213478_eo()) {
                return false;
            }
            if (FoxEntity.this.func_70681_au().nextInt(10) != 0) {
                return false;
            }
            List<ItemEntity> list = FoxEntity.this.field_70170_p.func_175647_a(ItemEntity.class, FoxEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_213511_bE);
            return !list.isEmpty() && FoxEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b();
        }

        @Override
        public void func_75246_d() {
            List<ItemEntity> list = FoxEntity.this.field_70170_p.func_175647_a(ItemEntity.class, FoxEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_213511_bE);
            ItemStack \u26032 = FoxEntity.this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (\u26032.func_190926_b() && !list.isEmpty()) {
                FoxEntity.this.func_70661_as().func_75497_a(list.get(0), 1.2f);
            }
        }

        @Override
        public void func_75249_e() {
            List<ItemEntity> list = FoxEntity.this.field_70170_p.func_175647_a(ItemEntity.class, FoxEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_213511_bE);
            if (!list.isEmpty()) {
                FoxEntity.this.func_70661_as().func_75497_a(list.get(0), 1.2f);
            }
        }
    }

    public static enum Type {
        RED(0, "red", Biomes.field_76768_g, Biomes.field_76784_u, Biomes.field_150590_f, Biomes.field_150578_U, Biomes.field_185432_ad, Biomes.field_150581_V, Biomes.field_185433_ae),
        SNOW(1, "snow", Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_185431_ac);

        private static final Type[] field_221088_c;
        private static final Map<String, Type> field_221089_d;
        private final int field_221090_e;
        private final String field_221091_f;
        private final List<Biome> field_221092_g;

        private Type(int n2, String string2, Biome ... biomeArray) {
            this.field_221090_e = n2;
            this.field_221091_f = string2;
            this.field_221092_g = Arrays.asList(biomeArray);
        }

        public String func_221082_a() {
            return this.field_221091_f;
        }

        public List<Biome> func_221085_b() {
            return this.field_221092_g;
        }

        public int func_221083_c() {
            return this.field_221090_e;
        }

        public static Type func_221087_a(String string) {
            return field_221089_d.getOrDefault(string, RED);
        }

        public static Type func_221080_a(int n) {
            if (n < 0 || n > field_221088_c.length) {
                n = 0;
            }
            return field_221088_c[n];
        }

        public static Type func_221086_a(Biome biome) {
            return SNOW.func_221085_b().contains(biome) ? SNOW : RED;
        }

        static {
            field_221088_c = (Type[])Arrays.stream(Type.values()).sorted(Comparator.comparingInt(Type::func_221083_c)).toArray(Type[]::new);
            field_221089_d = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::func_221082_a, type -> type));
        }
    }
}

