/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

public abstract class TombstoneEnchantment
extends Enchantment {
    private final String customName;

    TombstoneEnchantment(String name, Enchantment.Rarity rarity, EnchantmentType type, EquipmentSlotType[] slots) {
        super(rarity, type, slots);
        this.customName = name;
    }

    protected abstract boolean isEnabled();

    public int func_77319_d() {
        return 1;
    }

    public int func_77325_b() {
        return 1;
    }

    public int func_77321_a(int lvl) {
        return 1;
    }

    protected boolean func_77326_a(Enchantment ench) {
        return !ench.func_190936_d() && super.func_77326_a(ench);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<String> getTooltipInfos(ItemStack stack) {
        ArrayList<String> infos = new ArrayList<String>();
        if (stack.func_77973_b() == Items.field_151134_bR) {
            infos.add(LangKey.getClientTranslationWithStyle(StyleType.TOOLTIP_ENCHANT, this.func_77320_a() + ".desc", new Object[0]));
        }
        if (!this.isEnabled()) {
            infos.add(LangKey.getClientTranslationWithStyle(StyleType.COLOR_OFF, "enchantment.tombstone.disabled", new Object[0]));
        }
        return infos;
    }

    public String func_77320_a() {
        return "enchantment.tombstone." + this.customName;
    }
}

