/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

@JeiPlugin
public class IntegrationJEI
implements IModPlugin {
    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("tombstone");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        jeiRuntime.getIngredientManager().addIngredientsAtRuntime(VanillaTypes.ITEM, Collections.singleton(new ItemStack((IItemProvider)ModItems.grave_key)));
    }

    public void registerRecipes(IRecipeRegistration registry) {
        ImmutableList.Builder builder = ImmutableList.builder();
        NonNullList ironIngot = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151042_j)});
        builder.add(registry.getVanillaRecipeFactory().createAnvilRecipe(new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)GraveModel.GRAVE_SIMPLE)), (List)ironIngot, Collections.singletonList(NBTStackHelper.setString(new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)GraveModel.GRAVE_SIMPLE)), "engraved_name", "Corail31"))));
        builder.add(registry.getVanillaRecipeFactory().createAnvilRecipe(new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)GraveModel.GRAVE_NORMAL)), (List)ironIngot, Collections.singletonList(NBTStackHelper.setString(new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)GraveModel.GRAVE_NORMAL)), "engraved_name", "Gegy1000"))));
        builder.add(registry.getVanillaRecipeFactory().createAnvilRecipe(new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)GraveModel.GRAVE_CROSS)), (List)ironIngot, Collections.singletonList(NBTStackHelper.setString(new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)GraveModel.GRAVE_CROSS)), "engraved_name", "Paul Fulham"))));
        builder.add(registry.getVanillaRecipeFactory().createAnvilRecipe(new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)GraveModel.TOMBSTONE)), (List)ironIngot, Collections.singletonList(NBTStackHelper.setString(new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)GraveModel.TOMBSTONE)), "engraved_name", "Runemoro"))));
        builder.add(registry.getVanillaRecipeFactory().createAnvilRecipe(new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)GraveModel.SUBARAKI_GRAVE)), (List)ironIngot, Collections.singletonList(NBTStackHelper.setString(new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)GraveModel.SUBARAKI_GRAVE)), "engraved_name", "Subaraki"))));
        ItemStack tablet = NBTStackHelper.setBoolean(new ItemStack((IItemProvider)ModItems.tablet_of_assistance), "enchant", true);
        builder.add(registry.getVanillaRecipeFactory().createAnvilRecipe(tablet, Collections.singletonList(new ItemStack((IItemProvider)ModItems.grave_dust)), Collections.singletonList(NBTStackHelper.setString(tablet.func_77946_l(), "engraved_name", "Goshen"))));
        registry.addRecipes((Collection)builder.build(), VanillaRecipeCategoryUid.ANVIL);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        for (Block block : ModBlocks.decorative_graves.values()) {
            registration.registerSubtypeInterpreter(block.func_199767_j(), (ISubtypeInterpreter)new DecorativeGraveInterpreter());
        }
    }

    private static class DecorativeGraveInterpreter
    implements ISubtypeInterpreter {
        private DecorativeGraveInterpreter() {
        }

        public String apply(ItemStack stack) {
            return String.valueOf(ItemBlockGrave.getModelTexture(stack));
        }
    }
}

