/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpdateClientMessage;
import ovh.corail.tombstone.network.UpdateServerMessage;
import ovh.corail.tombstone.registry.ModItems;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ConfigTombstone {
    static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client client;
    private static final ForgeConfigSpec.Builder BUILDER;
    public static final General general;
    public static final VillageSiege village_siege;
    public static final DecorativeGrave decorative_grave;
    public static final Enchantments enchantments;
    public static final Recovery recovery;
    public static final AllowedMagicItems allowed_magic_items;
    public static final Loot loot;
    public static final Compatibility compatibility;
    static final ForgeConfigSpec GENERAL_SPEC;

    private static String getTranslation(String name) {
        return "tombstone.config." + name;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerLogued(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidPlayerMP((Entity)event.getPlayer())) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            assert (player.func_184102_h() != null);
            BlockPos spawnPos = player.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_175694_M();
            int range = player.func_184102_h().func_71262_S() ? player.func_184102_h().func_82357_ak() : 0;
            PacketHandler.sendToPlayer(new UpdateClientMessage(spawnPos, range, (Boolean)ConfigTombstone.general.handlePlayerXp.get(), (Integer)ConfigTombstone.general.ghostlyShapeDuration.get(), (Integer)ConfigTombstone.decorative_grave.tabletMaxUse.get(), (Boolean)ConfigTombstone.decorative_grave.unbreakableDecorativeGrave.get(), (Integer)ConfigTombstone.decorative_grave.cooldownToPray.get(), (Boolean)ConfigTombstone.enchantments.nerfShadowStep.get(), (Boolean)ConfigTombstone.enchantments.enableEnchantmentShadowStep.get(), (Boolean)ConfigTombstone.enchantments.enableEnchantmentSoulbound.get(), (Boolean)ConfigTombstone.allowed_magic_items.allowBookOfDisenchantment.get(), (Boolean)ConfigTombstone.allowed_magic_items.allowVoodooPoppet.get(), (Integer)ConfigTombstone.loot.chanceLootLostTablet.get(), Helper.isDateAroundHalloween(LocalDate.now()), Helper.isContributor((PlayerEntity)player), (Integer)ConfigTombstone.general.xpLoss.get(), (Integer)ConfigTombstone.general.chanceEnchantedGraveKey.get()), player);
            EntityHelper.syncTBCapability(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("tombstone")) {
            if (!((GraveModel)((Object)ConfigTombstone.client.favoriteGrave.get())).equals((Object)ConfigTombstone.client.lastFavoriteGrave) || !((BlockGraveMarble.MarbleType)((Object)ConfigTombstone.client.favoriteGraveMarble.get())).equals((Object)ConfigTombstone.client.lastFavoriteGraveMarble) || ConfigTombstone.client.lastEquipElytraInPriority != (Boolean)ConfigTombstone.client.equipElytraInPriority.get() || ConfigTombstone.client.lastDisplayKnowledgeMessage != (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get()) {
                ConfigTombstone.client.lastFavoriteGrave = (GraveModel)((Object)ConfigTombstone.client.favoriteGrave.get());
                ConfigTombstone.client.lastFavoriteGraveMarble = (BlockGraveMarble.MarbleType)((Object)ConfigTombstone.client.favoriteGraveMarble.get());
                ConfigTombstone.client.lastEquipElytraInPriority = (Boolean)ConfigTombstone.client.equipElytraInPriority.get();
                ConfigTombstone.client.lastDisplayKnowledgeMessage = (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get();
                PacketHandler.sendToServer(new UpdateServerMessage((GraveModel)((Object)ConfigTombstone.client.favoriteGrave.get()), (BlockGraveMarble.MarbleType)((Object)ConfigTombstone.client.favoriteGraveMarble.get()), (Boolean)ConfigTombstone.client.equipElytraInPriority.get(), (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get(), false));
            }
            if (Minecraft.func_71410_x().func_71356_B()) {
                ConfigTombstone.updateServerDatas();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            ConfigTombstone.updateServerDatas();
        } else {
            ConfigTombstone.updateClientDatas();
        }
    }

    public static void updateServerDatas() {
        ConfigTombstone.general.serverHandlePlayerXp = (Boolean)ConfigTombstone.general.handlePlayerXp.get();
        ConfigTombstone.general.serverGhostlyShapeDuration = (Integer)ConfigTombstone.general.ghostlyShapeDuration.get();
        ConfigTombstone.decorative_grave.serverTabletMaxUse = (Integer)ConfigTombstone.decorative_grave.tabletMaxUse.get();
        ConfigTombstone.decorative_grave.serverUnbreakableDecorativeGrave = (Boolean)ConfigTombstone.decorative_grave.unbreakableDecorativeGrave.get();
        ConfigTombstone.decorative_grave.serverCooldownToPray = (Integer)ConfigTombstone.decorative_grave.cooldownToPray.get();
        ConfigTombstone.enchantments.serverNerfShadowStep = (Boolean)ConfigTombstone.enchantments.nerfShadowStep.get();
        ConfigTombstone.enchantments.serverEnableEnchantmentShadowStep = (Boolean)ConfigTombstone.enchantments.enableEnchantmentShadowStep.get();
        ConfigTombstone.enchantments.serverEnableEnchantmentSoulbound = (Boolean)ConfigTombstone.enchantments.enableEnchantmentSoulbound.get();
        ConfigTombstone.allowed_magic_items.serverAllowBookOfDisenchantment = (Boolean)ConfigTombstone.allowed_magic_items.allowBookOfDisenchantment.get();
        ConfigTombstone.allowed_magic_items.serverAllowVoodooPoppet = (Boolean)ConfigTombstone.allowed_magic_items.allowVoodooPoppet.get();
        ConfigTombstone.loot.serverChanceLootLostTablet = (Integer)ConfigTombstone.loot.chanceLootLostTablet.get();
        ConfigTombstone.general.serverXpLoss = (Integer)ConfigTombstone.general.xpLoss.get();
        ConfigTombstone.general.serverChanceEnchantedGraveKey = (Integer)ConfigTombstone.general.chanceEnchantedGraveKey.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientPacket(UpdateClientMessage message) {
        ConfigTombstone.general.serverHandlePlayerXp = message.handlePlayerXp;
        ConfigTombstone.general.serverGhostlyShapeDuration = message.ghostlyShapeDuration;
        ConfigTombstone.decorative_grave.serverTabletMaxUse = message.tabletMaxUse;
        ConfigTombstone.decorative_grave.serverUnbreakableDecorativeGrave = message.unbreakableDecorativeGrave;
        ConfigTombstone.decorative_grave.serverCooldownToPray = message.cooldownToPray;
        ConfigTombstone.enchantments.serverNerfShadowStep = message.nerfShadowStep;
        ConfigTombstone.enchantments.serverEnableEnchantmentShadowStep = message.enableEnchantmentShadowStep;
        ConfigTombstone.enchantments.serverEnableEnchantmentSoulbound = message.enableEnchantmentSoulbound;
        ConfigTombstone.allowed_magic_items.serverAllowBookOfDisenchantment = message.allowBookOfDisenchantment;
        ConfigTombstone.allowed_magic_items.serverAllowVoodooPoppet = message.allowVoodooPoppet;
        ConfigTombstone.loot.serverChanceLootLostTablet = message.chanceLootLostTablet;
        ConfigTombstone.general.serverXpLoss = message.xpLoss;
        ConfigTombstone.general.serverChanceEnchantedGraveKey = message.chanceEnchantedGraveKey;
    }

    private static void updateClientDatas() {
        ConfigTombstone.client.lastFavoriteGrave = (GraveModel)((Object)ConfigTombstone.client.favoriteGrave.get());
        ConfigTombstone.client.lastFavoriteGraveMarble = (BlockGraveMarble.MarbleType)((Object)ConfigTombstone.client.favoriteGraveMarble.get());
        ConfigTombstone.client.lastEquipElytraInPriority = (Boolean)ConfigTombstone.client.equipElytraInPriority.get();
        ConfigTombstone.client.lastDisplayKnowledgeMessage = (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("tombstone", "cap_tombstone"), (ICapabilityProvider)new TBCapabilityProvider());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getEntityPlayer().getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                CompoundNBT persistantTag;
                CompoundNBT entityData = event.getEntityPlayer().getPersistentData();
                if (entityData.func_74764_b("PlayerPersisted") && (persistantTag = (CompoundNBT)entityData.func_74781_a("PlayerPersisted")) != null && persistantTag.func_150297_b("tombstone_cap", 10)) {
                    TBCapabilityProvider.TB_CAPABILITY.readNBT(cap, null, persistantTag.func_74781_a("tombstone_cap"));
                    persistantTag.func_82580_o("tombstone_cap");
                }
            });
        } else {
            event.getOriginal().revive();
            event.getEntityPlayer().getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(capPlayer -> event.getOriginal().getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(capPlayer::copyCapability));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onSyncOnRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (EntityHelper.isValidPlayer(event.getPlayer()) && !event.getPlayer().field_70170_p.field_72995_K) {
            EntityHelper.syncTBCapability((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onSyncOnChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (EntityHelper.isValidPlayer(event.getPlayer()) && !event.getPlayer().field_70170_p.field_72995_K) {
            ServerWorld toDim;
            long toTime;
            EntityHelper.syncTBCapability((ServerPlayerEntity)event.getPlayer());
            MinecraftServer server = event.getPlayer().func_184102_h();
            if (server == null) {
                return;
            }
            ServerWorld fromDim = server.func_71218_a(event.getFrom());
            long fromTime = fromDim.func_82737_E();
            if (fromTime != (toTime = (toDim = server.func_71218_a(event.getTo())).func_82737_E())) {
                event.getPlayer().getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                    long timeToPray = Math.min(Math.max(0L, cap.getNextPray() - fromTime), (long)cap.getMaxPrayTime(event.getPlayer()));
                    cap.setNextPray(toTime + timeToPray);
                    cap.setNextResetPerks(toTime + cap.getCooldownToResetPerks(event.getPlayer()));
                });
                event.getPlayer().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(inventPlayer -> IntStream.range(0, inventPlayer.getSlots()).mapToObj(arg_0 -> ((IItemHandler)inventPlayer).getStackInSlot(arg_0)).forEach(stack -> {
                    if (stack.func_77973_b() == ModItems.tablet_of_recall || stack.func_77973_b() == ModItems.tablet_of_assistance) {
                        ItemTablet tablet = (ItemTablet)stack.func_77973_b();
                        tablet.setCooldown((World)toDim, (ItemStack)stack, Math.min(tablet.getCooldown((World)fromDim, (ItemStack)stack), tablet.getCastingCooldown()));
                    } else if (stack.func_77973_b() == ModItems.lost_tablet) {
                        ModItems.lost_tablet.setCooldown((World)toDim, (ItemStack)stack, Math.min(ModItems.lost_tablet.getCooldown((World)fromDim, (ItemStack)stack), TimeHelper.tickFromMinute(10)));
                    }
                }));
            }
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        client = (Client)specPair.getLeft();
        BUILDER = new ForgeConfigSpec.Builder();
        general = new General(BUILDER);
        village_siege = new VillageSiege(BUILDER);
        decorative_grave = new DecorativeGrave(BUILDER);
        enchantments = new Enchantments(BUILDER);
        recovery = new Recovery(BUILDER);
        allowed_magic_items = new AllowedMagicItems(BUILDER);
        loot = new Loot(BUILDER);
        compatibility = new Compatibility(BUILDER);
        GENERAL_SPEC = BUILDER.build();
    }

    public static class Compatibility {
        public final ForgeConfigSpec.ConfigValue<Boolean> allowCurioAutoEquip;
        public final ForgeConfigSpec.ConfigValue<Boolean> keepCosmeticArmor;

        public Compatibility(ForgeConfigSpec.Builder builder) {
            builder.comment("Allows to enable some features related to others mods").push("compatibility");
            this.allowCurioAutoEquip = builder.comment("Allows to auto-equip the slots from Curio mod [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_curio_auto_equip")).define("allow_curio_auto_equip", true);
            this.keepCosmeticArmor = builder.comment("Keeps the cosmetic armor when you die [false/true|default:true]").translation(ConfigTombstone.getTranslation("keep_cosmetic_armor")).define("keep_cosmetic_armor", true);
            builder.pop();
        }
    }

    public static class VillageSiege {
        public final ForgeConfigSpec.ConfigValue<Boolean> handleVillageSiege;
        public final ForgeConfigSpec.ConfigValue<Boolean> logSiegeState;
        public final ForgeConfigSpec.ConfigValue<Boolean> glowingCreatureTest;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowCreativePlayersForSiege;
        public final ForgeConfigSpec.ConfigValue<Integer> siegeChance;
        public final ForgeConfigSpec.ConfigValue<Integer> siegeMaxCreature;
        public final ForgeConfigSpec.ConfigValue<Boolean> undeadWearHelmInSiege;
        public final ForgeConfigSpec.ConfigValue<Integer> delaySiegeTest;
        public final ForgeConfigSpec.ConfigValue<Boolean> persistentMobInSiege;
        public final ForgeConfigSpec.ConfigValue<Boolean> shufflePlayersForSiege;

        public VillageSiege(ForgeConfigSpec.Builder builder) {
            builder.comment("Allows to define the conditions for a village siege to begin").push("village_siege");
            this.handleVillageSiege = builder.comment("Allows to handle village sieges [false/true|default:true]").translation(ConfigTombstone.getTranslation("handle_village_siege")).define("handle_village_siege", true);
            this.logSiegeState = builder.comment("Logs the different states of a village siege while searching for an adequate place [false/true|default:false]").translation(ConfigTombstone.getTranslation("log_siege_state")).define("log_siege_state", false);
            this.glowingCreatureTest = builder.comment("The creatures of the siege have a glowing effect (only uses this for test purposes) [false/true|default:false]").translation(ConfigTombstone.getTranslation("glowing_creature_test")).define("glowing_creature_test", false);
            this.allowCreativePlayersForSiege = builder.comment("Allows to use the positions of creative players to define the siege location [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_creative_players_for_siege")).define("allow_creative_players_for_siege", true);
            this.siegeChance = builder.comment("Chance for a siege to occur [0..100|default:10]").translation(ConfigTombstone.getTranslation("siege_chance")).defineInRange("siege_chance", 10, 0, 100);
            this.siegeMaxCreature = builder.comment("Maximum of creatures appearing in a siege [0..100|default:20]").translation(ConfigTombstone.getTranslation("siege_max_creature")).defineInRange("siege_max_creature", 20, 0, 100);
            this.undeadWearHelmInSiege = builder.comment("Undeads always wear a helm when sieging [false/true|default:false]").translation(ConfigTombstone.getTranslation("undead_wear_helm_in_siege")).define("undead_wear_helm_in_siege", false);
            this.delaySiegeTest = builder.comment("Delay in seconds for a second test of siege when the first failed [0..2400|default:600]").translation(ConfigTombstone.getTranslation("delay_siege_test")).defineInRange("delay_siege_test", 600, 0, 2400);
            this.persistentMobInSiege = builder.comment("Mobs in siege are persistent [false/true|default:false]").translation(ConfigTombstone.getTranslation("persistent_mob_in_siege")).define("persistent_mob_in_siege", false);
            this.shufflePlayersForSiege = builder.comment("Shuffles the list of players before testing the siege location [false/true|default:true]").translation(ConfigTombstone.getTranslation("shuffle_players_for_siege")).define("shuffle_players_for_siege", true);
            builder.pop();
        }
    }

    public static class Recovery {
        public final ForgeConfigSpec.ConfigValue<Boolean> recoveryPlayerEnable;
        public final ForgeConfigSpec.ConfigValue<Integer> recoveryPlayerTimer;
        public final ForgeConfigSpec.ConfigValue<Integer> recoveryPlayerMaxSaves;
        public final ForgeConfigSpec.ConfigValue<Boolean> recoveryFamiliarEnable;

        public Recovery(ForgeConfigSpec.Builder builder) {
            builder.comment("Options related to the command recovery and auto-save of players").push("recovery");
            this.recoveryPlayerEnable = builder.comment("Enables to backup automatically players [false/true|default:true]").translation(ConfigTombstone.getTranslation("recovery_player_enable")).define("recovery_player_enable", true);
            this.recoveryPlayerTimer = builder.comment("Time in minutes between players' backups [10..1000|default:40]").translation(ConfigTombstone.getTranslation("recovery_player_timer")).defineInRange("recovery_player_timer", 40, 10, 1000);
            this.recoveryPlayerMaxSaves = builder.comment("Maximum number of backups per player [5..100|default:15]").translation(ConfigTombstone.getTranslation("recovery_player_max_saves")).defineInRange("recovery_player_max_saves", 15, 5, 100);
            this.recoveryFamiliarEnable = builder.comment("Enables to backup automatically dead familiars [false/true|default:true]").translation(ConfigTombstone.getTranslation("recovery_familiar_enable")).define("recovery_familiar_enable", true);
            builder.pop();
        }
    }

    public static class Loot {
        final ForgeConfigSpec.ConfigValue<Integer> chanceLootLostTablet;
        int serverChanceLootLostTablet;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceDecorativeGraveOnBoss;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceRandomPoppetOnBoss;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceRandomScrollOnBoss;
        public final ForgeConfigSpec.ConfigValue<Boolean> undeadCanDropSkull;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceSoulReceptacleOnBoss;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceGraveDust;
        public final ForgeConfigSpec.ConfigValue<List<String>> treasureLootTable;

        public int getChanceLootLostTablet() {
            return this.serverChanceLootLostTablet;
        }

        public Loot(ForgeConfigSpec.Builder builder) {
            builder.comment("Allows to change the chance to drop some items").push("loot");
            this.chanceLootLostTablet = builder.comment("Chance to loot a Lost Tablet by fishing [0..100|default:10]").translation(ConfigTombstone.getTranslation("chance_loot_lost_tablet")).defineInRange("chance_loot_lost_tablet", 10, 0, 100);
            this.chanceDecorativeGraveOnBoss = builder.comment("Chance on 1000 to receive a decorative grave on undead boss [0..1000|default:50]").translation(ConfigTombstone.getTranslation("chance_decorative_grave_on_boss")).defineInRange("chance_decorative_grave_on_boss", 30, 0, 1000);
            this.chanceRandomPoppetOnBoss = builder.comment("Chance on 1000 to receive a random poppet on undead boss [0..1000|default:100]").translation(ConfigTombstone.getTranslation("chance_random_poppet_on_boss")).defineInRange("chance_random_poppet_on_boss", 100, 0, 1000);
            this.chanceRandomScrollOnBoss = builder.comment("Chance on 1000 to receive a random scroll on undead boss [0..1000|default:100]").translation(ConfigTombstone.getTranslation("chance_random_scroll_on_boss")).defineInRange("chance_random_scroll_on_boss", 100, 0, 1000);
            this.undeadCanDropSkull = builder.comment("Allows the undeads to have a low chance to drop their skull [false/true|default:true]").translation(ConfigTombstone.getTranslation("undead_can_drop_skull")).define("undead_can_drop_skull", true);
            this.chanceSoulReceptacleOnBoss = builder.comment("Chance on 1000 to receive a Soul Receptacle on undead boss [0..1000|default:50]").translation(ConfigTombstone.getTranslation("chance_soul_receptacle_on_boss")).defineInRange("chance_soul_receptacle_on_boss", 50, 0, 1000);
            this.chanceGraveDust = builder.comment("Chance on 1000 for undead mobs to drop Grave's Dust [0..1000|default:100]").translation(ConfigTombstone.getTranslation("chance_grave_dust")).defineInRange("chance_grave_dust", 100, 0, 1000);
            this.treasureLootTable = builder.comment("Defines the allowed loottables having a chance to contain a magic item from Tombstone").translation(ConfigTombstone.getTranslation("treasure_loot_table")).define("treasure_loot_table", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:chests/end_city_treasure", "minecraft:chests/abandoned_mineshaft", "minecraft:chests/nether_bridge", "minecraft:chests/stronghold_library", "minecraft:chests/desert_pyramid", "minecraft:chests/jungle_temple", "minecraft:chests/igloo_chest", "minecraft:chests/woodland_mansion"}));
            builder.pop();
        }
    }

    public static class AllowedMagicItems {
        final ForgeConfigSpec.ConfigValue<Boolean> allowBookOfDisenchantment;
        boolean serverAllowBookOfDisenchantment;
        final ForgeConfigSpec.ConfigValue<Boolean> allowVoodooPoppet;
        boolean serverAllowVoodooPoppet;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowGraveKey;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfKnowledge;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTabletOfRecall;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTabletOfAssistance;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfPreservation;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfUnstableIntangibleness;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfFeatherFall;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfPurification;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfTrueSight;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowLostTablet;

        public boolean isAllowedBookOfDisenchantment() {
            return this.serverAllowBookOfDisenchantment;
        }

        public boolean isAllowedVoodooPoppet() {
            return this.serverAllowVoodooPoppet;
        }

        public AllowedMagicItems(ForgeConfigSpec.Builder builder) {
            builder.comment("Allows to disable some magic items").push("allowedMagicItems");
            this.allowBookOfDisenchantment = builder.comment("Allow Book of Disenchantment [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_book_of_disenchantment")).define("allow_book_of_disenchantment", true);
            this.allowVoodooPoppet = builder.comment("Allow Voodoo Poppet [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_voodoo_poppet")).define("allow_voodoo_poppet", true);
            this.allowGraveKey = builder.comment("Allow Grave's Key [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_grave_key")).define("allow_grave_key", true);
            this.allowScrollOfKnowledge = builder.comment("Allow Scroll of Knowledge [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_scroll_of_knowledge")).define("allow_scroll_of_knowledge", true);
            this.allowTabletOfRecall = builder.comment("Allow Tablet of Recall [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_tablet_of_recall")).define("allow_tablet_of_recall", true);
            this.allowTabletOfAssistance = builder.comment("Allow Tablet of Assistance [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_tablet_of_assistance")).define("allow_tablet_of_assistance", true);
            this.allowScrollOfPreservation = builder.comment("Allow Scroll of Preservation [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_scroll_of_preservation")).define("allow_scroll_of_preservation", true);
            this.allowScrollOfUnstableIntangibleness = builder.comment("Allow Scroll of Unstable Intangibleness [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_scroll_of_unstable_intangibleness")).define("allow_scroll_of_unstable_intangibleness", true);
            this.allowScrollOfFeatherFall = builder.comment("Allow Scroll of Feather Fall [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_scroll_of_feather_fall")).define("allow_scroll_of_feather_fall", true);
            this.allowScrollOfPurification = builder.comment("Allow Scroll of Purification [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_scroll_of_purification")).define("allow_scroll_of_purification", true);
            this.allowScrollOfTrueSight = builder.comment("Allow Scroll of True Sight [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_scroll_of_true_sight")).define("allow_scroll_of_true_sight", true);
            this.allowLostTablet = builder.comment("Allow Lost Tablet [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_lost_tablet")).define("allow_lost_tablet", true);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<FogDensity> fogDensity;
        public final ForgeConfigSpec.ConfigValue<Integer> particleCastingColor;
        public final ForgeConfigSpec.ConfigValue<Boolean> showEnhancedTooltips;
        public final ForgeConfigSpec.ConfigValue<Boolean> highlight;
        public final ForgeConfigSpec.ConfigValue<Boolean> skipRespawnScreen;
        public final ForgeConfigSpec.ConfigValue<Boolean> showShadowStep;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableHalloweenEffect;
        public final ForgeConfigSpec.ConfigValue<Integer> textColorDeathDate;
        public final ForgeConfigSpec.ConfigValue<Integer> textColorRIP;
        public final ForgeConfigSpec.ConfigValue<Integer> textColorOwner;
        public final ForgeConfigSpec.ConfigValue<Boolean> dateInMCTime;
        public final ForgeConfigSpec.ConfigValue<Boolean> displayKnowledgeMessage;
        public final ForgeConfigSpec.ConfigValue<Boolean> equipElytraInPriority;
        public final ForgeConfigSpec.ConfigValue<GraveModel> favoriteGrave;
        public final ForgeConfigSpec.ConfigValue<BlockGraveMarble.MarbleType> favoriteGraveMarble;
        public final ForgeConfigSpec.ConfigValue<Boolean> showInfoOnEnchantment;
        public final ForgeConfigSpec.ConfigValue<GraveSkinRule> graveSkinRule;
        public GraveModel lastFavoriteGrave = GraveModel.GRAVE_SIMPLE;
        public BlockGraveMarble.MarbleType lastFavoriteGraveMarble = BlockGraveMarble.MarbleType.DARK;
        public boolean lastEquipElytraInPriority = false;
        public boolean lastDisplayKnowledgeMessage = true;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Personal Options that can be edited even on server").push("client");
            this.fogDensity = builder.comment("Fog density around the graves [NONE/LOW/NORMAL/HIGH|default:LOW]").translation(ConfigTombstone.getTranslation("fog_density")).defineEnum("fog_density", (Enum)FogDensity.LOW);
            this.particleCastingColor = builder.comment("Decimal value for the color of the particles when using magic items [0..16777215|default:125656]").translation(ConfigTombstone.getTranslation("particle_casting_color")).defineInRange("particle_casting_color", 125656, 0, 0xFFFFFF);
            this.showEnhancedTooltips = builder.comment("Shows all the infos in the tooltip of items [false/true|default:true]").translation(ConfigTombstone.getTranslation("show_enhanced_tooltips")).define("show_enhanced_tooltips", true);
            this.highlight = builder.comment("Highlights the tomb from far when holding the key [false/true|default:true]").translation(ConfigTombstone.getTranslation("highlight")).define("highlight", true);
            this.skipRespawnScreen = builder.comment("Skips the Respawn Screen [false/true|default:false]").translation(ConfigTombstone.getTranslation("skip_respawn_screen")).define("skip_respawn_screen", false);
            this.showShadowStep = builder.comment("Shows shadow step particles [false/true|default:true]").translation(ConfigTombstone.getTranslation("hide_shadow_step")).define("hide_shadow_step", true);
            this.enableHalloweenEffect = builder.comment("Enables the special rendering and particles for Halloween [false/true|default:true]").translation(ConfigTombstone.getTranslation("enable_halloween_effect")).define("enable_halloween_effect", true);
            this.textColorDeathDate = builder.comment("Decimal value for the color of the grave text <Death Date> [0..16777215|default:2962496]").translation(ConfigTombstone.getTranslation("text_color_death_date")).defineInRange("text_color_death_date", 2962496, 0, 0xFFFFFF);
            this.textColorRIP = builder.comment("Decimal value for the color of the grave text <R.I.P.> [0..16777215|default:2962496]").translation(ConfigTombstone.getTranslation("text_color_rip")).defineInRange("text_color_rip", 2962496, 0, 0xFFFFFF);
            this.textColorOwner = builder.comment("Decimal value for the color of the grave text <Owner Name> [0..16777215|default:5991302]").translation(ConfigTombstone.getTranslation("text_color_owner")).defineInRange("text_color_owner", 5991302, 0, 0xFFFFFF);
            this.dateInMCTime = builder.comment("Shows only the elapsed minecraft days since the death on graves [false/true|default:false]").translation(ConfigTombstone.getTranslation("date_in_mc_time")).define("date_in_mc_time", false);
            this.displayKnowledgeMessage = builder.comment("Display or not the messages of gain of points in knowledge of death [false/true|default:true]").translation(ConfigTombstone.getTranslation("display_knowledge_message")).define("display_knowledge_message", true);
            this.equipElytraInPriority = builder.comment("Equips elytra in priority when recovering your lost items [false/true|default:false]").translation(ConfigTombstone.getTranslation("equip_elytra_in_priority")).define("equip_elytra_in_priority", false);
            this.favoriteGrave = builder.comment("Favorite grave").translation(ConfigTombstone.getTranslation("favorite_grave")).defineEnum("favorite_grave", (Enum)GraveModel.GRAVE_SIMPLE);
            this.favoriteGraveMarble = builder.comment("Favorite grave marble").translation(ConfigTombstone.getTranslation("favorite_grave_marble")).defineEnum("favorite_grave_marble", (Enum)BlockGraveMarble.MarbleType.DARK);
            this.showInfoOnEnchantment = builder.comment("Shows the use of the Tombstone's enchantments in tooltip [false/true|default:true]").translation(ConfigTombstone.getTranslation("show_info_on_enchantment")).define("show_info_on_enchantment", true);
            this.graveSkinRule = builder.comment("Defines the rule to use for grave's skin [DEFAULT/FORCE_NORMAL/FORCE_HALLOWEEN|default:DEFAULT]").translation(ConfigTombstone.getTranslation("grave_skin_rule")).defineEnum("grave_skin_rule", (Enum)GraveSkinRule.DEFAULT);
            builder.pop();
        }

        public static enum GraveSkinRule {
            DEFAULT,
            FORCE_NORMAL,
            FORCE_HALLOWEEN;

        }

        public static enum FogDensity {
            NONE,
            LOW,
            NORMAL,
            HIGH;

        }
    }

    public static class DecorativeGrave {
        public final ForgeConfigSpec.ConfigValue<Integer> timeSoul;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceSoul;
        final ForgeConfigSpec.ConfigValue<Integer> tabletMaxUse;
        int serverTabletMaxUse = 10;
        final ForgeConfigSpec.ConfigValue<Boolean> unbreakableDecorativeGrave;
        boolean serverUnbreakableDecorativeGrave = false;
        public final ForgeConfigSpec.ConfigValue<Integer> chancePrayReward;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTabletSearchOutsideWorld;
        public final ForgeConfigSpec.ConfigValue<Integer> cooldownResetPerk;
        final ForgeConfigSpec.ConfigValue<Integer> cooldownToPray;
        int serverCooldownToPray = 3;
        public final ForgeConfigSpec.ConfigValue<List<String>> blackListCapturableSouls;
        public final ForgeConfigSpec.ConfigValue<Boolean> purificationAffectNeutralEffects;

        public int getTabletMaxUse() {
            return this.serverTabletMaxUse;
        }

        public boolean isUnbreakableDecorativeGrave() {
            return this.serverUnbreakableDecorativeGrave;
        }

        public int getCooldownToPray() {
            return this.serverCooldownToPray;
        }

        public DecorativeGrave(ForgeConfigSpec.Builder builder) {
            builder.comment("For settings related to decorative tombs and magic items").push("decorative_grave");
            this.timeSoul = builder.comment("Time in minutes to check if a soul appears on a grave [10..10000|default:30]").translation(ConfigTombstone.getTranslation("time_soul")).defineInRange("time_soul", 30, 10, 10000);
            this.chanceSoul = builder.comment("Chance on 1000 that a soul appears on a grave [0..1000|default:100]").translation(ConfigTombstone.getTranslation("chance_soul")).defineInRange("chance_soul", 100, 0, 1000);
            this.tabletMaxUse = builder.comment("Maximum uses of a tablet [1..20|default:10]").translation(ConfigTombstone.getTranslation("tablet_max_use")).defineInRange("tablet_max_use", 10, 1, 20);
            this.unbreakableDecorativeGrave = builder.comment("Sets the decorative graves unbreakable [false/true|default:false]").translation(ConfigTombstone.getTranslation("unbreakable_decorative_grave")).define("unbreakable_decorative_grave", false);
            this.chancePrayReward = builder.comment("Chance to receive a random beneficial spell effect when praying near a grave [0..100|default:40]").translation(ConfigTombstone.getTranslation("chance_pray_reward")).defineInRange("chance_pray_reward", 40, 0, 100);
            this.allowTabletSearchOutsideWorld = builder.comment("Allows lost tablets to find locations outside the current world [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_tablet_search_outside_world")).define("allow_tablet_search_outside_world", true);
            this.cooldownResetPerk = builder.comment("The cooldown in minutes to reset the perks with the \u00c3\u201ankh of Pray [0..60|default:20]").translation(ConfigTombstone.getTranslation("cooldown_reset_perk")).defineInRange("cooldown_reset_perk", 20, 0, 60);
            this.cooldownToPray = builder.comment("The cooldown in hours to pray with the \u00c3\u201ankh [1..10|default:3]").translation(ConfigTombstone.getTranslation("cooldown_to_pray")).defineInRange("cooldown_to_pray", 3, 1, 10);
            this.blackListCapturableSouls = builder.comment("The creatures that can't be captured in receptacle").translation(ConfigTombstone.getTranslation("black_list_capturable_souls")).define("black_list_capturable_souls", new ArrayList());
            this.purificationAffectNeutralEffects = builder.comment("Allows the purification effect to clear neutral effects [false/true|default:true]").translation(ConfigTombstone.getTranslation("purification_affect_neutral_effects")).define("purification_affect_neutral_effects", true);
            builder.pop();
        }
    }

    public static class Enchantments {
        public final ForgeConfigSpec.ConfigValue<Boolean> restrictShadowStepToPlayer;
        final ForgeConfigSpec.ConfigValue<Boolean> nerfShadowStep;
        boolean serverNerfShadowStep = false;
        final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentShadowStep;
        boolean serverEnableEnchantmentShadowStep = true;
        final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentSoulbound;
        boolean serverEnableEnchantmentSoulbound = true;

        public boolean isNerfShadowStep() {
            return this.serverNerfShadowStep;
        }

        public boolean isEnableEnchantmentShadowStep() {
            return this.serverEnableEnchantmentShadowStep;
        }

        public boolean isEnableEnchantmentSoulbound() {
            return this.serverEnableEnchantmentSoulbound;
        }

        public Enchantments(ForgeConfigSpec.Builder builder) {
            builder.comment("Allows to customize or disable the enchantments").push("enchantments");
            this.restrictShadowStepToPlayer = builder.comment("Restricts the effect of Shadow Step to players [false/true|default:true]").translation(ConfigTombstone.getTranslation("restrict_shadow_step_to_player")).define("restrict_shadow_step_to_player", true);
            this.nerfShadowStep = builder.comment("Shadow Step is only active while sneaking [false/true|default:false]").translation(ConfigTombstone.getTranslation("nerf_shadow_step")).define("nerf_shadow_step", false);
            this.enableEnchantmentShadowStep = builder.comment("Enables the enchantment Shadow Step [false/true|default:true]").translation(ConfigTombstone.getTranslation("enable_enchantment_shadow_step")).define("enable_enchantment_shadow_step", true);
            this.enableEnchantmentSoulbound = builder.comment("Enables the enchantment Soulbound [false/true|default:true]").translation(ConfigTombstone.getTranslation("enable_enchantment_soulbound")).define("enable_enchantment_soulbound", true);
            builder.pop();
        }
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Integer> snifferRange;
        public final ForgeConfigSpec.ConfigValue<Boolean> handlePlayerDeath;
        final ForgeConfigSpec.ConfigValue<Integer> chanceEnchantedGraveKey;
        int serverChanceEnchantedGraveKey;
        public final ForgeConfigSpec.ConfigValue<Boolean> logPlayerGrave;
        public final ForgeConfigSpec.ConfigValue<Boolean> playerGraveAccess;
        public final ForgeConfigSpec.ConfigValue<Boolean> graveKeyOnDeath;
        public final ForgeConfigSpec.ConfigValue<Integer> decayTime;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceLossOnDeath;
        public final ForgeConfigSpec.ConfigValue<Integer> percentLossOnDeath;
        final ForgeConfigSpec.ConfigValue<Integer> ghostlyShapeDuration;
        int serverGhostlyShapeDuration;
        public final ForgeConfigSpec.ConfigValue<Boolean> restoreEffectsOnDeath;
        public final ForgeConfigSpec.ConfigValue<Boolean> teleportDim;
        final ForgeConfigSpec.ConfigValue<Boolean> handlePlayerXp;
        boolean serverHandlePlayerXp;
        final ForgeConfigSpec.ConfigValue<Integer> xpLoss;
        int serverXpLoss;
        public final ForgeConfigSpec.ConfigValue<Integer> knowledgeLoss;
        public final ForgeConfigSpec.ConfigValue<Boolean> nerfGhostlyShape;
        public final ForgeConfigSpec.ConfigValue<Boolean> preventDeathOutsideWorld;
        public final ForgeConfigSpec.ConfigValue<Boolean> pvpMode;
        public final ForgeConfigSpec.ConfigValue<Boolean> gravesBypassGriefingRules;
        public final ForgeConfigSpec.ConfigValue<List<String>> blackListEffects;
        public final ForgeConfigSpec.ConfigValue<List<String>> noGraveLocation;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceMobOnGraveRecovery;
        public final ForgeConfigSpec.ConfigValue<Boolean> knowledgeReducePhantomSpawn;
        public final ForgeConfigSpec.ConfigValue<Integer> timeForPhantomSpawn;
        public final ForgeConfigSpec.ConfigValue<Boolean> persistantHalloween;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowGraveInWater;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowBeyondTheGraveDamage;

        public int getChanceEnchantedGraveKey() {
            return this.serverChanceEnchantedGraveKey;
        }

        public int getGhostlyShapeDuration() {
            return this.serverGhostlyShapeDuration;
        }

        public boolean isHandlingPlayerXp() {
            return this.serverHandlePlayerXp;
        }

        public int getXpLoss() {
            return this.serverXpLoss;
        }

        public General(ForgeConfigSpec.Builder builder) {
            builder.comment("Miscellaneous options").push("general");
            this.snifferRange = builder.comment("The radius in which items should be collected when a grave is spawned [1..10|default:5]").translation(ConfigTombstone.getTranslation("sniffer_range")).defineInRange("sniffer_range", 5, 1, 10);
            this.handlePlayerDeath = builder.comment("Whether to handle player death [false/true|default:true]").translation(ConfigTombstone.getTranslation("handle_player_death")).define("handle_player_death", true);
            this.chanceEnchantedGraveKey = builder.comment("The chance that a player receives an already enchanted Grave's Key on death [1..100|default:0]").translation(ConfigTombstone.getTranslation("chance_enchanted_graveKey")).defineInRange("chance_enchanted_graveKey", 0, 0, 100);
            this.logPlayerGrave = builder.comment("Whether to log the positions of players' graves [false/true|default:true]").translation(ConfigTombstone.getTranslation("log_player_grave")).define("log_player_grave", true);
            this.playerGraveAccess = builder.comment("Whether to require a Grave's Key to access graves [false/true|default:true]").translation(ConfigTombstone.getTranslation("player_grave_access")).define("player_grave_access", true);
            this.graveKeyOnDeath = builder.comment("Whether to always give players a Grave's Key on death [false/true|default:true]").translation(ConfigTombstone.getTranslation("grave_key_on_death")).define("grave_key_on_death", true);
            this.decayTime = builder.comment("The time in minutes before a Grave's Key isn't required to open a grave (-1 = disabled) [-1..MAX|default:-1]").translation(ConfigTombstone.getTranslation("decay_time")).defineInRange("decay_time", -1, -1, Integer.MAX_VALUE);
            this.chanceLossOnDeath = builder.comment("The chance that some items are lost on death [0..100|default:0]").translation(ConfigTombstone.getTranslation("chance_loss_on_death")).defineInRange("chance_loss_on_death", 0, 0, 100);
            this.percentLossOnDeath = builder.comment("The percentage of items that are lost on death [0..100|default:0]").translation(ConfigTombstone.getTranslation("percent_loss_on_death")).defineInRange("percent_loss_on_death", 0, 0, 100);
            this.ghostlyShapeDuration = builder.comment("The duration of the Ghostly Shape effect in seconds [0..MAX|default:120]").translation(ConfigTombstone.getTranslation("ghostly_shape_duration")).defineInRange("ghostly_shape_duration", 120, 0, Integer.MAX_VALUE);
            this.restoreEffectsOnDeath = builder.comment("Whether to restore beneficial effects after a player dies [false/true|default:true]").translation(ConfigTombstone.getTranslation("restore_effects_on_death")).define("restore_effects_on_death", true);
            this.teleportDim = builder.comment("Allows teleportation to other dimensions [false/true|default:true]").translation(ConfigTombstone.getTranslation("teleport_dim")).define("teleport_dim", true);
            this.handlePlayerXp = builder.comment("Whether to handle player experience [false/true|default:true]").translation(ConfigTombstone.getTranslation("handle_player_xp")).define("handle_player_xp", true);
            this.xpLoss = builder.comment("Experience loss on death (%) [0..100|default:0]").translation(ConfigTombstone.getTranslation("xp_loss")).defineInRange("xp_loss", 0, 0, 100);
            this.knowledgeLoss = builder.comment("Knowledge of Death loss why dying [0..500|default:0]").translation(ConfigTombstone.getTranslation("knowledge_loss")).defineInRange("knowledge_loss", 0, 0, 500);
            this.nerfGhostlyShape = builder.comment("Whether to cancel the Ghostly Shape effect on breaking a block or opening a chest [false/true|default:false]").translation(ConfigTombstone.getTranslation("nerf_ghostly_shape")).define("nerf_ghostly_shape", false);
            this.preventDeathOutsideWorld = builder.comment("Prevents death outside of world borders [false/true|default:false]").translation(ConfigTombstone.getTranslation("prevent_death_outside_world")).define("prevent_death_outside_world", false);
            this.pvpMode = builder.comment("Enables PvP mode, which allows players to open graves of players they kill [false/true|default:false]").translation(ConfigTombstone.getTranslation("pvp_mode")).define("pvp_mode", false);
            this.gravesBypassGriefingRules = builder.comment("Whether graves should be allowed to bypass anti-griefing rules [false/true|default:true]").translation(ConfigTombstone.getTranslation("graves_bypass_griefing_rules")).define("graves_bypass_griefing_rules", true);
            this.blackListEffects = builder.comment("Effects that are never preserved on death").translation(ConfigTombstone.getTranslation("black_list_effects")).define("black_list_effects", (Object)Lists.newArrayList((Object[])new String[]{"tombstone:ghostly_shape", "tombstone:preservation", "tombstone:exorcism", "minecraft:bad_omen", "minecraft:glowing"}));
            this.noGraveLocation = builder.comment("Graveless Areas").translation(ConfigTombstone.getTranslation("no_grave_location")).define("no_grave_location", (Object)Lists.newArrayList((Object[])new String[]{"0, 0, 0, -10000, 20"}));
            this.chanceMobOnGraveRecovery = builder.comment("The chance that creatures appear after the contents of a grave are retrieved [0..100|default:0]").translation(ConfigTombstone.getTranslation("chance_mob_on_grave_recovery")).defineInRange("chance_mob_on_grave_recovery", 0, 0, 100);
            this.knowledgeReducePhantomSpawn = builder.comment("Increases the minimum time without sleeping for phantom spawn around player based on their level in Knowledge of Death [false/true|default:true]").translation(ConfigTombstone.getTranslation("knowledge_reduce_phantom_spawn")).define("knowledge_reduce_phantom_spawn", true);
            this.timeForPhantomSpawn = builder.comment("Minimum time without sleeping for phantom to spawn around players [1200..MAX|default:72000]").translation(ConfigTombstone.getTranslation("time_for_phantom_spawn")).defineInRange("time_for_phantom_spawn", 72000, 1200, Integer.MAX_VALUE);
            this.persistantHalloween = builder.comment("The Halloween features also happen outside the dates of the event [false/true|default:false]").translation(ConfigTombstone.getTranslation("persistant_halloween")).worldRestart().define("persistant_halloween", false);
            this.allowGraveInWater = builder.comment("Allows player's graves to appear in water [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_grave_in_water")).define("allow_grave_in_water", true);
            this.allowBeyondTheGraveDamage = builder.comment("Allows players to be hurt by special damages related to some items [false/true|default:true]").translation(ConfigTombstone.getTranslation("allow_beyond_the_grave_damage")).define("allow_beyond_the_grave_damage", true);
            builder.pop();
        }
    }
}

