/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.network;

import com.buuz135.portality.data.PortalDataManager;
import com.buuz135.portality.data.PortalInformation;
import com.buuz135.portality.gui.GuiPortals;
import com.buuz135.portality.tile.TileController;
import com.buuz135.portality.util.BlockPosUtils;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.NetworkHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PortalNetworkMessage {
    public static void sendInformationToPlayer(ServerPlayerEntity playerEntity, boolean interdimensional, BlockPos pos, int distance) {
        ArrayList<PortalInformation> infos = new ArrayList<PortalInformation>(PortalDataManager.getData(playerEntity.field_70170_p).getInformationList());
        infos.removeIf(information -> information.getDimension() == playerEntity.func_71121_q().func_201675_m().func_186058_p().func_186068_a() && information.getLocation().equals((Object)pos));
        infos.removeIf(information -> {
            ServerWorld world = playerEntity.func_184102_h().func_71218_a(DimensionType.func_186069_a((int)information.getDimension()));
            return world.func_175625_s(information.getLocation()) instanceof TileController && !((TileController)world.func_175625_s(information.getLocation())).isFormed();
        });
        infos.removeIf(information -> !interdimensional && playerEntity.func_71121_q().func_201675_m().func_186058_p().func_186068_a() != information.getDimension());
        infos.removeIf(information -> interdimensional && playerEntity.func_130014_f_().func_201675_m().func_186058_p().func_186068_a() != information.getDimension() && !information.isInterdimensional());
        infos.removeIf(information -> {
            ServerWorld world = playerEntity.func_130014_f_().func_73046_m().func_71218_a(DimensionType.func_186069_a((int)information.getDimension()));
            TileEntity entity = world.func_175625_s(information.getLocation());
            return entity instanceof TileController && !interdimensional && playerEntity.func_130014_f_().func_201675_m().func_186058_p().func_186068_a() == information.getDimension() && (information.getLocation().func_218139_n(new Vec3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) >= distance || information.getLocation().func_218139_n(new Vec3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) >= BlockPosUtils.getMaxDistance(((TileController)entity).getLength()));
        });
        NetworkHandler.NETWORK.sendTo((Object)new Response(infos), playerEntity.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static class Response
    extends Message {
        private CompoundNBT compoundNBT = new CompoundNBT();

        public Response() {
        }

        public Response(List<PortalInformation> information) {
            information.forEach(portalInformation -> this.compoundNBT.func_218657_a(portalInformation.getId().toString(), (INBT)portalInformation.writetoNBT()));
        }

        protected void handleMessage(NetworkEvent.Context context) {
            Minecraft.func_71410_x().func_212871_a_(() -> {
                if (Minecraft.func_71410_x().field_71462_r instanceof GuiPortals) {
                    ArrayList<PortalInformation> information = new ArrayList<PortalInformation>();
                    this.compoundNBT.func_150296_c().forEach(s -> information.add(PortalInformation.readFromNBT(this.compoundNBT.func_74775_l(s))));
                    ((GuiPortals)Minecraft.func_71410_x().field_71462_r).refresh(information);
                }
            });
        }
    }
}

