/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.gui;

import com.buuz135.portality.gui.PortalityAssetProvider;
import com.buuz135.portality.proxy.CommonProxy;
import com.buuz135.portality.tile.TileController;
import com.buuz135.portality.util.BlockPosUtils;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.api.client.assets.types.IBackgroundAsset;
import com.hrznstudio.titanium.client.gui.GuiAddonScreen;
import com.hrznstudio.titanium.client.gui.ITileContainer;
import com.hrznstudio.titanium.client.gui.addon.BasicGuiAddon;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiController
extends GuiAddonScreen
implements ITileContainer<TileController> {
    private TileController controller;

    public GuiController(TileController controller) {
        super((IAssetProvider)PortalityAssetProvider.PROVIDER, true);
        this.controller = controller;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
    }

    public void renderBackground(int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(mouseX, mouseY, partialTicks);
    }

    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        IBackgroundAsset background = (IBackgroundAsset)IAssetProvider.getAsset((IAssetProvider)PortalityAssetProvider.PROVIDER, (IAssetType)AssetTypes.BACKGROUND);
        String name = new TranslationTextComponent(CommonProxy.BLOCK_CONTROLLER.func_149739_a(), new Object[0]).func_150254_d();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_211126_b(TextFormatting.DARK_AQUA + name, (float)(this.x + background.getArea().width / 2 - fontRenderer.func_78256_a(name) / 2), (float)(this.y + 3), 0);
        fontRenderer.func_211126_b(I18n.func_135052_a((String)"portality.gui.controller", (Object[])new Object[0]) + " " + this.controller.getPortalDisplayName().substring(0, Math.min(this.controller.getPortalDisplayName().length(), 26)), (float)(this.x + 10), (float)(this.y + 21), 0xFFFFFF);
        String string = I18n.func_135052_a((String)"portality.gui.controller.private", (Object[])new Object[0]) + " " + this.controller.isPrivate();
        float f = this.x + 10;
        fontRenderer.getClass();
        fontRenderer.func_211126_b(string, f, (float)(this.y + 21 + (9 + 1) * 1), 0xFFFFFF);
        String string2 = I18n.func_135052_a((String)"portality.gui.controller.max_distance", (Object[])new Object[0]) + " " + BlockPosUtils.getMaxDistance(this.controller.getLength());
        float f2 = this.x + 10;
        fontRenderer.getClass();
        fontRenderer.func_211126_b(string2, f2, (float)(this.y + 21 + (9 + 1) * 2), 0xFFFFFF);
        String string3 = I18n.func_135052_a((String)"portality.gui.controller.interdimensional", (Object[])new Object[0]) + " " + this.controller.isInterdimensional();
        float f3 = this.x + 10;
        fontRenderer.getClass();
        fontRenderer.func_211126_b(string3, f3, (float)(this.y + 21 + (9 + 1) * 3), 0xFFFFFF);
        String string4 = I18n.func_135052_a((String)"portality.gui.controller.power", (Object[])new Object[0]) + " " + new DecimalFormat().format(this.controller.getEnergyStorage().getEnergyStored()) + " FE";
        float f4 = this.x + 10;
        fontRenderer.getClass();
        fontRenderer.func_211126_b(string4, f4, (float)(this.y + 21 + (9 + 1) * 4), 0xFFFFFF);
        String string5 = I18n.func_135052_a((String)"portality.gui.controller.link", (Object[])new Object[0]) + " " + (this.controller.isActive() ? I18n.func_135052_a((String)"portality.gui.controller.link_active", (Object[])new Object[0]) : I18n.func_135052_a((String)"portality.gui.controller.link_missing", (Object[])new Object[0]));
        float f5 = this.x + 10;
        fontRenderer.getClass();
        fontRenderer.func_211126_b(string5, f5, (float)(this.y + 21 + (9 + 1) * 5), 0xFFFFFF);
        super.renderForeground(mouseX, mouseY, partialTicks);
    }

    public List<IFactory<IGuiAddon>> guiAddons() {
        ArrayList<IFactory<IGuiAddon>> addons = new ArrayList<IFactory<IGuiAddon>>();
        addons.add(() -> new BasicGuiAddon(this.x - 25, this.y + 9){

            public int getXSize() {
                return 0;
            }

            public int getYSize() {
                return 0;
            }

            public void drawGuiContainerBackgroundLayer(Screen guiScreen, IAssetProvider iAssetProvider, int i, int i1, int i2, int i3, float v) {
                IBackgroundAsset background = (IBackgroundAsset)IAssetProvider.getAsset((IAssetProvider)PortalityAssetProvider.PROVIDER, (IAssetType)AssetTypes.BACKGROUND);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(background.getResourceLocation());
                guiScreen.blit(GuiController.this.x - 25, GuiController.this.y + 9, 0, 110, 25, 97);
            }

            public void drawGuiContainerForegroundLayer(Screen guiScreen, IAssetProvider iAssetProvider, int i, int i1, int i2, int i3) {
            }
        });
        this.controller.getGuiAddons().forEach(iFactory -> addons.add((IFactory<IGuiAddon>)iFactory));
        return addons;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public TileController getTile() {
        return this.controller;
    }
}

