/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.block;

import com.buuz135.portality.Portality;
import com.buuz135.portality.data.PortalDataManager;
import com.buuz135.portality.data.PortalInformation;
import com.buuz135.portality.proxy.CommonProxy;
import com.buuz135.portality.tile.TileController;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.BlockRotation;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class BlockController
extends BlockRotation<TileController> {
    public BlockController() {
        super("controller", Block.Properties.func_200945_a((Material)Material.field_151576_e), TileController.class);
        this.setItemGroup(Portality.TAB);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        PortalInformation information = new PortalInformation(UUID.randomUUID(), placer.func_110124_au(), false, false, worldIn.func_201675_m().func_186058_p().func_186068_a(), pos, "Dim: " + DimensionType.func_212678_a((DimensionType)worldIn.func_201675_m().func_186058_p()).func_110623_a() + " X: " + pos.func_177958_n() + " Y: " + pos.func_177956_o() + " Z: " + pos.func_177952_p(), new ItemStack((IItemProvider)CommonProxy.BLOCK_FRAME), false);
        PortalDataManager.addInformation(worldIn, information);
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        super.func_176206_d(worldIn, pos, state);
        PortalDataManager.removeInformation(worldIn.func_201672_e(), pos);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        super.func_180652_a(worldIn, pos, explosionIn);
        PortalDataManager.removeInformation(worldIn, pos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Nonnull
    public BlockRotation.RotationType getRotationType() {
        return BlockRotation.RotationType.FOUR_WAY;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult ray) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (worldIn.func_201670_d()) {
            return true;
        }
        if (tile instanceof TileController) {
            TileController controller = (TileController)tile;
            if (!controller.isFormed()) {
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent(TextFormatting.RED + I18n.func_135052_a((String)"portality.controller.error.size", (Object[])new Object[0]), new Object[0]), true);
                return true;
            }
            if (controller.isPrivate() && !controller.getOwner().equals(playerIn.func_110124_au())) {
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent(TextFormatting.RED + I18n.func_135052_a((String)"portality.controller.error.privacy", (Object[])new Object[0]), new Object[0]), true);
                return true;
            }
            if (playerIn.func_70093_af() && controller.getOwner().equals(playerIn.func_110124_au()) && !playerIn.func_184586_b(hand).func_190926_b() && !playerIn.func_184586_b(hand).func_77969_a(controller.getDisplay())) {
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + I18n.func_135052_a((String)"portility.controller.info.icon_changed", (Object[])new Object[0]), new Object[0]), true);
                controller.setDisplayNameEnabled(playerIn.func_184586_b(hand));
                return true;
            }
        }
        return super.func_220051_a(state, worldIn, pos, playerIn, hand, ray);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof TileController) {
            ((TileController)entity).breakController();
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public IFactory<TileController> getTileEntityFactory() {
        return TileController::new;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileController();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

