/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature;

import biomesoplenty.common.util.block.IBlockPosQuery;
import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class NetherVinesFeature
extends Feature<NoFeatureConfig> {
    protected IBlockPosQuery placeOn = (world, pos) -> world.func_180495_p(pos).func_177230_c() == Blocks.field_150424_aL;
    protected IBlockPosQuery replace = (world, pos) -> world.func_180495_p(pos).isAir((IBlockReader)world, pos);
    int minHeight = 8;
    int maxHeight = 20;

    public NetherVinesFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> deserializer) {
        super(deserializer);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> p_212245_2_, Random rand, BlockPos startPos, NoFeatureConfig p_212245_5_) {
        while (startPos.func_177956_o() > 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches(world, startPos.func_177982_a(2, 0, 2))) {
            return false;
        }
        for (int i = 0; i < 128; ++i) {
            BlockPos genPos = startPos.func_177982_a(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(3) - rand.nextInt(3), rand.nextInt(4) - rand.nextInt(4));
            if (!this.replace.matches(world, genPos) || !this.placeOn.matches(world, genPos.func_177984_a())) continue;
            BlockState vineState = Blocks.field_150395_bd.func_176223_P();
            ArrayList validDirections = Lists.newArrayList();
            for (Direction facing : Direction.values()) {
                if (facing == Direction.UP || facing == Direction.DOWN || !this.placeOn.matches(world, genPos.func_177972_a(facing))) continue;
                validDirections.add(facing);
            }
            if (validDirections.isEmpty()) continue;
            Direction direction = (Direction)validDirections.get(rand.nextInt(validDirections.size()));
            vineState = (BlockState)vineState.func_206870_a((IProperty)VineBlock.func_176267_a((Direction)direction), (Comparable)Boolean.valueOf(true));
            int targetHeight = this.minHeight + rand.nextInt(this.maxHeight);
            for (int height = 0; height <= targetHeight; ++height) {
                BlockPos offsetPos = genPos.func_177979_c(height);
                if (!this.replace.matches(world, offsetPos) || !vineState.func_177230_c().func_196260_a(vineState, (IWorldReader)world, offsetPos)) {
                    return false;
                }
                world.func_180501_a(offsetPos, vineState, 2);
            }
        }
        return true;
    }

    public boolean setBlock(IWorld world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            this.func_202278_a((IWorldWriter)world, pos, state);
            return true;
        }
        return false;
    }
}

