/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.client.colors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple4d;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.blocks.IMaterialFormBlockItem;
import thelm.jaopca.api.fluids.IMaterialFormBucketItem;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.api.materialforms.IMaterialForm;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.items.ItemFormType;

public class ColorHandler {
    public static final IBlockColor BLOCK_COLOR = (state, world, pos, tintIndex) -> {
        Block block;
        if (tintIndex == 0 && (block = state.func_177230_c()) instanceof IMaterialForm) {
            IMaterialForm materialForm = (IMaterialForm)block;
            return materialForm.getMaterial().getColor();
        }
        return -1;
    };
    public static final IItemColor ITEM_COLOR = (stack, tintIndex) -> {
        Item item;
        if ((tintIndex == 0 || tintIndex == 2) && (item = stack.func_77973_b()) instanceof IMaterialForm) {
            IMaterialForm materialForm = (IMaterialForm)item;
            return materialForm.getMaterial().getColor();
        }
        return -1;
    };

    public static void setup(ColorHandlerEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        for (IMaterialFormBlock block : BlockFormType.getBlocks()) {
            blockColors.func_186722_a(BLOCK_COLOR, new Block[]{block.asBlock()});
        }
        for (IMaterialFormBlockItem blockItem : BlockFormType.getBlockItems()) {
            itemColors.func_199877_a(ITEM_COLOR, new IItemProvider[]{blockItem.asBlockItem()});
        }
        for (IMaterialFormItem item : ItemFormType.getItems()) {
            itemColors.func_199877_a(ITEM_COLOR, new IItemProvider[]{item.asItem()});
        }
        for (IMaterialFormFluidBlock fluidBlock : FluidFormType.getFluidBlocks()) {
            blockColors.func_186722_a(BLOCK_COLOR, new Block[]{fluidBlock.asBlock()});
        }
        for (IMaterialFormBucketItem bucketItem : FluidFormType.getBucketItems()) {
            itemColors.func_199877_a(ITEM_COLOR, new IItemProvider[]{bucketItem.asItem()});
        }
    }

    public static int getAverageColor(Tag<Item> tag) {
        Tuple4d color = ColorHandler.weightedAverageColor(tag.func_199885_a(), ConfigHandler.gammaValue);
        return ColorHandler.toColorInt(color);
    }

    public static Tuple4d weightedAverageColor(Collection<Item> items, double gammaValue) {
        if (items.isEmpty()) {
            return new Point4d(1.0, 1.0, 1.0, 0.0);
        }
        List<Tuple4d> colors = items.stream().map(ItemStack::new).map(stack -> ColorHandler.weightedAverageColor(stack, gammaValue)).collect(Collectors.toList());
        return ColorHandler.weightedAverageColor(colors, gammaValue);
    }

    public static Tuple4d weightedAverageColor(ItemStack stack, double gammaValue) {
        List<BakedQuad> quads = ColorHandler.getBakedQuads(stack);
        if (quads.isEmpty()) {
            return new Point4d(1.0, 1.0, 1.0, 0.0);
        }
        ArrayList<Tuple4d> colors = new ArrayList<Tuple4d>();
        for (BakedQuad quad : quads) {
            Tuple4d color = ColorHandler.weightedAverageColor(quad.func_187508_a(), gammaValue);
            color = ColorHandler.tintColor(color, ColorHandler.getTint(stack, quad));
            colors.add(color);
        }
        return ColorHandler.weightedAverageColor(colors, gammaValue);
    }

    public static Tuple4d weightedAverageColor(TextureAtlasSprite texture, double gammaValue) {
        int width = texture.func_94211_a();
        int height = texture.func_94216_b();
        int frameCount = texture.func_110970_k();
        if (width <= 0 || height <= 0 || frameCount <= 0) {
            return new Point4d(1.0, 1.0, 1.0, 0.0);
        }
        ArrayList<Tuple4d> colors = new ArrayList<Tuple4d>();
        for (int frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int color = texture.getPixelRGBA(frameIndex, x, y);
                    colors.add(ColorHandler.toColorTuple(color));
                }
            }
        }
        return ColorHandler.weightedAverageColor(colors, gammaValue);
    }

    public static Tuple4d weightedAverageColor(List<Tuple4d> colors, double gammaValue) {
        if (colors.isEmpty()) {
            return new Point4d(1.0, 1.0, 1.0, 0.0);
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        double totalWeight = 0.0;
        if (gammaValue == 0.0) {
            r = 1.0;
            g = 1.0;
            b = 1.0;
            for (Tuple4d color : colors) {
                double weight = color.getW();
                totalWeight += weight;
                r *= color.getX() * weight;
                g *= color.getY() * weight;
                b *= color.getZ() * weight;
            }
            r = Math.pow(r, 1.0 / totalWeight);
            g = Math.pow(g, 1.0 / totalWeight);
            b = Math.pow(b, 1.0 / totalWeight);
        } else {
            for (Tuple4d color : colors) {
                double weight = color.getW();
                totalWeight += weight;
                r += Math.pow(color.getX(), gammaValue) * weight;
                g += Math.pow(color.getY(), gammaValue) * weight;
                b += Math.pow(color.getZ(), gammaValue) * weight;
            }
            r = Math.pow(r / totalWeight, 1.0 / gammaValue);
            g = Math.pow(g / totalWeight, 1.0 / gammaValue);
            b = Math.pow(b / totalWeight, 1.0 / gammaValue);
        }
        return new Point4d(MathHelper.func_151237_a((double)r, (double)0.0, (double)1.0), MathHelper.func_151237_a((double)g, (double)0.0, (double)1.0), MathHelper.func_151237_a((double)b, (double)0.0, (double)1.0), MathHelper.func_151237_a((double)(totalWeight / (double)colors.size()), (double)0.0, (double)1.0));
    }

    public static Tuple4d toColorTuple(int color) {
        return new Point4d((double)(color & 0xFF) / 255.0, (double)(color >> 8 & 0xFF) / 255.0, (double)(color >> 16 & 0xFF) / 255.0, (double)(color >> 24 & 0xFF) / 255.0);
    }

    public static Tuple4d tintColor(Tuple4d color, int tint) {
        return new Point4d(color.getX() * (double)(tint >> 16 & 0xFF) / 255.0, color.getY() * (double)(tint >> 8 & 0xFF) / 255.0, color.getZ() * (double)(tint & 0xFF) / 255.0, color.getW());
    }

    public static int toColorInt(Tuple4d color) {
        int ret = 0;
        ret = (int)((long)ret | (Math.round(MathHelper.func_151237_a((double)(color.getX() * 255.0), (double)0.0, (double)255.0)) & 0xFFL) << 16);
        ret = (int)((long)ret | (Math.round(MathHelper.func_151237_a((double)(color.getY() * 255.0), (double)0.0, (double)255.0)) & 0xFFL) << 8);
        ret = (int)((long)ret | Math.round(MathHelper.func_151237_a((double)(color.getZ() * 255.0), (double)0.0, (double)255.0)) & 0xFFL);
        return ret;
    }

    public static List<BakedQuad> getBakedQuads(ItemStack stack) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_204206_b(stack);
        model.func_200117_a(null, null, new Random(0L)).stream().filter(quad -> quad.func_178210_d() == Direction.SOUTH).forEach(quads::add);
        for (Direction facing : Direction.values()) {
            model.func_200117_a(null, facing, new Random(0L)).stream().filter(quad -> quad.func_178210_d() == Direction.SOUTH).forEach(quads::add);
        }
        return quads;
    }

    public static int getTint(ItemStack stack, BakedQuad quad) {
        return Minecraft.func_71410_x().getItemColors().func_186728_a(stack, quad.func_178211_c());
    }
}

