/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.blocks;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ToolType;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;

public class JAOPCABlock
extends Block
implements IMaterialFormBlock {
    private final IForm form;
    private final IMaterial material;
    protected final IBlockFormSettings settings;
    protected Optional<Material> blockMaterial = Optional.empty();
    protected Optional<MaterialColor> field_181083_K = Optional.empty();
    protected boolean field_196274_w;
    protected Optional<SoundType> field_149762_H = Optional.empty();
    protected OptionalInt field_149784_t = OptionalInt.empty();
    protected OptionalDouble field_149782_v = OptionalDouble.empty();
    protected OptionalDouble explosionResistance = OptionalDouble.empty();
    protected OptionalDouble field_149765_K = OptionalDouble.empty();
    protected VoxelShape shape;
    protected VoxelShape raytraceShape;
    protected BlockRenderLayer renderLayer;
    protected Optional<ToolType> harvestTool = Optional.empty();
    protected OptionalInt harvestLevel = OptionalInt.empty();
    protected Optional<Boolean> isBeaconBase = Optional.empty();
    protected OptionalInt flammability = OptionalInt.empty();
    protected OptionalInt fireSpreadSpeed = OptionalInt.empty();
    protected Optional<Boolean> isFireSource = Optional.empty();

    public JAOPCABlock(IForm form, IMaterial material, IBlockFormSettings settings) {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200951_a(settings.getLightValueFunction().applyAsInt(material)));
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.field_196274_w = settings.getBlocksMovement();
        this.shape = settings.getShape();
        this.raytraceShape = settings.getRaytraceShape();
        this.renderLayer = settings.getRenderLayer();
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public Material func_149688_o(BlockState blockState) {
        if (!this.blockMaterial.isPresent()) {
            this.blockMaterial = Optional.of(this.settings.getMaterialFunction().apply(this.material));
        }
        return this.blockMaterial.get();
    }

    public MaterialColor func_180659_g(BlockState blockState, IBlockReader world, BlockPos pos) {
        if (!this.field_181083_K.isPresent()) {
            this.field_181083_K = Optional.of(this.settings.getMaterialColorFunction().apply(this.material));
        }
        return this.field_181083_K.get();
    }

    public SoundType func_220072_p(BlockState blockState) {
        if (!this.field_149762_H.isPresent()) {
            this.field_149762_H = Optional.of(this.settings.getSoundTypeFunction().apply(this.material));
        }
        return this.field_149762_H.get();
    }

    public int getLightValue(BlockState state, IEnviromentBlockReader world, BlockPos pos) {
        if (!this.field_149784_t.isPresent()) {
            this.field_149784_t = OptionalInt.of(this.settings.getLightValueFunction().applyAsInt(this.material));
        }
        return this.field_149784_t.getAsInt();
    }

    public float func_176195_g(BlockState blockState, IBlockReader world, BlockPos pos) {
        if (!this.field_149782_v.isPresent()) {
            this.field_149782_v = OptionalDouble.of(this.settings.getBlockHardnessFunction().applyAsDouble(this.material));
        }
        return (float)this.field_149782_v.getAsDouble();
    }

    public float func_149638_a() {
        if (!this.explosionResistance.isPresent()) {
            this.explosionResistance = OptionalDouble.of(this.settings.getExplosionResistanceFunction().applyAsDouble(this.material));
        }
        return (float)this.explosionResistance.getAsDouble();
    }

    public float getSlipperiness(BlockState blockState, IWorldReader world, BlockPos pos, Entity entity) {
        if (!this.field_149765_K.isPresent()) {
            this.field_149765_K = OptionalDouble.of(this.settings.getSlipperinessFunction().applyAsDouble(this.material));
        }
        return (float)this.field_149765_K.getAsDouble();
    }

    public boolean func_200124_e(BlockState blockState) {
        return this.field_196274_w && blockState.func_177230_c().func_180664_k() == BlockRenderLayer.SOLID;
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.shape;
    }

    public VoxelShape func_220071_b(BlockState blockState, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.field_196274_w ? blockState.func_196954_c(world, pos) : VoxelShapes.func_197880_a();
    }

    public VoxelShape func_199600_g(BlockState blockState, IBlockReader world, BlockPos pos) {
        return this.raytraceShape;
    }

    public BlockRenderLayer func_180664_k() {
        return this.renderLayer;
    }

    public ToolType getHarvestTool(BlockState blockState) {
        if (!this.harvestTool.isPresent()) {
            this.harvestTool = Optional.ofNullable(this.settings.getHarvestToolFunction().apply(this.material));
        }
        return this.harvestTool.orElse(null);
    }

    public int getHarvestLevel(BlockState blockState) {
        if (!this.harvestLevel.isPresent()) {
            this.harvestLevel = OptionalInt.of(this.settings.getHarvestLevelFunction().applyAsInt(this.material));
        }
        return this.harvestLevel.getAsInt();
    }

    public boolean isBeaconBase(BlockState blockState, IWorldReader world, BlockPos pos, BlockPos beacon) {
        if (!this.isBeaconBase.isPresent()) {
            this.isBeaconBase = Optional.of(this.settings.getIsBeaconBaseFunction().test(this.material));
        }
        return this.isBeaconBase.get();
    }

    public int getFlammability(BlockState blockState, IBlockReader world, BlockPos pos, Direction face) {
        if (!this.flammability.isPresent()) {
            this.flammability = OptionalInt.of(this.settings.getFireSpreadSpeedFunction().applyAsInt(this.material));
        }
        return this.flammability.getAsInt();
    }

    public int getFireSpreadSpeed(BlockState blockState, IBlockReader world, BlockPos pos, Direction face) {
        if (!this.fireSpreadSpeed.isPresent()) {
            this.fireSpreadSpeed = OptionalInt.of(this.settings.getFlammabilityFunction().applyAsInt(this.material));
        }
        return this.fireSpreadSpeed.getAsInt();
    }

    public boolean isFireSource(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        if (!this.isFireSource.isPresent()) {
            this.isFireSource = Optional.of(this.settings.getIsFireSourceFunction().test(this.material));
        }
        return this.isFireSource.get();
    }

    public ITextComponent func_200291_n() {
        return JAOPCAApi.instance().currentLocalizer().localizeMaterialForm("block.jaopca." + this.form.getName(), this.material, this.func_149739_a());
    }
}

