/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class TeleportationUtils {
    public static Entity teleportEntity(Entity entity, DimensionType dimension, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return entity;
        }
        MinecraftServer server = entity.func_184102_h();
        DimensionType sourceDim = entity.field_70170_p.func_201675_m().func_186058_p();
        if (!entity.func_184207_aI() && !entity.func_184218_aH()) {
            return TeleportationUtils.handleEntityTeleport(entity, server, sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        }
        Entity rootEntity = entity.func_184208_bv();
        PassengerHelper passengerHelper = new PassengerHelper(rootEntity);
        PassengerHelper rider = passengerHelper.getPassenger(entity);
        if (rider == null) {
            return entity;
        }
        passengerHelper.teleport(server, sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        passengerHelper.remountRiders();
        passengerHelper.updateClients();
        return rider.entity;
    }

    public static Entity teleportEntity(Entity entity, DimensionType dimension, double xCoord, double yCoord, double zCoord) {
        return TeleportationUtils.teleportEntity(entity, dimension, xCoord, yCoord, zCoord, entity.field_70177_z, entity.field_70125_A);
    }

    private static Entity handleEntityTeleport(Entity entity, MinecraftServer server, DimensionType sourceDim, DimensionType targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        boolean interDimensional;
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return entity;
        }
        boolean bl = interDimensional = sourceDim != targetDim;
        if (interDimensional && !ForgeHooks.onTravelToDimension((Entity)entity, (DimensionType)targetDim)) {
            return entity;
        }
        if (interDimensional) {
            if (entity instanceof ServerPlayerEntity) {
                return TeleportationUtils.teleportPlayerInterdimentional((ServerPlayerEntity)entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
            return TeleportationUtils.teleportEntityInterdimentional(entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
        }
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
            player.func_70034_d(yaw);
        } else {
            entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            entity.func_70034_d(yaw);
        }
        return entity;
    }

    private static Entity teleportEntityInterdimentional(Entity entity, MinecraftServer server, DimensionType sourceDim, DimensionType targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (!entity.func_70089_S()) {
            return null;
        }
        ServerWorld sourceWorld = server.func_71218_a(sourceDim);
        ServerWorld targetWorld = server.func_71218_a(targetDim);
        if (entity.func_70089_S() && entity instanceof MinecartEntity) {
            entity.field_70128_L = true;
            entity.func_212321_a(targetDim);
            entity.field_70128_L = false;
        }
        entity.field_71093_bK = targetDim;
        sourceWorld.func_217467_h(entity);
        entity.field_70128_L = false;
        entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
        sourceWorld.func_217479_a(entity);
        Entity newEntity = entity.func_200600_R().func_200721_a((World)targetWorld);
        if (newEntity != null) {
            newEntity.func_180432_n(entity);
            newEntity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            boolean flag = newEntity.field_98038_p;
            newEntity.field_98038_p = true;
            targetWorld.func_217376_c(newEntity);
            newEntity.field_98038_p = flag;
            targetWorld.func_217479_a(newEntity);
        }
        entity.field_70128_L = true;
        sourceWorld.func_82742_i();
        targetWorld.func_82742_i();
        return newEntity;
    }

    private static PlayerEntity teleportPlayerInterdimentional(ServerPlayerEntity player, MinecraftServer server, DimensionType sourceDim, DimensionType destination, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        DimensionType dimensiontype = player.field_71093_bK;
        if (dimensiontype == DimensionType.field_223229_c_ && destination == DimensionType.field_223227_a_) {
            player.func_213319_R();
            player.func_71121_q().func_217434_e(player);
            if (!player.field_71136_j) {
                player.field_71136_j = true;
            }
            return player;
        }
        ServerWorld serverworld = player.field_71133_b.func_71218_a(dimensiontype);
        player.field_71093_bK = destination;
        ServerWorld serverworld1 = player.field_71133_b.func_71218_a(destination);
        WorldInfo worldinfo = player.field_70170_p.func_72912_H();
        player.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(destination, worldinfo.func_76067_t(), player.field_71134_c.func_73081_b()));
        player.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        PlayerList playerlist = player.field_71133_b.func_184103_al();
        playerlist.func_187243_f(player);
        serverworld.removeEntity((Entity)player, true);
        player.revive();
        double d0 = player.field_70165_t;
        double d1 = player.field_70163_u;
        double d2 = player.field_70161_v;
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        double d3 = 8.0;
        float f2 = f1;
        serverworld.func_217381_Z().func_76320_a("moving");
        double moveFactor = serverworld.func_201675_m().getMovementFactor() / serverworld1.func_201675_m().getMovementFactor();
        d0 *= moveFactor;
        d2 *= moveFactor;
        if (dimensiontype == DimensionType.field_223227_a_ && destination == DimensionType.field_223228_b_) {
            player.field_193110_cw = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        } else if (dimensiontype == DimensionType.field_223227_a_ && destination == DimensionType.field_223229_c_) {
            BlockPos blockpos = serverworld1.func_180504_m();
            d0 = blockpos.func_177958_n();
            d1 = blockpos.func_177956_o();
            d2 = blockpos.func_177952_p();
            f1 = 90.0f;
            f = 0.0f;
        }
        serverworld.func_217381_Z().func_76319_b();
        player.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
        player.func_213317_d(Vec3d.field_186680_a);
        player.func_70029_a((World)serverworld1);
        serverworld1.func_217447_b(player);
        player.func_213846_b(serverworld);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, f1, f);
        player.field_71134_c.func_73080_a(serverworld1);
        player.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        playerlist.func_72354_b(player, serverworld1);
        playerlist.func_72385_f(player);
        for (EffectInstance effectinstance : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(player.func_145782_y(), effectinstance));
        }
        player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)player, (DimensionType)dimensiontype, (DimensionType)destination);
        return player;
    }

    public static Entity getHighestRidingEntity(Entity mount) {
        Entity entity = mount;
        while (entity.func_184188_bt().size() > 0) {
            entity = (Entity)entity.func_184188_bt().get(0);
        }
        return entity;
    }

    private static class PassengerHelper {
        public Entity entity;
        public LinkedList<PassengerHelper> passengers = new LinkedList();
        public double offsetX;
        public double offsetY;
        public double offsetZ;

        public PassengerHelper(Entity entity) {
            this.entity = entity;
            if (entity.func_184218_aH()) {
                this.offsetX = entity.field_70165_t - entity.func_184187_bx().field_70165_t;
                this.offsetY = entity.field_70163_u - entity.func_184187_bx().field_70163_u;
                this.offsetZ = entity.field_70161_v - entity.func_184187_bx().field_70161_v;
            }
            for (Entity passenger : entity.func_184188_bt()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        public void teleport(MinecraftServer server, DimensionType sourceDim, DimensionType targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
            this.entity.func_184226_ay();
            this.entity = TeleportationUtils.handleEntityTeleport(this.entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            for (PassengerHelper passenger : this.passengers) {
                passenger.teleport(server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
        }

        public void remountRiders() {
            if (this.entity.func_184218_aH()) {
                this.entity.func_70012_b(this.entity.field_70165_t + this.offsetX, this.entity.field_70163_u + this.offsetY, this.entity.field_70161_v + this.offsetZ, this.entity.field_70177_z, this.entity.field_70125_A);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.entity.func_184205_a(this.entity, true);
                passenger.remountRiders();
            }
        }

        public void updateClients() {
            if (this.entity instanceof ServerPlayerEntity) {
                this.updateClient((ServerPlayerEntity)this.entity);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        private void updateClient(ServerPlayerEntity playerMP) {
            if (this.entity.func_184207_aI()) {
                playerMP.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket(this.entity));
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        public PassengerHelper getPassenger(Entity passenger) {
            if (this.entity == passenger) {
                return this;
            }
            for (PassengerHelper rider : this.passengers) {
                PassengerHelper re = rider.getPassenger(passenger);
                if (re == null) continue;
                return re;
            }
            return null;
        }
    }
}

