/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.container.impl;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import com.hrznstudio.titanium.container.TitaniumContainerBase;
import com.hrznstudio.titanium.container.impl.DisableableSlot;
import java.awt.Point;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;

public class ContainerInventoryBase
extends TitaniumContainerBase {
    private boolean isDisabled = false;
    private PlayerInventory inventory;
    private boolean hasPlayerInventory;

    public ContainerInventoryBase(int id, PlayerInventory inventory, PacketBuffer buffer) {
        super(id, inventory, buffer);
    }

    public ContainerInventoryBase(ContainerType type, PlayerInventory inventory, int id) {
        super(type, id);
        this.inventory = inventory;
        this.addPlayerChestInventory();
    }

    public ContainerInventoryBase(ContainerType type, PlayerInventory inventory, int id, IAssetProvider assetProvider) {
        super(type, id, assetProvider);
        this.inventory = inventory;
        this.addPlayerChestInventory();
    }

    public void addPlayerChestInventory() {
        Point invPos = IAssetProvider.getAsset(this.getAssetProvider(), AssetTypes.BACKGROUND).getInventoryPosition();
        if (this.hasPlayerInventory) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new DisableableSlot((IInventory)this.inventory, j + i * 9 + 9, invPos.x + j * 18, invPos.y + i * 18, this));
            }
        }
        this.hasPlayerInventory = true;
    }

    public PlayerInventory getPlayerInventory() {
        return this.inventory;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setDisabled(boolean disabled) {
        this.isDisabled = disabled;
    }
}

