/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.raytrace.DistanceRayTraceResult;
import com.hrznstudio.titanium.module.api.IAlternativeEntries;
import com.hrznstudio.titanium.module.api.RegistryManager;
import com.hrznstudio.titanium.recipe.LootPoolBlock;
import com.hrznstudio.titanium.recipe.generator.JsonDataGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class BlockBase
extends Block
implements IAlternativeEntries {
    public static JsonDataGenerator BLOCK_LOOT = new JsonDataGenerator(JsonDataGenerator.DataTypes.LOOT_BLOCKS, "titanium");
    private ItemGroup itemGroup = ItemGroup.field_78027_g;
    private BlockItem item;

    public BlockBase(String name, Block.Properties properties) {
        super(properties);
        this.setRegistryName(name);
        BLOCK_LOOT.addRecipe(new LootPoolBlock(this.getRegistryName(), this.getStaticDrops()));
    }

    @Nullable
    protected static DistanceRayTraceResult rayTraceBox(BlockPos pos, Vec3d start, Vec3d end, VoxelShape shape) {
        BlockRayTraceResult bbResult = shape.func_212433_a(start, end, pos);
        if (bbResult != null) {
            Vec3d hitVec = bbResult.func_216347_e();
            Direction sideHit = bbResult.func_216354_b();
            double dist = start.func_72438_d(hitVec);
            return new DistanceRayTraceResult(hitVec, sideHit, pos, shape, dist);
        }
        return null;
    }

    public float func_176195_g(BlockState blockState, IBlockReader worldIn, BlockPos pos) {
        return 1.5f;
    }

    public ResourceLocation func_220068_i() {
        return new ResourceLocation(this.getRegistryName().func_110624_b(), "blocks/" + this.getRegistryName().func_110624_b() + "_" + this.getRegistryName().func_110623_a());
    }

    @Nullable
    public RayTraceResult getRayTraceResult(BlockState state, World world, BlockPos pos, Vec3d start, Vec3d end, RayTraceResult original) {
        if (this.hasCustomBoxes(state, (IBlockReader)world, pos)) {
            return this.rayTraceBoxesClosest(start, end, pos, this.getBoundingBoxes(state, (IBlockReader)world, pos));
        }
        return super.getRayTraceResult(state, world, pos, start, end, original);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext selectionContext) {
        if (this.hasCustomBoxes(state, worldIn, pos)) {
            VoxelShape shape = null;
            for (VoxelShape shape1 : this.getBoundingBoxes(state, worldIn, pos)) {
                if (shape == null) {
                    shape = shape1;
                    continue;
                }
                shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)shape1, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            return shape;
        }
        return super.func_220071_b(state, worldIn, pos, selectionContext);
    }

    public IFactory<BlockItem> getItemBlockFactory() {
        return () -> (BlockItem)new BlockItem((Block)this, new Item.Properties().func_200916_a(this.itemGroup)).setRegistryName(Objects.requireNonNull(this.getRegistryName()));
    }

    @Override
    public void addAlternatives(RegistryManager registry) {
        this.item = this.getItemBlockFactory().create();
        registry.content(Item.class, this.item);
    }

    public Item func_199767_j() {
        return this.item;
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, IBlockReader source, BlockPos pos) {
        return Collections.emptyList();
    }

    public boolean hasCustomBoxes(BlockState state, IBlockReader source, BlockPos pos) {
        return false;
    }

    @Nullable
    protected RayTraceResult rayTraceBoxesClosest(Vec3d start, Vec3d end, BlockPos pos, List<VoxelShape> boxes) {
        ArrayList<DistanceRayTraceResult> results = new ArrayList<DistanceRayTraceResult>();
        for (VoxelShape box : boxes) {
            DistanceRayTraceResult hit = BlockBase.rayTraceBox(pos, start, end, box);
            if (hit == null) continue;
            results.add(hit);
        }
        DistanceRayTraceResult closestHit = null;
        double curClosest = Double.MAX_VALUE;
        for (DistanceRayTraceResult hit : results) {
            if (!(curClosest > hit.getDistance())) continue;
            closestHit = hit;
            curClosest = hit.getDistance();
        }
        return closestHit;
    }

    public ItemGroup getItemGroup() {
        return this.itemGroup;
    }

    public void setItemGroup(ItemGroup itemGroup) {
        this.itemGroup = itemGroup;
    }

    public List<Pool> getStaticDrops() {
        ArrayList<Pool> pools = new ArrayList<Pool>();
        pools.add(new Pool(1, new Pool.Entry[]{Pool.Entry.of(this)}, new Pool.Condition[]{Pool.Condition.of(new ResourceLocation("minecraft", "survives_explosion"))}));
        return pools;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, this.getDynamicDrops(state, worldIn, pos, newState, isMoving));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        NonNullList stacks = NonNullList.func_191196_a();
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity != null) {
            tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iItemHandler -> {
                for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                    stacks.add((Object)iItemHandler.getStackInSlot(i));
                }
            });
        }
        return stacks;
    }

    public boolean hasIndividualRenderVoxelShape() {
        return false;
    }

    public static class Pool {
        private int rolls;
        private Entry[] entries;
        private Condition[] conditions;

        public Pool(int rolls, Entry[] entries, Condition[] conditions) {
            this.rolls = rolls;
            this.entries = entries;
            this.conditions = conditions;
        }

        public static class Condition {
            private String condition;

            private Condition(String string) {
                this.condition = string;
            }

            public static Condition of(ResourceLocation location) {
                return new Condition(location.toString());
            }
        }

        public static class Entry {
            private final String type = "minecraft:item";
            private String name;

            private Entry(String name) {
                this.name = name;
            }

            public static Entry of(Block block) {
                return new Entry(block.getRegistryName().toString());
            }
        }
    }
}

