/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly;

import java.io.File;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.advancements.AdvancementTriggers;
import shadows.apotheosis.deadly.DeadlyLoot;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.gen.BossFeature;
import shadows.apotheosis.deadly.gen.BrutalSpawner;
import shadows.apotheosis.deadly.gen.SwarmSpawner;
import shadows.apotheosis.deadly.gen.WorldGenerator;
import shadows.apotheosis.util.ArmorSet;
import shadows.placebo.config.Configuration;

public class DeadlyModule {
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Deadly");

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisConstruction e) {
        DeadlyConfig.config = new Configuration(new File(Apotheosis.configDir, "deadly.cfg"));
    }

    @SubscribeEvent
    public void init(Apotheosis.ApotheosisSetup e) {
        DeadlyConfig.init();
        BrutalSpawner.init();
        BossFeature.init();
        DeadlyLoot.init();
        SwarmSpawner.init();
        WorldGenerator.init();
        ArmorSet.sortSets();
        MinecraftForge.EVENT_BUS.addListener(this::death);
    }

    public void death(LivingDeathEvent e) {
        DamageSource source;
        if (e.getEntity().getPersistentData().func_74767_n("apoth_boss") && (source = e.getSource()).func_76346_g() instanceof ServerPlayerEntity) {
            AdvancementTriggers.BOSS_TRIGGER.trigger(((ServerPlayerEntity)source.func_76346_g()).func_192039_O());
        }
    }
}

