/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.dimension;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.EndGenerationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EndDimension
extends Dimension {
    public static final BlockPos field_209958_g = new BlockPos(100, 50, 0);
    private final DragonFightManager field_186064_g;

    public EndDimension(World worldIn, DimensionType typeIn) {
        super(worldIn, typeIn);
        CompoundNBT compoundnbt = worldIn.func_72912_H().func_186347_a(typeIn);
        this.field_186064_g = worldIn instanceof ServerWorld ? new DragonFightManager((ServerWorld)worldIn, compoundnbt.func_74775_l("DragonFight"), this) : null;
    }

    @Override
    public ChunkGenerator<?> func_186060_c() {
        EndGenerationSettings endgenerationsettings = ChunkGeneratorType.field_206913_d.func_205483_a();
        endgenerationsettings.func_214969_a(Blocks.field_150377_bs.func_176223_P());
        endgenerationsettings.func_214970_b(Blocks.field_150350_a.func_176223_P());
        endgenerationsettings.func_205538_a(this.func_177496_h());
        return ChunkGeneratorType.field_206913_d.create(this.field_76579_a, (BiomeProvider)BiomeProviderType.field_205463_e.func_205457_a(BiomeProviderType.field_205463_e.func_205458_a().func_205446_a(this.field_76579_a.func_72905_C())), endgenerationsettings);
    }

    @Override
    public float func_76563_a(long worldTime, float partialTicks) {
        return 0.0f;
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        int i = 0xA080A0;
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.627451f;
        float f2 = 0.5019608f;
        float f3 = 0.627451f;
        return new Vec3d(f1 *= f * 0.0f + 0.15f, f2 *= f * 0.0f + 0.15f, f3 *= f * 0.0f + 0.15f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    @Override
    public boolean func_76567_e() {
        return false;
    }

    @Override
    public boolean func_76569_d() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float func_76571_f() {
        return 8.0f;
    }

    @Override
    @Nullable
    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        Random random = new Random(this.field_76579_a.func_72905_C());
        BlockPos blockpos = new BlockPos(chunkPosIn.func_180334_c() + random.nextInt(15), 0, chunkPosIn.func_180330_f() + random.nextInt(15));
        return this.field_76579_a.func_184141_c(blockpos).func_185904_a().func_76230_c() ? blockpos : null;
    }

    @Override
    public BlockPos func_177496_h() {
        return field_209958_g;
    }

    @Override
    @Nullable
    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        return this.func_206920_a(new ChunkPos(posX >> 4, posZ >> 4), checkValid);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return false;
    }

    @Override
    public void func_186057_q() {
        CompoundNBT compoundnbt = new CompoundNBT();
        if (this.field_186064_g != null) {
            compoundnbt.func_218657_a("DragonFight", this.field_186064_g.func_186088_a());
        }
        this.field_76579_a.func_72912_H().func_186345_a(this.field_76579_a.func_201675_m().func_186058_p(), compoundnbt);
    }

    @Override
    public void func_186059_r() {
        if (this.field_186064_g != null) {
            this.field_186064_g.func_186105_b();
        }
    }

    @Nullable
    public DragonFightManager func_186063_s() {
        return this.field_186064_g;
    }
}

