/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.data;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;

public class TransmitterInfo {
    private final BlockPos coordinate;
    private final String name;
    private final TeleportDestination teleportDestination;

    public TransmitterInfo(PacketBuffer buf) {
        this.coordinate = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.name = NetworkTools.readString((ByteBuf)buf);
        this.teleportDestination = new TeleportDestination(buf);
    }

    public TransmitterInfo(BlockPos coordinate, String name, TeleportDestination destination) {
        this.coordinate = coordinate;
        this.name = name;
        this.teleportDestination = destination == null ? new TeleportDestination(null, DimensionType.field_223227_a_) : destination;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.coordinate.func_177958_n());
        buf.writeInt(this.coordinate.func_177956_o());
        buf.writeInt(this.coordinate.func_177952_p());
        NetworkTools.writeString((ByteBuf)buf, (String)this.getName());
        this.teleportDestination.toBytes(buf);
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    public String getName() {
        return this.name;
    }

    public TeleportDestination getTeleportDestination() {
        return this.teleportDestination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransmitterInfo that = (TransmitterInfo)o;
        if (this.coordinate != null ? !this.coordinate.equals((Object)that.coordinate) : that.coordinate != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.teleportDestination.equals(that.teleportDestination);
    }

    public int hashCode() {
        int result = this.coordinate != null ? this.coordinate.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.teleportDestination.hashCode();
        return result;
    }
}

