/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.craftinggrid;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.McJtyLib;
import mcjty.lib.container.InventoryHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;

public class CraftingRecipe {
    private CraftingInventory inv = new CraftingInventory(new Container(null, -1){

        public boolean func_75145_c(PlayerEntity var1) {
            return false;
        }
    }, 3, 3);
    private ItemStack result = ItemStack.field_190927_a;
    private boolean recipePresent = false;
    private IRecipe recipe = null;
    private List<CompressedIngredient> compressedIngredients = null;
    private boolean keepOne = false;
    private CraftMode craftMode = CraftMode.EXT;

    public List<CompressedIngredient> getCompressedIngredients() {
        if (this.compressedIngredients == null) {
            this.compressedIngredients = new ArrayList<CompressedIngredient>();
            for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
                ItemStack stack = this.inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                boolean found = false;
                for (CompressedIngredient ingredient : this.compressedIngredients) {
                    if (!InventoryHelper.isItemStackConsideredEqual((ItemStack)stack, (ItemStack)ingredient.getStack())) continue;
                    ingredient.getStack().func_190917_f(stack.func_190916_E());
                    int[] nArray = ingredient.getGridDistribution();
                    int n = i;
                    nArray[n] = nArray[n] + stack.func_190916_E();
                    found = true;
                    break;
                }
                if (found) continue;
                CompressedIngredient ingredient = new CompressedIngredient(stack);
                int[] nArray = ingredient.getGridDistribution();
                int n = i;
                nArray[n] = nArray[n] + stack.func_190916_E();
                this.compressedIngredients.add(ingredient);
            }
        }
        return this.compressedIngredients;
    }

    public static IRecipe findRecipe(World world, CraftingInventory inv) {
        for (IRecipe r : McJtyLib.proxy.getRecipeManager(world).func_199510_b()) {
            if (r == null || !IRecipeType.field_222149_a.equals(r.func_222127_g()) || !r.func_77569_a((IInventory)inv, world)) continue;
            return r;
        }
        return null;
    }

    public void readFromNBT(CompoundNBT tagCompound) {
        ListNBT nbtTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < nbtTagList.size(); ++i) {
            CompoundNBT CompoundNBT2 = nbtTagList.func_150305_b(i);
            this.inv.func_70299_a(i, ItemStack.func_199557_a((CompoundNBT)CompoundNBT2));
        }
        CompoundNBT resultCompound = tagCompound.func_74775_l("Result");
        this.result = resultCompound != null ? ItemStack.func_199557_a((CompoundNBT)resultCompound) : ItemStack.field_190927_a;
        this.keepOne = tagCompound.func_74767_n("Keep");
        this.craftMode = CraftMode.values()[tagCompound.func_74771_c("Int")];
        this.recipePresent = false;
    }

    public void writeToNBT(CompoundNBT tagCompound) {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack stack = this.inv.func_70301_a(i);
            CompoundNBT CompoundNBT2 = new CompoundNBT();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(CompoundNBT2);
            }
            nbtTagList.add((Object)CompoundNBT2);
        }
        CompoundNBT resultCompound = new CompoundNBT();
        if (!this.result.func_190926_b()) {
            this.result.func_77955_b(resultCompound);
        }
        tagCompound.func_218657_a("Result", (INBT)resultCompound);
        tagCompound.func_218657_a("Items", (INBT)nbtTagList);
        tagCompound.func_74757_a("Keep", this.keepOne);
        tagCompound.func_74774_a("Int", (byte)this.craftMode.ordinal());
    }

    public void setRecipe(ItemStack[] items, ItemStack result) {
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            this.inv.func_70299_a(i, items[i]);
        }
        this.result = result;
        this.recipePresent = false;
    }

    public CraftingInventory getInventory() {
        return this.inv;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public IRecipe getCachedRecipe(World world) {
        if (!this.recipePresent) {
            this.recipePresent = true;
            this.recipe = CraftingRecipe.findRecipe(world, this.inv);
            this.compressedIngredients = null;
        }
        return this.recipe;
    }

    public boolean isKeepOne() {
        return this.keepOne;
    }

    public void setKeepOne(boolean keepOne) {
        this.keepOne = keepOne;
    }

    public CraftMode getCraftMode() {
        return this.craftMode;
    }

    public void setCraftMode(CraftMode craftMode) {
        this.craftMode = craftMode;
    }

    public static enum CraftMode {
        EXT("Ext"),
        INT("Int"),
        EXTC("ExtC");

        private final String description;

        private CraftMode(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class CompressedIngredient {
        private final ItemStack stack;
        private int[] gridDistribution = new int[9];

        public CompressedIngredient(ItemStack stack) {
            this.stack = stack;
            for (int i = 0; i < this.gridDistribution.length; ++i) {
                this.gridDistribution[i] = 0;
            }
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int[] getGridDistribution() {
            return this.gridDistribution;
        }
    }
}

