/*
 * Decompiled with CFR 0.152.
 */
package lumien.quickleafdecay;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import lumien.quickleafdecay.LeafTickScheduler;
import lumien.quickleafdecay.config.QuickLeafDecayConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="quickleafdecay")
public class QuickLeafDecay {
    public static final String MOD_ID = "quickleafdecay";
    static final String MOD_NAME = "Quick Leaf Decay";
    static final String MOD_VERSION = "@VERSION@";
    static Random rng = new Random();
    public static QuickLeafDecay INSTANCE;
    public QuickLeafDecayConfig config;
    Cache<BlockPos, Integer> brokenBlockCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).maximumSize(200L).build();

    public QuickLeafDecay() {
        INSTANCE = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::preInit);
        MinecraftForge.EVENT_BUS.addListener(this::breakBlock);
        MinecraftForge.EVENT_BUS.addListener(this::notifyNeighbors);
        MinecraftForge.EVENT_BUS.addListener(LeafTickScheduler.INSTANCE::tick);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, QuickLeafDecayConfig.spec);
        modEventBus.register(QuickLeafDecayConfig.class);
    }

    public void preInit(FMLCommonSetupEvent event) {
    }

    public void breakBlock(BlockEvent.BreakEvent event) {
        if (((Boolean)QuickLeafDecayConfig.playerDecay.get()).booleanValue() && !(event.getPlayer() instanceof FakePlayer) && !event.getWorld().func_201670_d()) {
            this.brokenBlockCache.put((Object)event.getPos(), (Object)0);
        }
    }

    public void notifyNeighbors(BlockEvent.NeighborNotifyEvent event) {
        BlockState notifierState;
        Block b;
        if ((!event.getWorld().func_201670_d() && !((Boolean)QuickLeafDecayConfig.playerDecay.get()).booleanValue() || this.brokenBlockCache.getIfPresent((Object)event.getPos()) != null) && (b = (notifierState = event.getState()).func_177230_c()).isAir(notifierState, (IBlockReader)event.getWorld(), event.getPos())) {
            if (((Boolean)QuickLeafDecayConfig.playerDecay.get()).booleanValue()) {
                this.brokenBlockCache.invalidate((Object)event.getPos());
            }
            for (Direction direction : event.getNotifiedSides()) {
                BlockState state;
                BlockPos offPos = event.getPos().func_177972_a(direction);
                if (!event.getWorld().func_175667_e(offPos) || !BlockTags.field_206952_E.func_199685_a_((Object)(state = event.getWorld().func_180495_p(offPos)).func_177230_c())) continue;
                if (((Boolean)QuickLeafDecayConfig.playerDecay.get()).booleanValue()) {
                    this.brokenBlockCache.put((Object)offPos, (Object)0);
                }
                LeafTickScheduler.INSTANCE.schedule((World)event.getWorld(), offPos, (Integer)QuickLeafDecayConfig.decaySpeed.get() + ((Integer)QuickLeafDecayConfig.decayFuzz.get() > 0 ? rng.nextInt((Integer)QuickLeafDecayConfig.decayFuzz.get()) : 0));
            }
        }
    }
}

