/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.rendering.OverlayRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketReturnInfo {
    private DimensionType dim;
    private BlockPos pos;
    private ProbeInfo probeInfo;

    public PacketReturnInfo(ByteBuf buf) {
        this.dim = DimensionType.func_186069_a((int)buf.readInt());
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        if (buf.readBoolean()) {
            this.probeInfo = new ProbeInfo();
            this.probeInfo.fromBytes(buf);
        } else {
            this.probeInfo = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim.func_186068_a());
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        if (this.probeInfo != null) {
            buf.writeBoolean(true);
            this.probeInfo.toBytes(buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    public PacketReturnInfo() {
    }

    public PacketReturnInfo(DimensionType dim, BlockPos pos, ProbeInfo probeInfo) {
        this.dim = dim;
        this.pos = pos;
        this.probeInfo = probeInfo;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> OverlayRenderer.registerProbeInfo(this.dim, this.pos, this.probeInfo));
        ctx.get().setPacketHandled(true);
    }
}

