/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.crafting.refining;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Objects;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.crafting.refining.FluidIngredient;

public class RefiningRecipe {
    private final ResourceLocation recipeId;
    private FluidIngredient input;
    private final List<FluidStack> outputs = NonNullList.func_191196_a();

    public RefiningRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public ResourceLocation getId() {
        return this.recipeId;
    }

    public boolean matches(IFluidTank inputTank) {
        return this.matches(inputTank.getFluid());
    }

    public boolean matches(FluidStack fluid) {
        return this.input.test(fluid);
    }

    public List<FluidStack> getResults() {
        NonNullList results = NonNullList.func_191196_a();
        this.outputs.forEach(arg_0 -> RefiningRecipe.lambda$getResults$0((List)results, arg_0));
        return results;
    }

    public static RefiningRecipe deserialize(ResourceLocation id, JsonObject json) {
        RefiningRecipe recipe = new RefiningRecipe(id);
        recipe.input = FluidIngredient.deserialize(json.getAsJsonObject("input"));
        for (JsonElement je : JSONUtils.func_151214_t((JsonObject)json, (String)"outputs")) {
            FluidStack stack = RefiningRecipe.deserializeFluid(je.getAsJsonObject());
            if (stack.isEmpty()) continue;
            recipe.outputs.add(stack);
        }
        return recipe;
    }

    public static RefiningRecipe read(PacketBuffer buffer) {
        RefiningRecipe recipe = new RefiningRecipe(buffer.func_192575_l());
        recipe.input = FluidIngredient.read(buffer);
        int count = buffer.readByte();
        for (int i = 0; i < count; ++i) {
            ResourceLocation fluidId = buffer.func_192575_l();
            int amount = buffer.func_150792_a();
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
            if (fluid != null) {
                recipe.outputs.add(new FluidStack(fluid, amount));
                continue;
            }
            SilentMechanisms.LOGGER.error("Unknown fluid: {}", (Object)fluidId);
        }
        return recipe;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.recipeId);
        this.input.write(buffer);
        buffer.writeByte(this.outputs.size());
        this.outputs.forEach(s -> {
            buffer.func_192572_a(Objects.requireNonNull(s.getFluid().getRegistryName()));
            buffer.func_150787_b(s.getAmount());
        });
    }

    private static FluidStack deserializeFluid(JsonObject json) {
        ResourceLocation fluidId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid"));
        int amount = JSONUtils.func_151208_a((JsonObject)json, (String)"amount", (int)1000);
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
        if (fluid == null) {
            throw new JsonSyntaxException("Unknown fluid: " + fluidId);
        }
        return new FluidStack(fluid, amount);
    }

    private static /* synthetic */ void lambda$getResults$0(List results, FluidStack s) {
        results.add(s.copy());
    }
}

