/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.config;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.fml.loading.FMLPaths;
import net.silentchaos512.mechanisms.config.OreConfig;
import net.silentchaos512.mechanisms.init.Ores;
import net.silentchaos512.utils.config.BooleanValue;
import net.silentchaos512.utils.config.ConfigSpecWrapper;

public final class Config {
    private static final ConfigSpecWrapper WRAPPER = ConfigSpecWrapper.create((Path)FMLPaths.CONFIGDIR.get().resolve("silents-mechanisms-common.toml"));
    public static final Common COMMON = new Common(WRAPPER);

    private Config() {
    }

    public static void init() {
        WRAPPER.validate();
        WRAPPER.validate();
    }

    public static class Common {
        private final BooleanValue oreWorldGenMasterSwitch;
        private final Map<Ores, OreConfig> oreConfigs = new EnumMap<Ores, OreConfig>(Ores.class);

        public Common(ConfigSpecWrapper wrapper) {
            wrapper.comment("world", "All world generation settings require you to restart Minecraft!");
            this.oreWorldGenMasterSwitch = wrapper.builder("world.masterSwitch").comment("Set to 'false' to completely disable ore generation from this mod, ignoring all other settings.", new String[]{"You can also enable/disable ores individually, but this is useful if you plan to use another mod for ore generation."}).define(true);
            Arrays.stream(Ores.values()).forEach(ore -> this.oreConfigs.put((Ores)((Object)ore), new OreConfig((Ores)((Object)ore), wrapper, this.oreWorldGenMasterSwitch)));
        }

        public Optional<OreConfig> getOreConfig(Ores ore) {
            if (this.oreConfigs.containsKey((Object)ore)) {
                return Optional.of(this.oreConfigs.get((Object)ore));
            }
            return Optional.empty();
        }
    }
}

