/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.tools;

import com.direwolf20.buildinggadgets.common.util.helpers.InventoryHelper;
import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ForgeRegistries;

public final class UniqueItem {
    public static final UniqueItem AIR = new UniqueItem(Items.field_190931_a);
    private final Item item;

    public static UniqueItem readFromNBT(CompoundNBT compound) {
        return new UniqueItem((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.func_74779_i("item"))));
    }

    public static UniqueItem fromBlockState(BlockState state, PlayerEntity player, BlockPos pos) {
        ItemStack itemStack = InventoryHelper.getSilkTouchDrop(state);
        if (!itemStack.func_190926_b()) {
            return new UniqueItem(itemStack.func_77973_b());
        }
        return AIR;
    }

    public UniqueItem(Item i) {
        Preconditions.checkArgument((Objects.requireNonNull(i).getRegistryName() != null ? 1 : 0) != 0, (Object)"Attempted to create UniqueItem for an not registered Item! This is not possible!");
        this.item = i;
    }

    public Item getItem() {
        return this.item;
    }

    public ItemStack toItemStack() {
        return new ItemStack((IItemProvider)this.getItem());
    }

    public boolean equals(UniqueItem uniqueItem) {
        return uniqueItem.item.equals(this.item);
    }

    public void writeToNBT(CompoundNBT compound) {
        assert (this.item.getRegistryName() != null);
        compound.func_74778_a("item", this.getItem().getRegistryName().toString());
    }

    public int hashCode() {
        assert (this.item.getRegistryName() != null);
        return this.item.getRegistryName().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return !(o instanceof UniqueItem) ? false : this.equals((UniqueItem)o);
    }
}

