/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.helpers;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.pastes.ConstructionPaste;
import com.direwolf20.buildinggadgets.common.items.pastes.GenericPasteContainer;
import com.direwolf20.buildinggadgets.common.registry.objects.BGItems;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class InventoryHelper {
    private static IProperty AXIS = EnumProperty.func_177709_a((String)"axis", Direction.Axis.class);
    private static final Set<IProperty> SAFE_PROPERTIES = ImmutableSet.of((Object)SlabBlock.field_196505_a, (Object)StairsBlock.field_176308_b, (Object)LogBlock.field_176298_M, (Object)AXIS, (Object)DirectionalBlock.field_176387_N, (Object)StairsBlock.field_176309_a, (Object[])new IProperty[]{TrapDoorBlock.field_176285_M, TrapDoorBlock.field_176283_b, StairsBlock.field_176310_M, LeverBlock.field_176359_b, RepeaterBlock.field_176410_b, PaneBlock.field_196411_b, PaneBlock.field_196414_y, PaneBlock.field_196409_a, PaneBlock.field_196413_c});
    private static final Set<IProperty> SAFE_PROPERTIES_COPY_PASTE = ImmutableSet.builder().addAll(SAFE_PROPERTIES).addAll((Iterable)ImmutableSet.of((Object)RailBlock.field_176565_b, (Object)PoweredRailBlock.field_176568_b, (Object)ChestBlock.field_196314_b)).build();

    public static boolean giveItem(ItemStack itemStack, PlayerEntity player, IWorld world) {
        List<IItemHandler> invContainers;
        ItemStack giveItemStack;
        if (player.func_184812_l_()) {
            return true;
        }
        if (itemStack.func_77973_b() instanceof ConstructionPaste) {
            itemStack = InventoryHelper.addPasteToContainer(player, itemStack);
        }
        if (itemStack.func_190916_E() == 0) {
            return true;
        }
        PlayerInventory inv = player.field_71071_by;
        List<Integer> slots = InventoryHelper.findItem(itemStack.func_77973_b(), inv);
        for (int slot : slots) {
            boolean success;
            ItemStack stackInSlot = inv.func_70301_a(slot);
            if (stackInSlot.func_190916_E() >= stackInSlot.func_77973_b().getItemStackLimit(stackInSlot) || !(success = inv.func_70441_a(giveItemStack = itemStack.func_77946_l()))) continue;
            return true;
        }
        ItemStack tool = AbstractGadget.getGadget(player);
        IItemHandler remoteInventory = GadgetUtils.getRemoteInventory(tool, world.func_201672_e());
        if (remoteInventory != null) {
            for (int i = 0; i < remoteInventory.getSlots(); ++i) {
                ItemStack containerItem = remoteInventory.getStackInSlot(i);
                ItemStack giveItemStack2 = itemStack.func_77946_l();
                if (containerItem.func_77973_b() != itemStack.func_77973_b() && !containerItem.func_190926_b()) continue;
                if ((giveItemStack2 = remoteInventory.insertItem(i, giveItemStack2, false)).func_190926_b()) {
                    return true;
                }
                itemStack = giveItemStack2.func_77946_l();
            }
        }
        if ((invContainers = InventoryHelper.findInvContainers(inv)).size() > 0) {
            for (IItemHandler container : invContainers) {
                for (int i = 0; i < container.getSlots(); ++i) {
                    ItemStack containerItem = container.getStackInSlot(i);
                    ItemStack giveItemStack3 = itemStack.func_77946_l();
                    if (containerItem.func_77973_b() != giveItemStack3.func_77973_b()) continue;
                    if ((giveItemStack3 = container.insertItem(i, giveItemStack3, false)).func_190926_b()) {
                        return true;
                    }
                    itemStack = giveItemStack3.func_77946_l();
                }
            }
        }
        giveItemStack = itemStack.func_77946_l();
        return inv.func_70441_a(giveItemStack);
    }

    public static boolean useItem(ItemStack itemStack, PlayerEntity player, int count, World world) {
        if (player.func_184812_l_()) {
            return true;
        }
        ItemStack tool = AbstractGadget.getGadget(player);
        IItemHandler remoteInventory = GadgetUtils.getRemoteInventory(tool, world);
        if (remoteInventory != null) {
            for (int i = 0; i < remoteInventory.getSlots(); ++i) {
                ItemStack containerItem = remoteInventory.getStackInSlot(i);
                if (containerItem.func_77973_b() != itemStack.func_77973_b() || containerItem.func_190916_E() < count) continue;
                remoteInventory.extractItem(i, count, false);
                return true;
            }
        }
        PlayerInventory inv = player.field_71071_by;
        List<Integer> slots = InventoryHelper.findItem(itemStack.func_77973_b(), inv);
        List<IItemHandler> invContainers = InventoryHelper.findInvContainers(inv);
        if (invContainers.size() > 0) {
            for (IItemHandler container : invContainers) {
                for (int i = 0; i < container.getSlots(); ++i) {
                    ItemStack containerItem = container.getStackInSlot(i);
                    if (containerItem.func_77973_b() != itemStack.func_77973_b() || containerItem.func_190916_E() < count) continue;
                    container.extractItem(i, count, false);
                    return true;
                }
            }
        }
        if (slots.size() == 0) {
            return false;
        }
        int slot = slots.get(0);
        ItemStack stackInSlot = inv.func_70301_a(slot);
        if (stackInSlot.func_190916_E() < count) {
            return false;
        }
        stackInSlot.func_190918_g(count);
        return true;
    }

    public static int countItem(ItemStack itemStack, PlayerEntity player, World world) {
        return InventoryHelper.countItem(itemStack, player, (ItemStack tool, ItemStack stack) -> {
            IItemHandler remoteInventory = GadgetUtils.getRemoteInventory(tool, world);
            return remoteInventory == null ? 0 : InventoryHelper.countInContainer(remoteInventory, stack.func_77973_b());
        });
    }

    public static int countItem(ItemStack itemStack, PlayerEntity player, IRemoteInventoryProvider remoteInventory) {
        if (player.func_184812_l_()) {
            return Integer.MAX_VALUE;
        }
        long count = remoteInventory.countItem(AbstractGadget.getGadget(player), itemStack);
        PlayerInventory inv = player.field_71071_by;
        List<Integer> slots = InventoryHelper.findItem(itemStack.func_77973_b(), inv);
        List<IItemHandler> invContainers = InventoryHelper.findInvContainers(inv);
        if (slots.size() == 0 && invContainers.size() == 0 && count == 0L) {
            return 0;
        }
        if (invContainers.size() > 0) {
            for (IItemHandler container : invContainers) {
                count += (long)InventoryHelper.countInContainer(container, itemStack.func_77973_b());
            }
        }
        Iterator<Object> iterator = slots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack stackInSlot = inv.func_70301_a(slot);
            count += (long)stackInSlot.func_190916_E();
        }
        return InventoryHelper.longToInt(count);
    }

    public static int countPaste(PlayerEntity player) {
        List<Integer> containerSlots;
        if (player.func_184812_l_()) {
            return Integer.MAX_VALUE;
        }
        long count = 0L;
        ConstructionPaste item = BGItems.constructionPaste;
        PlayerInventory inv = player.field_71071_by;
        List<Integer> slots = InventoryHelper.findItem(item, inv);
        if (slots.size() > 0) {
            for (int slot : slots) {
                ItemStack stackInSlot = inv.func_70301_a(slot);
                count += (long)stackInSlot.func_190916_E();
            }
        }
        if ((containerSlots = InventoryHelper.findItemClass(GenericPasteContainer.class, inv)).size() > 0) {
            for (int slot : containerSlots) {
                ItemStack stackInSlot = inv.func_70301_a(slot);
                if (!(stackInSlot.func_77973_b() instanceof GenericPasteContainer)) continue;
                count += (long)GenericPasteContainer.getPasteAmount(stackInSlot);
            }
        }
        return InventoryHelper.longToInt(count);
    }

    public static int longToInt(long count) {
        try {
            return Math.toIntExact(count);
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    public static ItemStack addPasteToContainer(PlayerEntity player, ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ConstructionPaste)) {
            return itemStack;
        }
        PlayerInventory inv = player.field_71071_by;
        List<Integer> slots = InventoryHelper.findItemClass(GenericPasteContainer.class, inv);
        if (slots.size() == 0) {
            return itemStack;
        }
        HashMap<Integer, Integer> slotMap = new HashMap<Integer, Integer>();
        for (int slot : slots) {
            slotMap.put(slot, GenericPasteContainer.getPasteAmount(inv.func_70301_a(slot)));
        }
        ArrayList list = new ArrayList(slotMap.entrySet());
        Comparator<Map.Entry> comparator = Comparator.comparing(entry -> (Integer)entry.getValue());
        comparator = comparator.reversed();
        list.sort(comparator);
        for (Map.Entry entry2 : list) {
            ItemStack containerStack = inv.func_70301_a(((Integer)entry2.getKey()).intValue());
            int maxAmount = ((GenericPasteContainer)containerStack.func_77973_b()).getMaxCapacity();
            int pasteInContainer = GenericPasteContainer.getPasteAmount(containerStack);
            int freeSpace = maxAmount - pasteInContainer;
            int stackSize = itemStack.func_190916_E();
            int remainingPaste = stackSize - freeSpace;
            if (remainingPaste < 0) {
                remainingPaste = 0;
            }
            int usedPaste = Math.abs(stackSize - remainingPaste);
            itemStack.func_190920_e(remainingPaste);
            GenericPasteContainer.setPasteAmount(containerStack, pasteInContainer + usedPaste);
        }
        return itemStack;
    }

    public static boolean usePaste(PlayerEntity player, int count) {
        List<Integer> containerSlots;
        if (player.func_184812_l_()) {
            return true;
        }
        PlayerInventory inv = player.field_71071_by;
        List<Integer> slots = InventoryHelper.findItem(BGItems.constructionPaste, inv);
        if (slots.size() > 0) {
            for (int slot : slots) {
                ItemStack pasteStack = inv.func_70301_a(slot);
                if (pasteStack.func_190916_E() < count) continue;
                pasteStack.func_190918_g(count);
                return true;
            }
        }
        if ((containerSlots = InventoryHelper.findItemClass(GenericPasteContainer.class, inv)).size() > 0) {
            for (int slot : containerSlots) {
                int pasteAmt;
                ItemStack containerStack = inv.func_70301_a(slot);
                if (!(containerStack.func_77973_b() instanceof GenericPasteContainer) || (pasteAmt = GenericPasteContainer.getPasteAmount(containerStack)) < count) continue;
                GenericPasteContainer.setPasteAmount(containerStack, pasteAmt - count);
                return true;
            }
        }
        return false;
    }

    private static List<IItemHandler> findInvContainers(PlayerInventory inv) {
        ArrayList<IItemHandler> containers = new ArrayList<IItemHandler>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(containers::add);
        }
        return containers;
    }

    public static int countInContainer(IItemHandler container, Item item) {
        int count = 0;
        for (int i = 0; i < container.getSlots(); ++i) {
            ItemStack tempItem = container.getStackInSlot(i);
            if (tempItem.func_77973_b() != item) continue;
            count += tempItem.func_190916_E();
        }
        return count;
    }

    private static List<Integer> findItem(Item item, PlayerInventory inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            slots.add(i);
        }
        return slots;
    }

    public static List<Integer> findItemClass(Class c, PlayerInventory inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !c.isInstance(stack.func_77973_b())) continue;
            slots.add(i);
        }
        return slots;
    }

    public static ItemStack getSilkTouchDrop(BlockState state) {
        return new ItemStack((IItemProvider)state.func_177230_c());
    }

    public static BlockData getSpecificStates(BlockState originalState, World world, PlayerEntity player, BlockPos pos, ItemStack tool) {
        BlockState placeState;
        try {
            placeState = originalState.func_177230_c().func_196258_a(new BlockItemUseContext(new ItemUseContext(player, Hand.MAIN_HAND, VectorHelper.getLookingAt(player, tool))));
        }
        catch (Exception var8) {
            placeState = originalState.func_177230_c().func_176223_P();
        }
        if (placeState != null) {
            for (IProperty prop : placeState.func_206869_a()) {
                if (tool.func_77973_b() instanceof GadgetCopyPaste) {
                    if (!SAFE_PROPERTIES_COPY_PASTE.contains(prop)) continue;
                    placeState = (BlockState)placeState.func_206870_a(prop, originalState.func_177229_b(prop));
                    continue;
                }
                if (!SAFE_PROPERTIES.contains(prop)) continue;
                placeState = (BlockState)placeState.func_206870_a(prop, originalState.func_177229_b(prop));
            }
            return new BlockData(placeState, TileSupport.createTileData((IBlockReader)world, pos));
        }
        return null;
    }

    private static NonNullList<ItemStack> playerInv(PlayerEntity player) {
        NonNullList wholeInv = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])((ItemStack[])player.field_71071_by.field_70462_a.toArray()));
        wholeInv.addAll((Collection)player.field_71071_by.field_184439_c);
        wholeInv.addAll((Collection)player.field_71071_by.field_70460_b);
        return wholeInv;
    }

    public static interface IRemoteInventoryProvider {
        public int countItem(ItemStack var1, ItemStack var2);
    }
}

