/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.blocks;

import com.direwolf20.buildinggadgets.api.building.Region;
import com.direwolf20.buildinggadgets.api.building.placement.IPositionPlacementSequence;
import com.direwolf20.buildinggadgets.common.util.exceptions.PaletteOverflowException;
import com.direwolf20.buildinggadgets.common.util.helpers.LambdaHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.direwolf20.buildinggadgets.common.util.tools.SetBackedPlacementSequence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

public class RegionSnapshot {
    private static final String DIMENSION = "dim";
    private static final String POSITIONS = "positions";
    private static final String BLOCK_FRAMES = "frames";
    private static final String BLOCK_PALETTES = "palettes";
    private static final String TILE_DATA = "block_snapshots";
    private static final String TILE_POS = "block_pos";
    private static final String TILE_NBT = "block_nbt";
    private IWorld world;
    private IPositionPlacementSequence positions;
    private ImmutableList<Optional<BlockState>> blockStates;
    private ImmutableList<Pair<BlockPos, CompoundNBT>> tileData;
    private CompoundNBT serializedForm;

    private static CompoundNBT serialize(CompoundNBT tag, RegionSnapshot snapshot) {
        tag.func_74778_a(DIMENSION, DimensionType.func_212678_a((DimensionType)snapshot.world.func_201675_m().func_186058_p()).toString());
        tag.func_218657_a(POSITIONS, (INBT)Objects.requireNonNull(NBTHelper.writeIterable(snapshot.positions, NBTUtil::func_186859_a)));
        tag.func_218657_a("area", (INBT)snapshot.positions.getBoundingBox().serialize());
        ListNBT palettes = new ListNBT();
        Object2IntOpenHashMap mapPalettes = new Object2IntOpenHashMap();
        mapPalettes.put(null, 0);
        HashSet<BlockState> recordedPalettes = new HashSet<BlockState>();
        IntArrayList frames = new IntArrayList();
        if (snapshot.blockStates.size() == 0) {
            return new CompoundNBT();
        }
        Optional lastStreak = (Optional)snapshot.blockStates.get(0);
        int streak = 0;
        for (Optional state : snapshot.blockStates) {
            BlockState nonnullState;
            if (state.isPresent() && !recordedPalettes.contains(nonnullState = (BlockState)state.get())) {
                recordedPalettes.add(nonnullState);
                mapPalettes.put((Object)nonnullState, mapPalettes.size());
                palettes.add((Object)NBTUtil.func_190009_a((BlockState)nonnullState));
            }
            if (state.equals(lastStreak) && streak < 256) {
                ++streak;
                continue;
            }
            frames.add((streak - 1 & 0xFF) << 24 | mapPalettes.getInt(lastStreak.orElse(null)) & 0xFFFFFF);
            streak = 1;
            lastStreak = state;
        }
        frames.add((streak - 1 & 0xFF) << 24 | mapPalettes.getInt(lastStreak.orElse(null)) & 0xFFFFFF);
        tag.func_74783_a(BLOCK_FRAMES, frames.toIntArray());
        tag.func_218657_a(BLOCK_PALETTES, (INBT)palettes);
        ListNBT tileData = new ListNBT();
        for (Pair data : snapshot.tileData) {
            CompoundNBT serializedData = new CompoundNBT();
            serializedData.func_218657_a(TILE_POS, (INBT)NBTUtil.func_186859_a((BlockPos)((BlockPos)data.getLeft())));
            serializedData.func_218657_a(TILE_NBT, (INBT)data.getRight());
            tileData.add((Object)serializedData);
        }
        tag.func_218657_a(TILE_DATA, (INBT)tileData);
        return tag;
    }

    public static RegionSnapshot deserialize(CompoundNBT tag) {
        int[] frames;
        ResourceLocation dimension = new ResourceLocation(tag.func_74779_i(DIMENSION));
        ServerWorld world = ServerLifecycleHooks.getCurrentServer().func_71218_a(Objects.requireNonNull(DimensionType.func_193417_a((ResourceLocation)dimension)));
        SetBackedPlacementSequence positions = new SetBackedPlacementSequence(NBTHelper.deserializeSet((ListNBT)tag.func_74781_a(POSITIONS), new HashSet(), nbt -> NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)nbt))), Region.deserializeFrom(tag.func_74775_l("area")));
        ArrayList palettes = new ArrayList();
        palettes.add(Optional.empty());
        ListNBT palettesNBT = tag.func_150295_c(BLOCK_PALETTES, 10);
        for (int i = 0; i < palettesNBT.size(); ++i) {
            palettes.add(Optional.of(NBTUtil.func_190008_d((CompoundNBT)palettesNBT.func_150305_b(i))));
        }
        assert (palettes.size() == palettesNBT.size() + 1);
        ImmutableList.Builder blockStates = ImmutableList.builder();
        for (int frame : frames = tag.func_74759_k(BLOCK_FRAMES)) {
            int stateID = frame & 0xFFFFFF;
            int streaks = (frame >>> 24) + 1;
            Optional state = (Optional)palettes.get(stateID);
            for (int j = 0; j < streaks; ++j) {
                blockStates.add((Object)state);
            }
        }
        ListNBT tileDataNBT = tag.func_150295_c(TILE_DATA, 10);
        ImmutableList.Builder tileData = ImmutableList.builder();
        for (int i = 0; i < tileDataNBT.size(); ++i) {
            CompoundNBT serializedData = tileDataNBT.func_150305_b(i);
            tileData.add((Object)Pair.of((Object)NBTUtil.func_186861_c((CompoundNBT)serializedData.func_74775_l(TILE_POS)), (Object)serializedData.func_74775_l(TILE_NBT)));
        }
        return new RegionSnapshot((IWorld)world, positions, (ImmutableList<Optional<BlockState>>)blockStates.build(), (ImmutableList<Pair<BlockPos, CompoundNBT>>)tileData.build());
    }

    public static Builder select(IWorld world, IPositionPlacementSequence positions) {
        return new Builder(world, positions);
    }

    public static RegionSnapshot take(IWorld world, IPositionPlacementSequence positions) throws PaletteOverflowException {
        return RegionSnapshot.select(world, positions).checkBlocks((pos, state) -> true).recordTiles(false).build();
    }

    private RegionSnapshot(IWorld world, IPositionPlacementSequence positions, ImmutableList<Optional<BlockState>> blockStates, ImmutableList<Pair<BlockPos, CompoundNBT>> tileData) {
        this.world = world;
        this.positions = positions;
        this.blockStates = blockStates;
        this.tileData = tileData;
    }

    public void restore() {
        int index = 0;
        for (BlockPos pos : this.positions) {
            ((Optional)this.blockStates.get(index)).ifPresent(state -> this.world.func_180501_a(pos, state, 3));
            ++index;
        }
        for (Pair data : this.tileData) {
            TileEntity tile = this.world.func_175625_s((BlockPos)data.getLeft());
            if (tile != null) {
                tile.func_145839_a((CompoundNBT)data.getRight());
                tile.func_70296_d();
                continue;
            }
            throw new IllegalStateException("Unable to find expected tile entity at " + data.getLeft() + " that can read " + data.getRight());
        }
    }

    public IPositionPlacementSequence getPositions() {
        return this.positions;
    }

    public ImmutableList<Optional<BlockState>> getBlockStates() {
        return this.blockStates;
    }

    public ImmutableList<Pair<BlockPos, CompoundNBT>> getTileData() {
        return this.tileData;
    }

    public CompoundNBT serialize() {
        return this.serializeTo(new CompoundNBT());
    }

    public CompoundNBT serializeTo(CompoundNBT tag) {
        if (this.serializedForm == null) {
            this.serializedForm = RegionSnapshot.serialize(tag, this);
        }
        return this.serializedForm;
    }

    public static final class Builder {
        private IWorld world;
        private IPositionPlacementSequence positions;
        private BiPredicate<BlockPos, BlockState> normalValidator;
        private TriPredicate<BlockPos, BlockState, TileEntity> tileValidator;
        private boolean built = false;

        private Builder(IWorld world, IPositionPlacementSequence positions) {
            this.world = world;
            this.positions = positions;
        }

        public Builder checkBlocks(BiPredicate<BlockPos, BlockState> normalValidator) {
            Preconditions.checkState((!this.built ? 1 : 0) != 0);
            this.normalValidator = LambdaHelper.and(this.normalValidator, normalValidator);
            return this;
        }

        public Builder exclude(BlockState ... statesToExclude) {
            ImmutableSet statesSet = ImmutableSet.copyOf((Object[])statesToExclude);
            return this.checkBlocks((pos, state) -> !statesSet.contains(state));
        }

        public Builder excludeAir() {
            return this.checkBlocks((pos, state) -> !state.isAir((IBlockReader)this.world, pos));
        }

        public Builder checkTiles(TriPredicate<BlockPos, BlockState, TileEntity> tileValidator) {
            Preconditions.checkState((!this.built ? 1 : 0) != 0);
            this.tileValidator = LambdaHelper.and(this.tileValidator, tileValidator);
            return this;
        }

        public Builder recordTiles(boolean flag) {
            Preconditions.checkState((!this.built ? 1 : 0) != 0);
            this.tileValidator = flag ? (pos, state, tile) -> true : null;
            return this;
        }

        public RegionSnapshot build() throws IllegalStateException, PaletteOverflowException {
            Preconditions.checkState((!this.built ? 1 : 0) != 0);
            ImmutableList.Builder blockStatesBuilder = ImmutableList.builder();
            ImmutableList.Builder tileDataBuilder = ImmutableList.builder();
            for (BlockPos pos : this.positions) {
                TileEntity tile = this.world.func_175625_s(pos);
                BlockState state = this.world.func_180495_p(pos);
                if (tile != null && this.tileValidator.test((Object)pos, (Object)state, (Object)tile)) {
                    tileDataBuilder.add((Object)Pair.of((Object)pos, (Object)tile.serializeNBT()));
                    blockStatesBuilder.add(Optional.of(state));
                    continue;
                }
                if (this.normalValidator.test(pos, state)) {
                    blockStatesBuilder.add(Optional.of(state));
                    continue;
                }
                blockStatesBuilder.add(Optional.empty());
            }
            ImmutableList blockStates = blockStatesBuilder.build();
            ImmutableSet uniqueBlocksStates = ImmutableSet.copyOf((Collection)blockStates);
            if (uniqueBlocksStates.size() >= 0x1000000) {
                throw new PaletteOverflowException(this.positions, uniqueBlocksStates.size());
            }
            this.built = true;
            return new RegionSnapshot(this.world, this.positions, blockStates, tileDataBuilder.build());
        }
    }
}

