/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry.block;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.registry.RegistryContainer;
import com.direwolf20.buildinggadgets.common.registry.block.BlockBuilder;
import com.direwolf20.buildinggadgets.common.registry.block.tile.TileEntityBuilder;
import com.direwolf20.buildinggadgets.common.registry.block.tile.TileEntityRegistryContainer;
import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockRegistryContainer
extends RegistryContainer<Block, BlockBuilder> {
    private final TileEntityRegistryContainer tileContainer;

    public BlockRegistryContainer(TileEntityRegistryContainer tileContainer) {
        this.tileContainer = tileContainer;
    }

    @Override
    public void add(BlockBuilder builder) {
        super.add(builder);
        if (builder.getTileEntityBuilder() != null) {
            this.tileContainer.add(builder.getTileEntityBuilder());
        } else if (builder.getTileEntityId() != null) {
            TileEntityBuilder<?> tileEntityBuilder = this.tileContainer.getBuilderWithId(builder.getTileEntityId());
            Preconditions.checkArgument((tileEntityBuilder != null ? 1 : 0) != 0, (Object)"Attempted to add Block with TileEntity without constructing a TileEntityType!");
            builder.withTileEntity(tileEntityBuilder);
        }
    }

    public void registerItemBlocks(RegistryEvent.Register<Item> event) {
        BuildingGadgets.LOG.debug("Registering {} ItemBlocks", (Object)"buildinggadgets");
        for (BlockBuilder builder : this.getBuilders()) {
            if (!builder.hasItem()) continue;
            event.getRegistry().register((IForgeRegistryEntry)builder.createItemFromBlock());
        }
        BuildingGadgets.LOG.debug("Finished Registering {} {} ItemBlock's", (Object)this.getBuilders().size(), (Object)"buildinggadgets");
    }
}

