/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryObjectBuilder<T extends IForgeRegistryEntry<T>, B> {
    private final ResourceLocation registryName;
    private Function<B, T> factory;
    private B builder;

    public RegistryObjectBuilder(String registryName) {
        this(new ResourceLocation(Objects.requireNonNull(registryName)));
    }

    public RegistryObjectBuilder(ResourceLocation registryName) {
        this.registryName = Objects.requireNonNull(registryName);
    }

    public RegistryObjectBuilder<T, B> factory(Function<B, T> factory) {
        this.factory = Objects.requireNonNull(factory);
        return this;
    }

    public RegistryObjectBuilder<T, B> builder(B builder) {
        this.builder = Objects.requireNonNull(builder);
        return this;
    }

    protected ResourceLocation getRegistryName() {
        return this.registryName;
    }

    protected T construct() {
        Preconditions.checkState((this.factory != null ? 1 : 0) != 0, (String)"Cannot construct %s without a Factory function!", (Object)this.getRegistryName());
        Preconditions.checkState((this.builder != null ? 1 : 0) != 0, (String)"Cannot construct %s without a Builder!", (Object)this.getRegistryName());
        return (T)((IForgeRegistryEntry)((IForgeRegistryEntry)this.factory.apply(this.builder)).setRegistryName(this.getRegistryName()));
    }

    protected B getBuilder() {
        return this.builder;
    }
}

