/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketRotateMirror {
    private Operation operation;

    public PacketRotateMirror() {
    }

    public PacketRotateMirror(@Nullable Operation operation) {
        this.operation = operation;
    }

    public static void encode(PacketRotateMirror msg, PacketBuffer buffer) {
        boolean hasOperation = msg.operation != null;
        buffer.writeBoolean(hasOperation);
        if (hasOperation) {
            buffer.writeInt(msg.operation.ordinal());
        }
    }

    public static PacketRotateMirror decode(PacketBuffer buffer) {
        return new PacketRotateMirror(buffer.readBoolean() ? Operation.values()[buffer.readInt()] : null);
    }

    public static class Handler {
        public static void handle(PacketRotateMirror msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Operation operation;
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                ItemStack stack = AbstractGadget.getGadget((PlayerEntity)player);
                Operation operation2 = msg.operation != null ? msg.operation : (operation = player.func_70093_af() ? Operation.MIRROR : Operation.ROTATE);
                if (stack.func_77973_b() instanceof GadgetBuilding || stack.func_77973_b() instanceof GadgetExchanger) {
                    GadgetUtils.rotateOrMirrorToolBlock(stack, player, operation);
                } else if (stack.func_77973_b() instanceof GadgetCopyPaste) {
                    GadgetCopyPaste.rotateOrMirrorBlocks(stack, (PlayerEntity)player, operation);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static enum Operation {
        ROTATE,
        MIRROR;

    }
}

