/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.modes.IAtopPlacingGadget;
import com.direwolf20.buildinggadgets.api.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BuildingRender;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBindTool;
import com.direwolf20.buildinggadgets.common.registry.objects.BGBlocks;
import com.direwolf20.buildinggadgets.common.registry.objects.BGItems;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.InventoryHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.SortingHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.LangUtil;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.tools.UndoState;
import com.direwolf20.buildinggadgets.common.util.tools.modes.BuildingMode;
import com.direwolf20.buildinggadgets.common.world.FakeBuilderWorld;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class GadgetBuilding
extends AbstractGadget
implements IAtopPlacingGadget {
    private static final FakeBuilderWorld fakeWorld = new FakeBuilderWorld();

    public GadgetBuilding(Item.Properties builder) {
        super(builder);
    }

    @Override
    public int getEnergyMax() {
        return (Integer)Config.GADGETS.GADGET_BUILDING.maxEnergy.get();
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return (Integer)Config.GADGETS.GADGET_BUILDING.energyCost.get();
    }

    @Override
    protected Supplier<BaseRenderer> createRenderFactory() {
        return BuildingRender::new;
    }

    @Override
    public boolean placeAtop(ItemStack stack) {
        return GadgetBuilding.shouldPlaceAtop(stack);
    }

    private static void setToolMode(ItemStack tool, BuildingMode mode) {
        CompoundNBT tagCompound = NBTHelper.getOrNewTag(tool);
        tagCompound.func_74778_a("mode", mode.getRegistryName());
    }

    public static BuildingMode getToolMode(ItemStack tool) {
        CompoundNBT tagCompound = NBTHelper.getOrNewTag(tool);
        return BuildingMode.byName(tagCompound.func_74779_i("mode"));
    }

    public static boolean shouldPlaceAtop(ItemStack stack) {
        return !NBTHelper.getOrNewTag(stack).func_74767_n("start_inside");
    }

    public static void togglePlaceAtop(PlayerEntity player, ItemStack stack) {
        NBTHelper.getOrNewTag(stack).func_74757_a("start_inside", GadgetBuilding.shouldPlaceAtop(stack));
        String prefix = "message.gadget.building.placement";
        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent(prefix, new Object[]{new TranslationTextComponent(prefix + (GadgetBuilding.shouldPlaceAtop(stack) ? ".atop" : ".inside"), new Object[0])}).func_150261_e()), true);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(TooltipTranslation.GADGET_BLOCK.componentTranslation(LangUtil.getFormattedBlockName(GadgetUtils.getToolBlock(stack).getState())).func_150255_a(Styles.DK_GREEN));
        BuildingMode mode = GadgetBuilding.getToolMode(stack);
        tooltip.add(TooltipTranslation.GADGET_MODE.componentTranslation(mode == BuildingMode.SURFACE && GadgetBuilding.getConnectedArea(stack) ? TooltipTranslation.GADGET_CONNECTED.format(new Object[]{mode}) : mode).func_150255_a(Styles.AQUA));
        if (GadgetBuilding.getToolMode(stack) != BuildingMode.TARGETED_AXIS_CHASING) {
            tooltip.add(TooltipTranslation.GADGET_RANGE.componentTranslation(GadgetUtils.getToolRange(stack)).func_150255_a(Styles.LT_PURPLE));
        }
        if (GadgetBuilding.getToolMode(stack) == BuildingMode.SURFACE) {
            tooltip.add(TooltipTranslation.GADGET_FUZZY.componentTranslation(String.valueOf(GadgetBuilding.getFuzzy(stack))).func_150255_a(Styles.GOLD));
        }
        GadgetBuilding.addInformationRayTraceFluid(tooltip, stack);
        tooltip.add(TooltipTranslation.GADGET_BUILDING_PLACE_ATOP.componentTranslation(String.valueOf(GadgetBuilding.shouldPlaceAtop(stack))).func_150255_a(Styles.YELLOW));
        this.addEnergyInformation(tooltip, stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                GadgetUtils.selectBlock(itemstack, player);
            } else if (player instanceof ServerPlayerEntity) {
                this.build((ServerPlayerEntity)player, itemstack);
            }
        } else if (!player.func_70093_af()) {
            BaseRenderer.updateInventoryCache();
        } else if (Screen.hasControlDown()) {
            System.out.println("CUnt");
            PacketHandler.sendToServer(new PacketBindTool());
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public void setMode(ItemStack heldItem, int modeInt) {
        BuildingMode mode = BuildingMode.values()[modeInt];
        GadgetBuilding.setToolMode(heldItem, mode);
    }

    public static void rangeChange(PlayerEntity player, ItemStack heldItem) {
        int changeAmount;
        int range = GadgetUtils.getToolRange(heldItem);
        int n = changeAmount = GadgetBuilding.getToolMode(heldItem) != BuildingMode.SURFACE || range % 2 == 0 ? 1 : 2;
        range = player.func_70093_af() ? (range == 1 ? (Integer)Config.GADGETS.maxRange.get() : range - changeAmount) : (range >= (Integer)Config.GADGETS.maxRange.get() ? 1 : range + changeAmount);
        GadgetUtils.setToolRange(heldItem, range);
        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + new TranslationTextComponent("message.gadget.toolrange", new Object[0]).func_150261_e() + ": " + range), true);
    }

    private boolean build(ServerPlayerEntity player, ItemStack stack) {
        World world = player.field_70170_p;
        List<BlockPos> coords = GadgetUtils.getAnchor(stack);
        if (coords.size() == 0) {
            BlockRayTraceResult lookingAt = VectorHelper.getLookingAt((PlayerEntity)player, stack);
            if (lookingAt == null || world.func_180495_p(VectorHelper.getLookingAt((PlayerEntity)player, stack).func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
                return false;
            }
            BlockPos startBlock = lookingAt.func_216350_a();
            Direction sideHit = lookingAt.func_216354_b();
            coords = BuildingMode.collectPlacementPos((IWorld)world, (PlayerEntity)player, startBlock, sideHit, stack, startBlock);
        } else {
            GadgetUtils.setAnchor(stack, new ArrayList<BlockPos>());
        }
        ArrayList<BlockPos> undoCoords = new ArrayList<BlockPos>();
        ItemStack heldItem = GadgetBuilding.getGadget((PlayerEntity)player);
        if (heldItem.func_190926_b()) {
            return false;
        }
        BlockData blockData = GadgetUtils.getToolBlock(heldItem);
        if (blockData.getState() != Blocks.field_150350_a.func_176223_P()) {
            fakeWorld.setWorldAndState(player.field_70170_p, blockData.getState(), coords);
            for (BlockPos coordinate : coords) {
                if (!this.placeBlock(world, player, coordinate, blockData)) continue;
                undoCoords.add(coordinate);
            }
            if (undoCoords.size() > 0) {
                UndoState undoState = new UndoState(player.field_71093_bK, undoCoords);
                GadgetUtils.pushUndoList(heldItem, undoState);
            }
        }
        SortingHelper.Blocks.byDistance(coords, (PlayerEntity)player);
        return true;
    }

    public static boolean undoBuild(PlayerEntity player) {
        ItemStack heldItem = GadgetBuilding.getGadget(player);
        if (heldItem.func_190926_b()) {
            return false;
        }
        UndoState undoState = GadgetUtils.popUndoList(heldItem);
        if (undoState == null) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget.nothingtoundo", new Object[0]).func_150261_e()), true);
            return false;
        }
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            List<BlockPos> undoCoords = undoState.coordinates;
            ArrayList<BlockPos> failedRemovals = new ArrayList<BlockPos>();
            ItemStack silkTool = heldItem.func_77946_l();
            silkTool.func_77966_a(Enchantments.field_185306_r, 1);
            boolean sameDim = player.field_71093_bK == undoState.dimension;
            for (BlockPos coord : undoCoords) {
                BlockData currentBlock = TileSupport.createBlockData((IBlockReader)world, coord);
                double distance = Math.sqrt(coord.func_177951_i((Vec3i)player.func_180425_c()));
                BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(world, coord, currentBlock.getState(), player);
                boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)e);
                if (distance < 64.0 && sameDim && currentBlock.getState() != BGBlocks.effectBlock.func_176223_P() && !cancelled) {
                    if (currentBlock.getState() == Blocks.field_150350_a.func_176223_P()) continue;
                    currentBlock.getState().func_177230_c().func_180657_a(world, player, coord, currentBlock.getState(), world.func_175625_s(coord), silkTool);
                    EffectBlock.spawnEffectBlock(world, coord, currentBlock, EffectBlock.Mode.REMOVE, false);
                    continue;
                }
                player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + new TranslationTextComponent("message.gadget.undofailed", new Object[0]).func_150261_e()), true);
                failedRemovals.add(coord);
            }
            if (failedRemovals.size() != 0) {
                UndoState failedState = new UndoState(player.field_71093_bK, failedRemovals);
                GadgetUtils.pushUndoList(heldItem, failedState);
            }
        }
        return true;
    }

    private boolean placeBlock(World world, ServerPlayerEntity player, BlockPos pos, BlockData setBlock) {
        if (!player.func_175142_cm()) {
            return false;
        }
        ItemStack heldItem = GadgetBuilding.getGadget((PlayerEntity)player);
        if (heldItem.func_190926_b()) {
            return false;
        }
        boolean useConstructionPaste = false;
        ItemStack itemStack = InventoryHelper.getSilkTouchDrop(setBlock.getState());
        if (itemStack.func_77973_b().equals(Items.field_190931_a)) {
            itemStack = setBlock.getState().func_177230_c().getPickBlock(setBlock.getState(), null, (IBlockReader)world, pos, (PlayerEntity)player);
        }
        NonNullList drops = NonNullList.func_191196_a();
        int neededItems = 0;
        for (ItemStack drop : drops) {
            if (!drop.func_77973_b().equals(itemStack.func_77973_b())) continue;
            ++neededItems;
        }
        if (neededItems == 0) {
            neededItems = 1;
        }
        if (!world.func_175660_a((PlayerEntity)player, pos)) {
            return false;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)pos);
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blockSnapshot, (Direction)Direction.UP)) {
            return false;
        }
        if (!setBlock.getState().hasTileEntity()) {
            ItemStack constructionPaste = new ItemStack((IItemProvider)BGItems.constructionPaste);
            if (InventoryHelper.countItem(itemStack, (PlayerEntity)player, world) < neededItems) {
                if (InventoryHelper.countPaste((PlayerEntity)player) < neededItems) {
                    return false;
                }
                itemStack = constructionPaste.func_77946_l();
                useConstructionPaste = true;
            }
        }
        if (!this.canUse(heldItem, (PlayerEntity)player)) {
            return false;
        }
        this.applyDamage(heldItem, player);
        boolean useItemSuccess = useConstructionPaste ? InventoryHelper.usePaste((PlayerEntity)player, 1) : InventoryHelper.useItem(itemStack, (PlayerEntity)player, neededItems, world);
        if (useItemSuccess) {
            EffectBlock.spawnEffectBlock(world, pos, setBlock, EffectBlock.Mode.PLACE, useConstructionPaste);
            return true;
        }
        return false;
    }

    public static ItemStack getGadget(PlayerEntity player) {
        ItemStack stack = AbstractGadget.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetBuilding)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }
}

