/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.config;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.config.PatternList;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber
public class Config {
    private static final String CATEGORY_GENERAL = "general";
    private static final String LANG_KEY_ROOT = "config.buildinggadgets";
    private static final String LANG_KEY_GENERAL = "config.buildinggadgets.general";
    private static final String LANG_KEY_CHARGING_STATION = "config.buildinggadgets.charging";
    private static final String LANG_KEY_BLACKLIST = "config.buildinggadgets.blacklist";
    private static final String LANG_KEY_GADGETS = "config.buildinggadgets.gadgets";
    private static final String LANG_KEY_PASTE_CONTAINERS = "config.buildinggadgets.pasteContainers";
    private static final String LANG_KEY_PASTE_CONTAINERS_CAPACITY = "config.buildinggadgets.pasteContainers.capacity";
    private static final String LANG_KEY_GADGET_BUILDING = "config.buildinggadgets.gadgets.gadgetBuilding";
    private static final String LANG_KEY_GADGET_EXCHANGER = "config.buildinggadgets.gadgets.gadgetExchanger";
    private static final String LANG_KEY_GADGET_DESTRUCTION = "config.buildinggadgets.gadgets.gadgetDestruction";
    private static final String LANG_KEY_GADGET_COPY_PASTE = "config.buildinggadgets.gadgets.gadgetCopyPaste";
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static final CategoryGeneral GENERAL = new CategoryGeneral();
    public static final CategoryChargingStation CHARGING_STATION = new CategoryChargingStation();
    public static final CategoryGadgets GADGETS = new CategoryGadgets();
    public static final CategoryPasteContainers PASTE_CONTAINERS = new CategoryPasteContainers();
    public static final CategoryBlacklist BLACKLIST = new CategoryBlacklist();
    public static final ForgeConfigSpec COMMON_CONFIG = COMMON_BUILDER.build();
    public static final ForgeConfigSpec SERVER_CONFIG = SERVER_BUILDER.build();
    public static final ForgeConfigSpec CLIENT_CONFIG = CLIENT_BUILDER.build();
    private static boolean serverCfgLoaded = false;

    private static void loadServerConfig() {
        Config.BLACKLIST.parseBlacklists();
        serverCfgLoaded = true;
    }

    public static void onLoad(ModConfig.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == SERVER_CONFIG) {
            Config.loadServerConfig();
        }
        BuildingGadgets.LOG.debug("Loaded {} config file {}", (Object)"buildinggadgets", (Object)configEvent.getConfig().getFileName());
    }

    public static void onFileChange(ModConfig.ConfigReloading configEvent) {
        BuildingGadgets.LOG.fatal(Logging.CORE, "{} config just got changed on the file system!", (Object)"buildinggadgets");
    }

    public static boolean isServerConfigLoaded() {
        return serverCfgLoaded;
    }

    public static final class CategoryBlacklist {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blockBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blockWhitelist;
        private PatternList parsedBlacklist = null;
        private PatternList parsedWhitelist = null;

        private CategoryBlacklist() {
            SERVER_BUILDER.comment("Configure your Blacklist-Settings here").push("Blacklist Settings");
            this.blockBlacklist = SERVER_BUILDER.comment(new String[]{"All Blocks added to this will be treated similar to TileEntities. Not at all.", "Notice that you can use Regular Expressions as defined by Java Patterns to express more complex name combinations.", "Use for example \"awfulmod:.*\" to blacklist all awfulmod Blocks."}).translation("config.buildinggadgets.blacklist.blockBlacklist").defineList("Blacklisted Blocks", (List)ImmutableList.of((Object)"minecraft:.*_door.*", (Object)PatternList.getName(Blocks.field_150332_K)), obj -> obj instanceof String);
            this.blockWhitelist = SERVER_BUILDER.comment("Allows you to define a whitelist, allowing Patterns to be defined in the same way as the blacklist.").translation("config.buildinggadgets.blacklist.blockWhitelist").defineList("Whitelisted Blocks", (List)ImmutableList.of((Object)".*"), obj -> obj instanceof String);
            SERVER_BUILDER.pop();
        }

        private PatternList parsePatternListSafe(ForgeConfigSpec.ConfigValue<List<? extends String>> value, List<String> def) {
            try {
                return PatternList.ofResourcePattern((Collection)value.get());
            }
            catch (PatternSyntaxException e) {
                BuildingGadgets.LOG.error("The config value {}={} contains non-valid Pattern-Syntax. Defaulting to {}.", (Object)value.getPath(), value.get(), def);
                return PatternList.ofResourcePattern(def);
            }
        }

        private void parseBlacklists() {
            this.parsedBlacklist = this.parsePatternListSafe(this.blockBlacklist, (List<String>)ImmutableList.of());
            this.parsedWhitelist = this.parsePatternListSafe(this.blockWhitelist, (List<String>)ImmutableList.of((Object)".*"));
        }

        public boolean isAllowedBlock(Block block) {
            String regName;
            if (this.parsedBlacklist == null || this.parsedWhitelist == null) {
                this.parseBlacklists();
            }
            return this.parsedWhitelist.contains(regName = Objects.requireNonNull(block.getRegistryName()).toString()) && !this.parsedBlacklist.contains(regName);
        }
    }

    public static final class CategoryPasteContainers {
        public final ForgeConfigSpec.IntValue capacityT1;
        public final ForgeConfigSpec.IntValue capacityT2;
        public final ForgeConfigSpec.IntValue capacityT3;

        private CategoryPasteContainers() {
            SERVER_BUILDER.comment("Configure the Paste Containers").push("Paste Containers");
            this.capacityT1 = CategoryPasteContainers.getMaxCapacity(1);
            this.capacityT2 = CategoryPasteContainers.getMaxCapacity(2);
            this.capacityT3 = CategoryPasteContainers.getMaxCapacity(3);
            SERVER_BUILDER.pop();
        }

        private static ForgeConfigSpec.IntValue getMaxCapacity(int tier) {
            return SERVER_BUILDER.comment(String.format("The maximum capacity of a tier %s (iron) Construction Paste Container", tier)).translation("config.buildinggadgets.pasteContainers.capacity.t" + tier).defineInRange(String.format("T%s Container Capacity", tier), (int)(512.0 * Math.pow(4.0, tier - 1)), 1, Integer.MAX_VALUE);
        }
    }

    public static final class CategoryGadgets {
        public final ForgeConfigSpec.IntValue maxRange;
        public final CategoryGadgetBuilding GADGET_BUILDING;
        public final CategoryGadgetExchanger GADGET_EXCHANGER;
        public final CategoryGadgetDestruction GADGET_DESTRUCTION;
        public final CategoryGadgetCopyPaste GADGET_COPY_PASTE;

        private CategoryGadgets() {
            SERVER_BUILDER.comment("Configure the Gadgets").push("Gadgets");
            COMMON_BUILDER.comment("Configure the Gadgets").push("Gadgets");
            this.maxRange = SERVER_BUILDER.comment("The max range of the Gadgets").translation("config.buildinggadgets.gadgets.maxRange").defineInRange("Maximum allowed Range", 15, 1, 32);
            this.GADGET_BUILDING = new CategoryGadgetBuilding();
            this.GADGET_EXCHANGER = new CategoryGadgetExchanger();
            this.GADGET_DESTRUCTION = new CategoryGadgetDestruction();
            this.GADGET_COPY_PASTE = new CategoryGadgetCopyPaste();
            COMMON_BUILDER.pop();
            SERVER_BUILDER.pop();
        }

        private static ForgeConfigSpec.IntValue getMaxEnergy(int defaultValue) {
            return SERVER_BUILDER.comment("The max energy of the Gadget").translation("config.buildinggadgets.gadgets.maxEnergy").defineInRange("Maximum Energy", defaultValue, 1, Integer.MAX_VALUE);
        }

        private static ForgeConfigSpec.IntValue getEnergyCost(int defaultValue) {
            return SERVER_BUILDER.comment("The Gadget's Energy cost per Operation").translation("config.buildinggadgets.gadgets.energyCost").defineInRange("Energy Cost", defaultValue, 0, Integer.MAX_VALUE);
        }

        public static final class CategoryGadgetCopyPaste {
            public final ForgeConfigSpec.IntValue maxEnergy;
            public final ForgeConfigSpec.IntValue energyCost;

            private CategoryGadgetCopyPaste() {
                SERVER_BUILDER.comment("Energy Cost & Durability of the Copy-Paste Gadget").push("Copy-Paste Gadget");
                this.maxEnergy = CategoryGadgets.getMaxEnergy(500000);
                this.energyCost = CategoryGadgets.getEnergyCost(50);
                SERVER_BUILDER.pop();
            }
        }

        public static final class CategoryGadgetDestruction {
            public final ForgeConfigSpec.IntValue maxEnergy;
            public final ForgeConfigSpec.IntValue energyCost;
            public final ForgeConfigSpec.DoubleValue nonFuzzyMultiplier;
            public final ForgeConfigSpec.BooleanValue nonFuzzyEnabled;

            private CategoryGadgetDestruction() {
                SERVER_BUILDER.comment("Energy Cost, Durability & Maximum Energy of the Destruction Gadget").push("Destruction Gadget");
                this.maxEnergy = CategoryGadgets.getMaxEnergy(1000000);
                this.energyCost = CategoryGadgets.getEnergyCost(200);
                this.nonFuzzyMultiplier = SERVER_BUILDER.comment("The cost in energy/durability will increase by this amount when not in fuzzy mode").translation("config.buildinggadgets.gadgets.gadgetDestruction.nonfuzzy.multiplier").defineInRange("Non-Fuzzy Mode Multiplier", 2.0, 0.0, Double.MAX_VALUE);
                this.nonFuzzyEnabled = SERVER_BUILDER.comment("If enabled, the Destruction Gadget can be taken out of fuzzy mode, allowing only instances of the block clicked to be removed (at a higher cost)").translation("config.buildinggadgets.gadgets.gadgetDestruction.nonfuzzy.enabled").define("Non-Fuzzy Mode Enabled", false);
                SERVER_BUILDER.pop();
            }
        }

        public static final class CategoryGadgetExchanger {
            public final ForgeConfigSpec.IntValue maxEnergy;
            public final ForgeConfigSpec.IntValue energyCost;

            private CategoryGadgetExchanger() {
                SERVER_BUILDER.comment("Energy Cost & Durability of the Exchanging Gadget").push("Exchanging Gadget");
                this.maxEnergy = CategoryGadgets.getMaxEnergy(500000);
                this.energyCost = CategoryGadgets.getEnergyCost(100);
                SERVER_BUILDER.pop();
            }
        }

        public static final class CategoryGadgetBuilding {
            public final ForgeConfigSpec.IntValue maxEnergy;
            public final ForgeConfigSpec.IntValue energyCost;

            private CategoryGadgetBuilding() {
                SERVER_BUILDER.comment("Energy Cost & Durability of the Building Gadget").push("Building Gadget");
                this.maxEnergy = CategoryGadgets.getMaxEnergy(500000);
                this.energyCost = CategoryGadgets.getEnergyCost(50);
                SERVER_BUILDER.pop();
            }
        }
    }

    public static final class CategoryChargingStation {
        public final ForgeConfigSpec.IntValue capacity;
        public final ForgeConfigSpec.DoubleValue fuelUsage;
        public final ForgeConfigSpec.IntValue energyPerTick;
        public final ForgeConfigSpec.IntValue chargePerTick;
        public final ForgeConfigSpec.IntValue maxRecieve;
        public final ForgeConfigSpec.IntValue maxExtract;
        public final ForgeConfigSpec.BooleanValue renderSphere;

        private CategoryChargingStation() {
            SERVER_BUILDER.comment("Charging station settings").push("charging_station");
            COMMON_BUILDER.comment("Charging station settings").push("charging_station");
            CLIENT_BUILDER.comment("Charging station settings").push("charging_station");
            this.capacity = SERVER_BUILDER.comment("Define the maximum energy stored in the Charging Station.").translation("config.buildinggadgets.charging.capacity").defineInRange("Energy capacity", 1000000, 1, Integer.MAX_VALUE);
            this.fuelUsage = SERVER_BUILDER.comment("Define the speed factor, by which the fuel is going to be consumed.").translation("config.buildinggadgets.charging.consume").defineInRange("Fuel Usage", 50.0, 1.0E-8, Double.MAX_VALUE);
            this.energyPerTick = SERVER_BUILDER.comment("Define the amount of energy produced per fuel tick.").translation("config.buildinggadgets.charging.fePerTick").defineInRange("Energy Production", 750, 0, Integer.MAX_VALUE);
            this.chargePerTick = SERVER_BUILDER.comment("Define how much the charging station attempts to charge per tick").translation("config.buildinggadgets.charging.chargePerTick").defineInRange("Charge Energy", 2500, 0, Integer.MAX_VALUE);
            this.maxRecieve = SERVER_BUILDER.comment("Define how much Energy can be accepted by the Charging Station per tick. Note that burning fuel counts towards this cap.").translation("config.buildinggadgets.charging.maxRecieve").defineInRange("Max Energy Recieved", 750, 0, Integer.MAX_VALUE);
            this.maxExtract = SERVER_BUILDER.comment("Define how much Energy can at most be extracted from the Charging Station per tick. Charging Items does notcount towards this cap!").translation("config.buildinggadgets.charging.maxExtract").defineInRange("Max Energy Extracted", 0, 0, Integer.MAX_VALUE);
            this.renderSphere = CLIENT_BUILDER.comment("Whether or not to render the Charging Sphere. Disabling rendering of the Charging Sphere will increase renderingPerformance, as it is the main throttle on the Charging Station render. Note that we are already doing what we can to make it as fast as possible but a colour changing Sphere just needs to update relativingly often...").translation("config.buildinggadgets.charging.renderSphere").define("Render Sphere", true);
            CLIENT_BUILDER.pop();
            COMMON_BUILDER.pop();
            SERVER_BUILDER.pop();
        }
    }

    public static final class CategoryGeneral {
        public final ForgeConfigSpec.DoubleValue rayTraceRange;
        public final ForgeConfigSpec.BooleanValue absoluteCoordDefault;
        public final ForgeConfigSpec.BooleanValue allowOverwriteBlocks;

        private CategoryGeneral() {
            SERVER_BUILDER.comment("General mod settings").push(Config.CATEGORY_GENERAL);
            COMMON_BUILDER.comment("General mod settings").push(Config.CATEGORY_GENERAL);
            CLIENT_BUILDER.comment("General mod settings").push(Config.CATEGORY_GENERAL);
            this.rayTraceRange = SERVER_BUILDER.comment("Defines how far away you can build").translation("config.buildinggadgets.general.rayTraceRange").defineInRange("MaxBuildDistance", 32.0, 1.0, 48.0);
            this.absoluteCoordDefault = CLIENT_BUILDER.comment(new String[]{"Determines if the Copy/Paste GUI's coordinate mode starts in 'Absolute' mode by default.", "Set to true for Absolute, set to False for Relative."}).translation("config.buildinggadgets.general.absoluteCoordDefault").define("Default to absolute Coord-Mode", false);
            this.allowOverwriteBlocks = SERVER_BUILDER.comment(new String[]{"Whether the Building / CopyPaste Gadget can overwrite blocks like water, lava, grass, etc (like a player can).", "False will only allow it to overwrite air blocks."}).translation("config.buildinggadgets.general.allowOverwriteBlocks").define("Allow non-Air-Block-Overwrite", true);
            CLIENT_BUILDER.pop();
            COMMON_BUILDER.pop();
            SERVER_BUILDER.pop();
        }
    }
}

