/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.commands;

import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBlockMap;
import com.direwolf20.buildinggadgets.common.world.WorldSave;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class BlockMapCommand {
    public static LiteralArgumentBuilder<CommandSource> registerDelete() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"DeleteBlockMaps").requires(commandSource -> commandSource.func_197034_c(4))).then((ArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197086_a()))).executes(context -> BlockMapCommand.execute((CommandContext<CommandSource>)context, EntityArgument.func_197088_a((CommandContext)context, (String)"targets"), true));
    }

    public static LiteralArgumentBuilder<CommandSource> registerList() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"FindBlockMaps").requires(commandSource -> commandSource.func_197034_c(4))).then((ArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197086_a()))).executes(context -> BlockMapCommand.execute((CommandContext<CommandSource>)context, EntityArgument.func_197088_a((CommandContext)context, (String)"targets"), false));
    }

    private static int execute(CommandContext<CommandSource> ctx, Entity entity, boolean removeData) throws CommandSyntaxException {
        ServerPlayerEntity sender = ((CommandSource)ctx.getSource()).func_197035_h();
        if (!(entity instanceof PlayerEntity)) {
            sender.func_145747_a((ITextComponent)new StringTextComponent("Entity not valid"));
            return 0;
        }
        WorldSave worldSave = WorldSave.getWorldSave(sender.func_130014_f_());
        Map<String, CompoundNBT> tagMap = worldSave.getTagMap();
        HashMap<String, CompoundNBT> newMap = new HashMap<String, CompoundNBT>(tagMap);
        int counter = 0;
        for (Map.Entry<String, CompoundNBT> entry : tagMap.entrySet()) {
            CompoundNBT tagCompound = entry.getValue();
            if (!tagCompound.func_74779_i("owner").equals(entity.func_200200_C_().getString())) continue;
            sender.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Deleted stored map for " + tagCompound.func_74779_i("owner") + " with UUID:" + tagCompound.func_74779_i("uuid")));
            ++counter;
            if (!removeData) continue;
            newMap.remove(entry.getKey());
        }
        if (removeData && counter > 0) {
            worldSave.setTagMap(newMap);
            worldSave.markForSaving();
            if (entity.func_200200_C_().equals(sender.func_200200_C_())) {
                PacketHandler.sendTo(new PacketBlockMap(new CompoundNBT()), sender);
            }
        }
        sender.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "Deleted " + counter + " blockmaps in world data."));
        return 1;
    }
}

