/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.template.transaction;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.PlacementTarget;
import com.direwolf20.buildinggadgets.api.serialisation.TemplateHeader;
import com.direwolf20.buildinggadgets.api.template.ITemplate;
import com.direwolf20.buildinggadgets.api.template.transaction.AbsSingleRunTransactionOperator;
import com.direwolf20.buildinggadgets.api.template.transaction.ITransactionExecutionContext;
import com.direwolf20.buildinggadgets.api.template.transaction.ITransactionOperator;
import com.direwolf20.buildinggadgets.api.template.transaction.ReplaceDelegateOperator;
import com.direwolf20.buildinggadgets.api.template.transaction.RotateOperator;
import com.direwolf20.buildinggadgets.api.util.CommonUtils;
import com.google.common.collect.ImmutableMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public final class TemplateTransactions {
    private TemplateTransactions() {
    }

    public static ITransactionOperator copyOperatorUnsafe(Map<BlockPos, BlockData> map) {
        return new CopyOperator(Objects.requireNonNull(map, "Cannot create a Copy Operator from a null map!"));
    }

    public static ITransactionOperator copyOperator(Map<BlockPos, BlockData> map) {
        return new CopyOperator((Map)ImmutableMap.copyOf(Objects.requireNonNull(map, "Cannot create a Copy Operator from a null map!")));
    }

    public static ITransactionOperator copyOperator(Iterable<PlacementTarget> iterable) {
        return new CopyOperator((Map)CommonUtils.targetsToMap(Objects.requireNonNull(iterable, "Cannot create a Copy Operator from a null map!")));
    }

    public static ITransactionOperator replaceOperatorUnsafe(Map<BlockPos, BlockData> map) {
        return new ReplaceOperator(Objects.requireNonNull(map, "Cannot construct a Replace Operator from a null map!"));
    }

    public static ITransactionOperator replaceOperator(Map<BlockPos, BlockData> map) {
        return new ReplaceOperator((Map)ImmutableMap.copyOf(Objects.requireNonNull(map, "Cannot construct a Replace Operator from a null map!")));
    }

    public static ITransactionOperator replaceOperator(Iterable<PlacementTarget> targets) {
        return new ReplaceOperator((Map)CommonUtils.targetsToMap(Objects.requireNonNull(targets, "Cannot construct a Replace Operator from a null Iterable!")));
    }

    public static ITransactionOperator replaceDataOperatorUnsafe(Map<BlockData, BlockData> map) {
        return new ReplaceDataOperator(Objects.requireNonNull(map, "Cannot construct a ReplaceOperator from a null map!"));
    }

    public static ITransactionOperator replaceDataOperator(Map<BlockData, BlockData> map) {
        return new ReplaceDataOperator(map instanceof ImmutableMap ? map : new HashMap(Objects.requireNonNull(map, "Cannot construct a ReplaceOperator from a null map!")));
    }

    public static ITransactionOperator rotateOperator(Rotation rotation) {
        return new RotateOperator(Objects.requireNonNull(rotation, "Cannot rotate without an Rotation to apply!"));
    }

    public static ITransactionOperator rotateOperator(Direction.Axis axis, Rotation rotation) {
        return new RotateOperator(Objects.requireNonNull(axis, "Cannot rotate without an axis to rotate around!"), Objects.requireNonNull(rotation, "Cannot rotate without an Rotation to apply!"));
    }

    public static ITransactionOperator mirrorOperator(Direction.Axis axis) {
        return new MirrorOperator(axis);
    }

    public static ITransactionOperator modifyHeaderAuthorOperator(Function<String, String> author) {
        return TemplateTransactions.modifyHeaderOperator(Function.identity(), author);
    }

    public static ITransactionOperator modifyHeaderNameOperator(Function<String, String> name) {
        return TemplateTransactions.modifyHeaderOperator(name, Function.identity());
    }

    public static ITransactionOperator modifyHeaderOperator(Function<String, String> name, Function<String, String> author) {
        return new HeaderOperator(Objects.requireNonNull(name, "Cannot construct Header modification with null name Function!"), Objects.requireNonNull(author, "Cannot construct Header modification with null author Function!"));
    }

    public static ITransactionOperator headerNameOperator(@Nullable String name) {
        return TemplateTransactions.modifyHeaderNameOperator(CommonUtils.inputIfNonNullFunction(name));
    }

    public static ITransactionOperator headerAuthorOperator(@Nullable String author) {
        return TemplateTransactions.modifyHeaderAuthorOperator(CommonUtils.inputIfNonNullFunction(author));
    }

    public static ITransactionOperator headerOperator(@Nullable String name, @Nullable String author) {
        return TemplateTransactions.modifyHeaderOperator(CommonUtils.inputIfNonNullFunction(name), CommonUtils.inputIfNonNullFunction(author));
    }

    public static ITransactionOperator shiftingOperator(ITransactionOperator other, int passesToShift) {
        return new ShiftingOperator(other, passesToShift);
    }

    public static ReplaceDelegateOperator replaceDelegateOperator(ITemplate newDelegate) {
        return new ReplaceDelegateOperator(Objects.requireNonNull(newDelegate, "Cannot construct a replace Delegate Operator without a new Delegate!"));
    }

    private static final class ShiftingOperator
    implements ITransactionOperator {
        private final ITransactionOperator other;
        private int toShiftCounter;
        private ITransactionOperator.TransactionOperation lastOperation;

        private ShiftingOperator(ITransactionOperator other, int toShiftAmount) {
            this.other = other;
            this.toShiftCounter = toShiftAmount + 1;
            this.lastOperation = null;
        }

        @Override
        @Nullable
        public BlockPos createPos(ITransactionExecutionContext context) {
            this.setLastOperation(ITransactionOperator.TransactionOperation.CREATE_DATA);
            if (this.lastOperation == ITransactionOperator.TransactionOperation.CREATE_DATA) {
                --this.toShiftCounter;
            }
            if (this.toShiftCounter <= 0) {
                return this.other.createPos(context);
            }
            return null;
        }

        @Override
        @Nullable
        public BlockData createDataForPos(ITransactionExecutionContext context, BlockPos pos) {
            if (this.toShiftCounter <= 0) {
                return this.other.createDataForPos(context, pos);
            }
            return null;
        }

        @Override
        public TemplateHeader transformHeader(ITransactionExecutionContext context, TemplateHeader header) {
            this.setLastOperation(ITransactionOperator.TransactionOperation.TRANSFORM_HEADER);
            if (this.lastOperation == ITransactionOperator.TransactionOperation.TRANSFORM_HEADER) {
                --this.toShiftCounter;
            }
            if (this.toShiftCounter <= 0) {
                return this.other.transformHeader(context, header);
            }
            return header;
        }

        @Override
        @Nullable
        public BlockData transformData(ITransactionExecutionContext context, BlockData data) {
            this.setLastOperation(ITransactionOperator.TransactionOperation.TRANSFORM_DATA);
            if (this.lastOperation == ITransactionOperator.TransactionOperation.TRANSFORM_DATA) {
                --this.toShiftCounter;
            }
            if (this.toShiftCounter <= 0) {
                return this.other.transformData(context, data);
            }
            return data;
        }

        @Override
        @Nullable
        public BlockPos transformPos(ITransactionExecutionContext context, BlockPos pos, BlockData data) {
            this.setLastOperation(ITransactionOperator.TransactionOperation.TRANSFORM_POSITION);
            if (this.lastOperation == ITransactionOperator.TransactionOperation.TRANSFORM_POSITION) {
                --this.toShiftCounter;
            }
            if (this.toShiftCounter <= 0) {
                return this.other.transformPos(context, pos, data);
            }
            return pos;
        }

        @Override
        @Nullable
        public PlacementTarget transformTarget(ITransactionExecutionContext context, PlacementTarget target) {
            this.setLastOperation(ITransactionOperator.TransactionOperation.TRANSFORM_TARGET);
            if (this.lastOperation == ITransactionOperator.TransactionOperation.TRANSFORM_TARGET) {
                --this.toShiftCounter;
            }
            if (this.toShiftCounter <= 0) {
                return this.other.transformTarget(context, target);
            }
            return target;
        }

        @Override
        public Set<ITransactionOperator.TransactionOperation> remainingOperations() {
            return this.other.remainingOperations();
        }

        private void setLastOperation(ITransactionOperator.TransactionOperation operation) {
            if (this.lastOperation == null) {
                this.lastOperation = operation;
            }
        }
    }

    private static final class HeaderOperator
    extends AbsSingleRunTransactionOperator {
        private final Function<String, String> newName;
        private final Function<String, String> newAuthor;

        private HeaderOperator(Function<String, String> newName, Function<String, String> newAuthor) {
            super(EnumSet.of(ITransactionOperator.TransactionOperation.TRANSFORM_HEADER));
            this.newName = newName;
            this.newAuthor = newAuthor;
        }

        @Override
        public TemplateHeader transformHeader(ITransactionExecutionContext context, TemplateHeader header) {
            header = TemplateHeader.builderOf(header).name(this.newName.apply(header.getName())).author(this.newAuthor.apply(header.getAuthor())).build();
            return super.transformHeader(context, header);
        }
    }

    private static final class MirrorOperator
    extends AbsSingleRunTransactionOperator {
        private int xFac = 1;
        private int zFac = 1;
        private Mirror mirror;

        private MirrorOperator(Direction.Axis axis) {
            super(axis != Direction.Axis.Y ? EnumSet.of(ITransactionOperator.TransactionOperation.TRANSFORM_TARGET) : EnumSet.noneOf(ITransactionOperator.TransactionOperation.class));
            switch (axis) {
                case X: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.zFac = -1;
                    break;
                }
                case Z: {
                    this.mirror = Mirror.FRONT_BACK;
                    this.xFac = -1;
                    break;
                }
                default: {
                    this.mirror = Mirror.NONE;
                }
            }
        }

        @Override
        @Nullable
        public PlacementTarget transformTarget(ITransactionExecutionContext context, PlacementTarget target) {
            int x = target.getPos().func_177958_n() * this.xFac;
            int y = target.getPos().func_177952_p() * this.zFac;
            return super.transformTarget(context, new PlacementTarget(new BlockPos(x, target.getPos().func_177956_o(), y), target.getData().mirror(this.mirror)));
        }
    }

    private static final class ReplaceDataOperator
    extends AbsSingleRunTransactionOperator {
        private final Map<BlockData, BlockData> dataMap;

        private ReplaceDataOperator(Map<BlockData, BlockData> dataMap) {
            super(EnumSet.of(ITransactionOperator.TransactionOperation.TRANSFORM_DATA));
            this.dataMap = dataMap;
        }

        @Override
        @Nullable
        public BlockData transformData(ITransactionExecutionContext context, BlockData data) {
            return super.transformData(context, this.dataMap.getOrDefault(data, data));
        }
    }

    private static final class ReplaceOperator
    extends AbsSingleRunTransactionOperator {
        private final CopyOperator copyOperator;

        private ReplaceOperator(Map<BlockPos, BlockData> dataMap) {
            super(EnumSet.of(ITransactionOperator.TransactionOperation.CREATE_DATA, ITransactionOperator.TransactionOperation.TRANSFORM_TARGET));
            this.copyOperator = new CopyOperator(dataMap);
        }

        @Override
        @Nullable
        public BlockPos createPos(ITransactionExecutionContext context) {
            super.createPos(context);
            return this.copyOperator.createPos(context);
        }

        @Override
        @Nullable
        public BlockData createDataForPos(ITransactionExecutionContext context, BlockPos pos) {
            super.createDataForPos(context, pos);
            return this.copyOperator.createDataForPos(context, pos);
        }

        @Override
        @Nullable
        public PlacementTarget transformTarget(ITransactionExecutionContext context, PlacementTarget target) {
            super.transformTarget(context, target);
            if (this.copyOperator.getDataMap().containsKey(target.getPos())) {
                return target;
            }
            return null;
        }
    }

    private static final class CopyOperator
    extends AbsSingleRunTransactionOperator {
        private Iterator<BlockPos> positions;
        private final Map<BlockPos, BlockData> dataMap;

        private CopyOperator(Map<BlockPos, BlockData> dataMap) {
            super(EnumSet.of(ITransactionOperator.TransactionOperation.CREATE_DATA));
            this.dataMap = dataMap;
            this.positions = dataMap.keySet().iterator();
        }

        @Override
        @Nullable
        public BlockPos createPos(ITransactionExecutionContext context) {
            super.createPos(context);
            if (this.positions != null && this.positions.hasNext()) {
                return this.positions.next();
            }
            this.positions = null;
            return null;
        }

        @Override
        @Nullable
        public BlockData createDataForPos(ITransactionExecutionContext context, BlockPos pos) {
            super.createDataForPos(context, pos);
            return this.getDataMap().get(pos);
        }

        private Map<BlockPos, BlockData> getDataMap() {
            return this.dataMap;
        }
    }
}

