/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.template.transaction;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.PlacementTarget;
import com.direwolf20.buildinggadgets.api.serialisation.TemplateHeader;
import com.direwolf20.buildinggadgets.api.template.transaction.ITransactionExecutionContext;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;

public interface ITransactionOperator {
    @Nullable
    default public BlockPos createPos(ITransactionExecutionContext context) {
        return null;
    }

    @Nullable
    default public BlockData createDataForPos(ITransactionExecutionContext context, BlockPos pos) {
        throw new UnsupportedOperationException("Default implementation does not support creating BlockData!");
    }

    default public TemplateHeader transformHeader(ITransactionExecutionContext context, TemplateHeader header) {
        return header;
    }

    @Nullable
    default public BlockData transformData(ITransactionExecutionContext context, BlockData data) {
        return data;
    }

    @Nullable
    default public BlockPos transformPos(ITransactionExecutionContext context, BlockPos pos, BlockData data) {
        return pos;
    }

    @Nullable
    default public PlacementTarget transformTarget(ITransactionExecutionContext context, PlacementTarget target) {
        return target;
    }

    default public Set<TransactionOperation> remainingOperations() {
        return ImmutableSet.of();
    }

    public static enum TransactionOperation {
        CREATE_DATA(3),
        TRANSFORM_DATA(2),
        TRANSFORM_POSITION(1),
        TRANSFORM_TARGET(4),
        TRANSFORM_HEADER(0);

        private final byte id;

        private TransactionOperation(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }
    }
}

