/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.materials;

import com.direwolf20.buildinggadgets.api.util.RegistryUtils;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public final class UniqueItem {
    private final Item item;
    @Nullable
    private final CompoundNBT tagCompound;
    private final int hash;

    public static UniqueItem deserialize(CompoundNBT res) {
        Preconditions.checkArgument((boolean)res.func_74764_b("id"), (Object)"Cannot construct a UniqueItem without an Item!");
        CompoundNBT nbt = res.func_74775_l("data");
        Item item = res.func_150297_b("id", 3) ? (Item)RegistryUtils.getById(ForgeRegistries.ITEMS, res.func_74762_e("id")) : (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(res.func_74779_i("id")));
        return new UniqueItem(item, nbt.isEmpty() ? null : nbt);
    }

    public UniqueItem(Item item, @Nullable CompoundNBT tagCompound) {
        this.item = Objects.requireNonNull(item, "Cannot construct a UniqueItem for a null Item!");
        this.tagCompound = tagCompound;
        int hash = tagCompound != null ? tagCompound.hashCode() : 0;
        this.hash = Objects.requireNonNull(item.getRegistryName()).hashCode() + 31 * hash;
    }

    public Item getItem() {
        return this.item;
    }

    public ResourceLocation getRegistryName() {
        assert (this.item.getRegistryName() != null);
        return this.item.getRegistryName();
    }

    @Nullable
    public CompoundNBT getTag() {
        return this.tagCompound != null ? this.tagCompound.func_74737_b() : null;
    }

    public CompoundNBT serialize(boolean persisted) {
        CompoundNBT res = new CompoundNBT();
        if (this.tagCompound != null) {
            res.func_218657_a("data", (INBT)this.tagCompound);
        }
        if (persisted) {
            res.func_74778_a("id", this.item.getRegistryName().toString());
        } else {
            res.func_74768_a("id", RegistryUtils.getId(ForgeRegistries.ITEMS, this.item));
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UniqueItem)) {
            return false;
        }
        UniqueItem that = (UniqueItem)o;
        if (!this.getRegistryName().equals((Object)that.getRegistryName())) {
            return false;
        }
        return Objects.equals(this.tagCompound, that.tagCompound);
    }

    public int hashCode() {
        return this.hash;
    }
}

