/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import cpw.mods.inventorysorter.Config;
import cpw.mods.inventorysorter.InventorySorterCommand;
import cpw.mods.inventorysorter.KeyHandler;
import cpw.mods.inventorysorter.Network;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="inventorysorter")
public class InventorySorter {
    public static InventorySorter INSTANCE;
    static final Logger LOGGER;
    ResourceLocation lastContainerType;
    boolean debugLog;
    final Set<String> slotblacklist = new HashSet<String>();
    final Set<ResourceLocation> containerblacklist = new HashSet<ResourceLocation>();

    public InventorySorter() {
        INSTANCE = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::preinit);
        bus.addListener(this::clientSetup);
        bus.addListener(this::handleimc);
        bus.addListener(this::onConfigLoad);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SPEC);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
    }

    void clientSetup(FMLClientSetupEvent evt) {
        KeyHandler.init();
    }

    public void handleimc(InterModProcessEvent evt) {
        Stream imc = InterModComms.getMessages((String)"inventorysorter");
        imc.forEach(this::handleimcmessage);
    }

    private void handleimcmessage(InterModComms.IMCMessage msg) {
        ResourceLocation slotContainerTarget;
        String slotBlacklistTarget;
        if ("slotblacklist".equals(msg.getMethod()) && this.slotblacklist.add(slotBlacklistTarget = (String)msg.getMessageSupplier().get())) {
            this.debugLog("SlotBlacklist added {}", () -> new String[]{slotBlacklistTarget});
        }
        if ("containerblacklist".equals(msg.getMethod()) && this.containerblacklist.add(slotContainerTarget = (ResourceLocation)msg.getMessageSupplier().get())) {
            this.debugLog("ContainerBlacklist added {}", () -> new String[]{slotContainerTarget.toString()});
        }
        this.updateConfig();
    }

    private void updateConfig() {
        Config.CONFIG.containerBlacklist.set(this.containerblacklist.stream().map(Objects::toString).collect(Collectors.toList()));
        Config.CONFIG.slotBlacklist.set(new ArrayList<String>(this.slotblacklist));
    }

    void preinit(FMLCommonSetupEvent evt) {
        Network.init();
    }

    public void onServerStarting(FMLServerStartingEvent evt) {
        InventorySorterCommand.register((CommandDispatcher<CommandSource>)evt.getCommandDispatcher());
    }

    void onConfigLoad(ModConfig.ModConfigEvent configEvent) {
        this.slotblacklist.clear();
        this.slotblacklist.addAll((Collection)Config.CONFIG.slotBlacklist.get());
        this.containerblacklist.clear();
        this.containerblacklist.addAll(((List)Config.CONFIG.containerBlacklist.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet()));
    }

    boolean wheelModConflicts() {
        return ModList.get().isLoaded("mousetweaks");
    }

    boolean sortingModConflicts() {
        return false;
    }

    public final void debugLog(String message, Supplier<String[]> args) {
        if (this.debugLog) {
            LOGGER.error(message, (Object[])args.get());
        }
    }

    private static StringTextComponent greenText(String string) {
        StringTextComponent tcs = new StringTextComponent(string);
        tcs.func_150256_b().func_150238_a(TextFormatting.GREEN);
        return tcs;
    }

    public static int blackListAdd(CommandContext<CommandSource> context) {
        ResourceLocation containerType = InventorySorterCommand.Arguments.CONTAINER.get(context);
        if (ForgeRegistries.CONTAINERS.containsKey(containerType)) {
            InventorySorter.INSTANCE.containerblacklist.add(containerType);
            INSTANCE.updateConfig();
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("inventorysorter.commands.inventorysorter.bladd.message", new Object[]{containerType}), true);
            return 1;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("inventorysorter.commands.inventorysorter.badtype", new Object[]{containerType}), true);
        return 0;
    }

    public static int blackListRemove(CommandContext<CommandSource> context) {
        ResourceLocation containerType = InventorySorterCommand.Arguments.BLACKLISTED.get(context);
        if (ForgeRegistries.CONTAINERS.containsKey(containerType) && InventorySorter.INSTANCE.containerblacklist.remove(containerType)) {
            INSTANCE.updateConfig();
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("inventorysorter.commands.inventorysorter.blremove.message", new Object[]{containerType}), true);
            return 1;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("inventorysorter.commands.inventorysorter.badtype", new Object[]{containerType}), true);
        return 0;
    }

    public static int showLast(CommandContext<CommandSource> context) {
        if (InventorySorter.INSTANCE.lastContainerType != null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("inventorysorter.commands.inventorysorter.showlast.message", new Object[]{InventorySorter.INSTANCE.lastContainerType}), true);
        } else {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("inventorysorter.commands.inventorysorter.showlast.nosort", new Object[0]), true);
        }
        return 0;
    }

    public static int showBlacklist(CommandContext<CommandSource> context) {
        if (InventorySorter.INSTANCE.containerblacklist.isEmpty()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("inventorysorter.commands.inventorysorter.showblacklist.empty", new Object[0]), true);
        } else {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("inventorysorter.commands.inventorysorter.showblacklist.message", new Object[]{InventorySorter.listBlacklist().collect(Collectors.toList())}), true);
        }
        return 0;
    }

    public static Stream<String> listContainers() {
        return ForgeRegistries.CONTAINERS.getEntries().stream().map(e -> ((ResourceLocation)e.getKey()).toString());
    }

    static Stream<String> listBlacklist() {
        return InventorySorter.INSTANCE.containerblacklist.stream().map(Object::toString);
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

