/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends agu<rk>
implements ahr,
cc,
AutoCloseable,
Runnable {
    private static final Logger h = LogManager.getLogger();
    public static final File b = new File("usercache.json");
    private static final CompletableFuture<aag> i = CompletableFuture.completedFuture(aag.a);
    public static final bhv c = new bhv("North Carolina".hashCode(), bho.b, true, false, bhy.b).a();
    private final coq j;
    private final ahq k = new ahq("server", this, p.b());
    private final File l;
    private final List<Runnable> m = Lists.newArrayList();
    private final agj n = new agj(this::aj);
    private final wb o;
    protected final vu d;
    private final qf p = new qf();
    private final Random q = new Random();
    private final DataFixer r;
    private String s;
    private int t = -1;
    private final Map<byn, vk> u = Maps.newIdentityHashMap();
    private xv v;
    private volatile boolean w = true;
    private boolean x;
    private int y;
    protected final Proxy e;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    private boolean E;
    @Nullable
    private String F;
    private int G;
    private int H;
    public final long[] f = new long[100];
    @Nullable
    private KeyPair I;
    @Nullable
    private String J;
    private final String K;
    private boolean M;
    private boolean N;
    private String O = "";
    private String P = "";
    private volatile boolean Q;
    private long R;
    @Nullable
    private jo S;
    private boolean T;
    private boolean U;
    @Nullable
    private final YggdrasilAuthenticationService V;
    private final MinecraftSessionService W;
    private final GameProfileRepository X;
    private final xr Y;
    private long Z;
    protected final Thread g = p.a(new Thread((Runnable)this, "Server thread"), (T thread2) -> thread2.setUncaughtExceptionHandler((thread, throwable) -> h.error((Object)throwable)));
    private long aa = p.b();
    private long ab;
    private boolean ac;
    private final xg ae = new xn(wm.b, this.g);
    private final wx<xa> af = new wx<xa>(xa::new);
    @Nullable
    private wv ag;
    private final ce ah;
    private final bes ai = new bes();
    private final zi aj = new zi();
    private final rj ak = new rj(this);
    private final rm al = new rm(this);
    private final cpd am = new cpd();
    private final rg an = new rg();
    private final rh ao = new rh(this);
    private final zr ap = new zr();
    private boolean aq;
    private boolean ar;
    private boolean as;
    private float at;
    private final Executor au;
    @Nullable
    private String av;

    public MinecraftServer(File file, Proxy proxy, DataFixer dataFixer, ce ce2, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, xr xr2, vu vu2, String string) {
        super("Server");
        this.e = proxy;
        this.ah = ce2;
        this.V = yggdrasilAuthenticationService;
        this.W = minecraftSessionService;
        this.X = gameProfileRepository;
        this.Y = xr2;
        this.l = file;
        this.o = new wb(this);
        this.d = vu2;
        this.j = new coq(file.toPath(), file.toPath().resolve("../backups"), dataFixer);
        this.r = dataFixer;
        this.ae.a(this.aj);
        this.ae.a(this.ai);
        this.ae.a(this.am);
        this.ae.a(this.ao);
        this.ae.a(this.an);
        this.au = p.e();
        this.K = string;
    }

    @Override
    private void a(col col2) {
        ctj ctj2 = col2.a(ctj::new, "scoreboard");
        ctj2.a(this.aM());
        this.aM().a(new cob(ctj2));
    }

    protected abstract boolean d() throws IOException;

    @Override
    protected void a(String string) {
        if (this.O().a(string)) {
            h.info("Converting map!");
            this.b(new jy("menu.convertingLevel", new Object[0]));
            this.O().a(string, new zz(){
                private long b = p.b();

                @Override
                public void a(jo jo2) {
                }

                @Override
                public void a(int n2) {
                    if (p.b() - this.b >= 1000L) {
                        this.b = p.b();
                        h.info("Converting... {}%", (Object)n2);
                    }
                }

                @Override
                public void c(jo jo2) {
                }
            });
        }
        if (this.ar) {
            h.info("Forcing world upgrade!");
            com com2 = this.O().b(this.K());
            if (com2 != null) {
                agx agx2 = new agx(this.K(), this.O(), com2, this.as);
                jo \u26032 = null;
                while (!agx2.b()) {
                    jo jo2 = agx2.g();
                    if (\u26032 != jo2) {
                        \u26032 = jo2;
                        h.info(agx2.g().getString());
                    }
                    if ((\u2603 = agx2.d()) > 0) {
                        int n2 = agx2.e() + agx2.f();
                        h.info("{}% completed ({} / {} chunks)...", (Object)zy.d((float)n2 / (float)\u2603 * 100.0f), (Object)n2, (Object)\u2603);
                    }
                    if (this.ad()) {
                        agx2.a();
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    protected synchronized void b(jo jo2) {
        this.S = jo2;
    }

    protected void a(String string, String string2, long l22, bhy bhy2, JsonElement jsonElement) {
        bhv \u26033;
        this.a(string);
        this.b(new jy("menu.loadingLevel", new Object[0]));
        coo coo2 = this.O().a(string, this);
        this.a(this.K(), coo2);
        com \u26032 = coo2.c();
        if (\u26032 == null) {
            if (this.N()) {
                \u26033 = c;
            } else {
                long l22;
                \u26033 = new bhv(l22, this.g(), this.f(), this.i(), bhy2);
                \u26033.a(jsonElement);
                if (this.N) {
                    \u26033.a();
                }
            }
            \u26032 = new com(\u26033, string2);
        } else {
            \u26032.a(string2);
            \u26033 = new bhv(\u26032);
        }
        this.a(coo2.a(), \u26032);
        vt vt2 = this.d.create(11);
        this.a(coo2, \u26032, \u26033, vt2);
        this.a(this.h(), true);
        this.a(vt2);
    }

    protected void a(coo coo2, com com22, bhv bhv2, vt vt2) {
        vk vk2;
        if (this.N()) {
            com22.a(c);
        }
        vk vk3 = new vk(this, this.au, coo2, com22, byn.a, this.n, vt2);
        this.u.put(byn.a, vk3);
        this.a(vk3.x());
        vk3.q_().b(com22);
        vk2 = this.a(byn.a);
        if (!com22.u()) {
            com com22;
            try {
                vk2.a(bhv2);
                if (com22.s() == bhy.h) {
                    this.a(com22);
                }
                com22.d(true);
            }
            catch (Throwable throwable) {
                d d2 = d.a(throwable, "Exception initializing level");
                try {
                    vk2.a(d2);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new m(d2);
            }
            com22.d(true);
        }
        this.ae().a(vk2);
        if (com22.P() != null) {
            this.aP().a(com22.P());
        }
        for (byn byn2 : byn.a()) {
            if (byn2 == byn.a) continue;
            this.u.put(byn2, new vc(vk2, this, this.au, coo2, byn2, (agn)this.n, vt2));
        }
    }

    @Override
    private void a(com com2) {
        com2.f(false);
        com2.c(true);
        com2.b(false);
        com2.a(false);
        com2.g(1000000000);
        com2.b(6000L);
        com2.a(bho.e);
        com2.g(false);
        com2.a(ahg.a);
        com2.e(true);
        com2.v().a(bhn.j).a(false, this);
    }

    protected void a(File file, com com2) {
        this.af.a(new wz());
        this.ag = new wv(new File(file, "datapacks"));
        this.af.a(this.ag);
        this.af.a();
        ArrayList arrayList = Lists.newArrayList();
        for (String string : com2.O()) {
            xa xa2 = this.af.a(string);
            if (xa2 != null) {
                arrayList.add(xa2);
                continue;
            }
            h.warn("Missing data pack {}", (Object)string);
        }
        this.af.a(arrayList);
        this.b(com2);
    }

    @Override
    protected void a(vt vt2) {
        this.b(new jy("menu.generatingTerrain", new Object[0]));
        vk vk2 = this.a(byn.a);
        h.info("Preparing start region for dimension " + byn.a(vk2.p.p()));
        ew \u26032 = vk2.o_();
        vt2.a(new bhd(\u26032));
        vi \u26033 = vk2.m();
        \u26033.a().a(500);
        this.aa = p.b();
        \u26033.a(vp.a, new bhd(\u26032), 11, aag.a);
        while (\u26033.b() != 441) {
            this.aa = p.b() + 10L;
            this.p();
        }
        this.aa = p.b() + 10L;
        this.p();
        for (byn byn2 : byn.a()) {
            bhm bhm2 = this.a(byn2).x().b(bhm::new, "chunks");
            if (bhm2 == null) continue;
            vk \u26034 = this.a(byn2);
            LongIterator \u26035 = bhm2.a().iterator();
            while (\u26035.hasNext()) {
                long l2 = \u26035.nextLong();
                bhd \u26036 = new bhd(l2);
                \u26034.m().a(\u26036, true);
            }
        }
        this.aa = p.b() + 10L;
        this.p();
        vt2.b();
        \u26033.a().a(5);
    }

    protected void a(String string, coo coo2) {
        File file = new File(coo2.a(), "resources.zip");
        if (file.isFile()) {
            try {
                this.a("level://" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                h.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public abstract boolean f();

    public abstract bho g();

    public abstract ahg h();

    public abstract boolean i();

    public abstract int j();

    public abstract int k();

    public abstract boolean l();

    public boolean a(boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        for (vk vk2 : this.y()) {
            if (!bl2) {
                h.info("Saving chunks for level '{}'/{}", (Object)vk2.p_().i(), (Object)byn.a(vk2.p.p()));
            }
            try {
                vk2.a(null, bl3, vk2.b && !bl4);
            }
            catch (bht bht2) {
                h.warn(bht2.getMessage());
            }
            bl5 = true;
        }
        vk vk2 = this.a(byn.a);
        com com2 = vk2.p_();
        vk2.q_().a(com2);
        com2.c(this.aP().c());
        vk2.w().a(com2, this.ae().r());
        return bl5;
    }

    @Override
    public void close() {
        this.m();
    }

    protected void m() {
        h.info("Stopping server");
        if (this.ag() != null) {
            this.ag().b();
        }
        if (this.v != null) {
            h.info("Saving players");
            this.v.i();
            this.v.s();
        }
        h.info("Saving worlds");
        for (vk vk2 : this.y()) {
            if (vk2 == null) continue;
            vk2.b = false;
        }
        this.a(false, true, false);
        for (vk vk2 : this.y()) {
            if (vk2 == null) continue;
            try {
                vk2.close();
            }
            catch (IOException iOException) {
                h.error("Exception closing the level", (Throwable)iOException);
            }
        }
        if (this.k.d()) {
            this.k.e();
        }
    }

    public String n() {
        return this.s;
    }

    public void b(String string) {
        this.s = string;
    }

    public boolean h_() {
        return this.w;
    }

    @Override
    public void a(boolean bl2) {
        this.w = false;
        if (bl2) {
            try {
                this.g.join();
            }
            catch (InterruptedException interruptedException) {
                h.error("Error while shutting down", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.d()) {
                this.aa = p.b();
                this.p.a(new jx(this.F));
                this.p.a(new qf.c(o.a().getName(), o.a().getProtocolVersion()));
                this.a(this.p);
                while (this.w) {
                    long l2 = p.b() - this.aa;
                    if (l2 > 2000L && this.aa - this.R >= 15000L) {
                        \u2603 = l2 / 50L;
                        h.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l2, (Object)\u2603);
                        this.aa += \u2603 * 50L;
                        this.R = this.aa;
                    }
                    this.aa += 50L;
                    if (this.T) {
                        this.T = false;
                        this.n.d().d();
                    }
                    this.n.a();
                    this.n.a("tick");
                    this.a(this::aW);
                    this.n.b("nextTickWait");
                    this.ac = true;
                    this.ab = Math.max(p.b() + 50L, this.aa);
                    this.p();
                    this.n.c();
                    this.n.b();
                    this.Q = true;
                }
            } else {
                this.a((d)null);
            }
        }
        catch (Throwable throwable) {
            h.error("Encountered an unexpected exception", throwable);
            d d2 = throwable instanceof m ? this.b(((m)throwable).a()) : this.b(new d("Exception in server tick loop", throwable));
            File \u26032 = new File(new File(this.t(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (d2.a(\u26032)) {
                h.error("This crash report has been saved to: {}", (Object)\u26032.getAbsolutePath());
            } else {
                h.error("We were unable to save this crash report to disk.");
            }
            this.a(d2);
        }
        finally {
            try {
                this.x = true;
                this.m();
            }
            catch (Throwable \u26033) {
                h.error("Exception stopping the server", \u26033);
            }
            finally {
                this.u();
            }
        }
    }

    private boolean aW() {
        return this.bj() || p.b() < (this.ac ? this.ab : this.aa);
    }

    protected void p() {
        this.bh();
        this.c(() -> !this.aW());
    }

    protected rk a(Runnable runnable) {
        return new rk(this.y, runnable);
    }

    protected boolean a(rk rk2) {
        return rk2.a() + 3 < this.y || this.aW();
    }

    @Override
    public boolean q() {
        boolean bl2;
        this.ac = bl2 = this.aX();
        return bl2;
    }

    private boolean aX() {
        if (super.q()) {
            return true;
        }
        if (this.aW()) {
            for (vk vk2 : this.y()) {
                if (!vk2.m().d()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(qf qf2) {
        File file = this.d("server-icon.png");
        if (!file.exists()) {
            file = this.O().b(this.K(), "icon.png");
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuffer \u26032 = Base64.getEncoder().encode(byteBuf.nioBuffer());
                qf2.a("data:image/png;base64," + StandardCharsets.UTF_8.decode(\u26032));
            }
            catch (Exception exception) {
                h.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public File t() {
        return new File(".");
    }

    @Override
    protected void a(d d2) {
    }

    protected void u() {
    }

    @Override
    protected void a(BooleanSupplier booleanSupplier) {
        long l2 = p.c();
        ++this.y;
        this.b(booleanSupplier);
        if (l2 - this.Z >= 5000000000L) {
            this.Z = l2;
            this.p.a(new qf.a(this.B(), this.A()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.A(), 12)];
            int \u26032 = zy.a(this.q, 0, this.A() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.v.t().get(\u26032 + i2).dH();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.p.b().a(gameProfileArray);
        }
        if (this.y % 6000 == 0) {
            h.debug("Autosave started");
            this.n.a("save");
            this.v.i();
            this.a(true, false, false);
            this.n.c();
            h.debug("Autosave finished");
        }
        this.n.a("snooper");
        if (!this.k.d() && this.y > 100) {
            this.k.a();
        }
        if (this.y % 6000 == 0) {
            this.k.b();
        }
        this.n.c();
        this.n.a("tallying");
        long l3 = p.c() - l2;
        this.f[this.y % 100] = l3;
        \u2603 = l3;
        this.at = this.at * 0.8f + (float)\u2603 / 1000000.0f * 0.19999999f;
        \u2603 = p.c();
        this.ap.a(\u2603 - l2);
        this.n.c();
    }

    protected void b(BooleanSupplier booleanSupplier) {
        this.n.a("commandFunctions");
        this.aD().e();
        this.n.b("levels");
        for (vk vk2 : this.y()) {
            if (vk2.p.p() != byn.a && !this.v()) continue;
            this.n.a(() -> vk2.p_().i() + " " + fn.x.b(vk2.p.p()));
            if (this.y % 20 == 0) {
                this.n.a("timeSync");
                this.v.a(new ne(vk2.R(), vk2.S(), vk2.T().b(bhn.j)), vk2.p.p());
                this.n.c();
            }
            this.n.a("tick");
            try {
                vk2.a(booleanSupplier);
            }
            catch (Throwable throwable) {
                d d2 = d.a(throwable, "Exception ticking world");
                vk2.a(d2);
                throw new m(d2);
            }
            this.n.c();
            this.n.c();
        }
        this.n.b("connection");
        this.ag().c();
        this.n.b("players");
        this.v.d();
        this.n.b("server gui refresh");
        for (int i2 = 0; i2 < this.m.size(); ++i2) {
            this.m.get(i2).run();
        }
        this.n.c();
    }

    public boolean v() {
        return true;
    }

    public void b(Runnable runnable) {
        this.m.add(runnable);
    }

    public static void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder \u26032 = optionParser.accepts("nogui");
        OptionSpecBuilder \u26033 = optionParser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder \u26034 = optionParser.accepts("demo");
        OptionSpecBuilder \u26035 = optionParser.accepts("bonusChest");
        OptionSpecBuilder \u26036 = optionParser.accepts("forceUpgrade");
        OptionSpecBuilder \u26037 = optionParser.accepts("eraseCache");
        AbstractOptionSpec \u26038 = optionParser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec \u26039 = optionParser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260310 = optionParser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260311 = optionParser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260312 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u260313 = optionParser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec \u260314 = optionParser.nonOptions();
        try {
            OptionSet optionSet = optionParser.parse(stringArray);
            if (optionSet.has((OptionSpec)\u26038)) {
                optionParser.printHelpOn((OutputStream)System.err);
                return;
            }
            Path \u260315 = Paths.get("server.properties", new String[0]);
            um \u260316 = new um(\u260315);
            \u260316.b();
            Path \u260317 = Paths.get("eula.txt", new String[0]);
            rc \u260318 = new rc(\u260317);
            if (optionSet.has((OptionSpec)\u26033)) {
                h.info("Initialized '" + \u260315.toAbsolutePath().toString() + "' and '" + \u260317.toAbsolutePath().toString() + "'");
                return;
            }
            if (!\u260318.a()) {
                h.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            qx.a();
            qx.c();
            String \u260319 = (String)optionSet.valueOf((OptionSpec)\u260310);
            YggdrasilAuthenticationService \u260320 = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService \u260321 = \u260320.createMinecraftSessionService();
            GameProfileRepository \u260322 = \u260320.createProfileRepository();
            xr \u260323 = new xr(\u260322, new File(\u260319, b.getName()));
            String \u260324 = (String)Optional.ofNullable(optionSet.valueOf((OptionSpec)\u260311)).orElse(\u260316.a().o);
            final uk \u260325 = new uk(new File(\u260319), \u260316, aak.a(), \u260320, \u260321, \u260322, \u260323, vv::new, \u260324);
            \u260325.i((String)optionSet.valueOf((OptionSpec)\u26039));
            \u260325.a((Integer)optionSet.valueOf((OptionSpec)\u260312));
            \u260325.e(optionSet.has((OptionSpec)\u26034));
            \u260325.f(optionSet.has((OptionSpec)\u26035));
            \u260325.b(optionSet.has((OptionSpec)\u26036));
            \u260325.c(optionSet.has((OptionSpec)\u26037));
            \u260325.c((String)optionSet.valueOf((OptionSpec)\u260313));
            boolean bl2 = \u2603 = !optionSet.has((OptionSpec)\u26032) && !optionSet.valuesOf((OptionSpec)\u260314).contains("nogui");
            if (\u2603 && !GraphicsEnvironment.isHeadless()) {
                \u260325.aZ();
            }
            \u260325.w();
            Thread \u260326 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    \u260325.a(true);
                }
            };
            \u260326.setUncaughtExceptionHandler(new g(h));
            Runtime.getRuntime().addShutdownHook(\u260326);
        }
        catch (Exception exception) {
            h.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    protected void c(String string) {
        this.av = string;
    }

    protected void b(boolean bl2) {
        this.ar = bl2;
    }

    protected void c(boolean bl2) {
        this.as = bl2;
    }

    public void w() {
        this.g.start();
    }

    public File d(String string) {
        return new File(this.t(), string);
    }

    public void e(String string) {
        h.info(string);
    }

    public void f(String string) {
        h.warn(string);
    }

    public vk a(byn byn2) {
        return this.u.get(byn2);
    }

    public Iterable<vk> y() {
        return this.u.values();
    }

    public String z() {
        return o.a().getName();
    }

    public int A() {
        return this.v.n();
    }

    public int B() {
        return this.v.o();
    }

    public String[] C() {
        return this.v.e();
    }

    public boolean E() {
        return false;
    }

    @Override
    public void g(String string) {
        h.error(string);
    }

    @Override
    public void h(String string) {
        if (this.E()) {
            h.info(string);
        }
    }

    public String getServerModName() {
        return "vanilla";
    }

    public d b(d d2) {
        if (this.v != null) {
            d2.g().a("Player Count", () -> this.v.n() + " / " + this.v.o() + "; " + this.v.t());
        }
        d2.g().a("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (xa xa2 : this.af.d()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(xa2.e());
                if (xa2.c().a()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        if (this.av != null) {
            d2.g().a("Server Id", () -> this.av);
        }
        return d2;
    }

    public boolean F() {
        return this.l != null;
    }

    @Override
    public void a(jo jo2) {
        h.info(jo2.getString());
    }

    public KeyPair G() {
        return this.I;
    }

    public int H() {
        return this.t;
    }

    @Override
    public void a(int n2) {
        this.t = n2;
    }

    public String I() {
        return this.J;
    }

    public void i(String string) {
        this.J = string;
    }

    public boolean J() {
        return this.J != null;
    }

    public String K() {
        return this.K;
    }

    @Override
    public void a(KeyPair keyPair) {
        this.I = keyPair;
    }

    public void a(ahg ahg2, boolean bl2) {
        for (vk vk2 : this.y()) {
            com com2 = vk2.p_();
            if (!bl2 && com2.x()) continue;
            if (com2.r()) {
                com2.a(ahg.d);
                vk2.a(true, true);
                continue;
            }
            if (this.J()) {
                com2.a(ahg2);
                vk2.a(vk2.ac() != ahg.a, true);
                continue;
            }
            com2.a(ahg2);
            vk2.a(this.M(), this.B);
        }
        this.ae().t().forEach(this::a);
    }

    public void d(boolean bl2) {
        for (vk vk2 : this.y()) {
            com com2 = vk2.p_();
            com2.e(bl2);
        }
        this.ae().t().forEach(this::a);
    }

    @Override
    private void a(vl vl2) {
        com com2 = vl2.s().p_();
        vl2.b.a(new ku(com2.w(), com2.x()));
    }

    protected boolean M() {
        return true;
    }

    public boolean N() {
        return this.M;
    }

    public void e(boolean bl2) {
        this.M = bl2;
    }

    public void f(boolean bl2) {
        this.N = bl2;
    }

    public coq O() {
        return this.j;
    }

    public String P() {
        return this.O;
    }

    public String Q() {
        return this.P;
    }

    public void a(String string, String string2) {
        this.O = string;
        this.P = string2;
    }

    @Override
    public void a(ahq ahq22) {
        ahq ahq22;
        ahq22.a("whitelist_enabled", false);
        ahq22.a("whitelist_count", 0);
        if (this.v != null) {
            ahq22.a("players_current", this.A());
            ahq22.a("players_max", this.B());
            ahq22.a("players_seen", this.a(byn.a).w().d().length);
        }
        ahq22.a("uses_auth", this.z);
        ahq22.a("gui_state", this.ai() ? "enabled" : "disabled");
        ahq22.a("run_time", (p.b() - ahq22.g()) / 60L * 1000L);
        ahq22.a("avg_tick_ms", (int)(zy.a(this.f) * 1.0E-6));
        int n2 = 0;
        for (vk vk2 : this.y()) {
            if (vk2 == null) continue;
            com com2 = vk2.p_();
            ahq22.a("world[" + n2 + "][dimension]", vk2.p.p());
            ahq22.a("world[" + n2 + "][mode]", (Object)com2.p());
            ahq22.a("world[" + n2 + "][difficulty]", (Object)vk2.ac());
            ahq22.a("world[" + n2 + "][hardcore]", com2.r());
            ahq22.a("world[" + n2 + "][generator_name]", com2.s().a());
            ahq22.a("world[" + n2 + "][generator_version]", com2.s().e());
            ahq22.a("world[" + n2 + "][height]", this.G);
            ahq22.a("world[" + n2 + "][chunks_loaded]", vk2.m().h());
            ++n2;
        }
        ahq22.a("worlds", n2);
    }

    public abstract boolean S();

    public boolean T() {
        return this.z;
    }

    @Override
    public void g(boolean bl2) {
        this.z = bl2;
    }

    public boolean U() {
        return this.A;
    }

    @Override
    public void h(boolean bl2) {
        this.A = bl2;
    }

    public boolean V() {
        return this.B;
    }

    public void i(boolean bl2) {
        this.B = bl2;
    }

    public boolean W() {
        return this.C;
    }

    public abstract boolean X();

    public void j(boolean bl2) {
        this.C = bl2;
    }

    public boolean Y() {
        return this.D;
    }

    public void k(boolean bl2) {
        this.D = bl2;
    }

    public boolean Z() {
        return this.E;
    }

    public void l(boolean bl2) {
        this.E = bl2;
    }

    public abstract boolean aa();

    public String ab() {
        return this.F;
    }

    public void k(String string) {
        this.F = string;
    }

    public int ac() {
        return this.G;
    }

    public void b(int n2) {
        this.G = n2;
    }

    public boolean ad() {
        return this.x;
    }

    public xv ae() {
        return this.v;
    }

    @Override
    public void a(xv xv2) {
        this.v = xv2;
    }

    public abstract boolean af();

    @Override
    public void a(bho bho2) {
        for (vk vk2 : this.y()) {
            vk2.p_().a(bho2);
        }
    }

    @Nullable
    public wb ag() {
        return this.o;
    }

    public boolean ai() {
        return false;
    }

    public abstract boolean a(bho var1, boolean var2, int var3);

    public int aj() {
        return this.y;
    }

    public void ak() {
        this.T = true;
    }

    public int an() {
        return 16;
    }

    public boolean a(bhr bhr2, ew ew2, awg awg2) {
        return false;
    }

    public void m(boolean bl2) {
        this.U = bl2;
    }

    public boolean ao() {
        return this.U;
    }

    public int aq() {
        return this.H;
    }

    public void c(int n2) {
        this.H = n2;
    }

    public MinecraftSessionService ar() {
        return this.W;
    }

    public GameProfileRepository as() {
        return this.X;
    }

    public xr at() {
        return this.Y;
    }

    public qf au() {
        return this.p;
    }

    public void av() {
        this.Z = 0L;
    }

    public int aw() {
        return 29999984;
    }

    @Override
    public boolean ax() {
        return super.ax() && !this.ad();
    }

    @Override
    public Thread ay() {
        return this.g;
    }

    public int az() {
        return 256;
    }

    public long aA() {
        return this.aa;
    }

    public DataFixer aB() {
        return this.r;
    }

    public int a(@Nullable vk vk2) {
        if (vk2 != null) {
            return vk2.T().c(bhn.q);
        }
        return 10;
    }

    public rg aC() {
        return this.an;
    }

    public rh aD() {
        return this.ao;
    }

    public void aE() {
        if (!this.bd()) {
            this.execute(this::aE);
            return;
        }
        this.ae().i();
        this.af.a();
        this.b(this.a(byn.a).p_());
        this.ae().u();
    }

    private void b(com com2) {
        ArrayList arrayList = Lists.newArrayList(this.af.d());
        for (xa xa3 : this.af.b()) {
            if (com2.N().contains(xa3.e()) || arrayList.contains(xa3)) continue;
            h.info("Found new data pack {}, loading it automatically", (Object)xa3.e());
            xa3.h().a(arrayList, xa3, (T xa2) -> xa2, false);
        }
        this.af.a(arrayList);
        ArrayList arrayList2 = Lists.newArrayList();
        this.af.d().forEach(xa2 -> arrayList2.add(xa2.d()));
        CompletableFuture<aag> completableFuture = this.ae.a(this.au, this, arrayList2, i);
        this.c(completableFuture::isDone);
        try {
            completableFuture.get();
        }
        catch (Exception \u26033) {
            h.error("Failed to reload data packs", (Throwable)\u26033);
        }
        com2.O().clear();
        com2.N().clear();
        this.af.d().forEach(xa2 -> com2.O().add(xa2.e()));
        this.af.b().forEach(xa2 -> {
            if (!this.af.d().contains(xa2)) {
                com2.N().add(xa2.e());
            }
        });
    }

    @Override
    public void a(cd cd2) {
        if (!this.aQ()) {
            return;
        }
        xv xv2 = cd2.j().ae();
        yc \u26032 = xv2.j();
        if (!\u26032.b()) {
            return;
        }
        ArrayList \u26033 = Lists.newArrayList(xv2.t());
        for (vl vl2 : \u26033) {
            if (\u26032.a(vl2.dH())) continue;
            vl2.b.b(new jy("multiplayer.disconnect.not_whitelisted", new Object[0]));
        }
    }

    public xg aF() {
        return this.ae;
    }

    public wx<xa> aG() {
        return this.af;
    }

    public ce aI() {
        return this.ah;
    }

    public cd aJ() {
        return new cd(this, this.a(byn.a) == null ? csi.a : new csi(this.a(byn.a).o_()), csh.a, this.a(byn.a), 4, "Server", new jx("Server"), this, null);
    }

    @Override
    public boolean a() {
        return true;
    }

    @Override
    public boolean b() {
        return true;
    }

    public bes aK() {
        return this.ai;
    }

    public zi aL() {
        return this.aj;
    }

    public rj aM() {
        return this.ak;
    }

    public cpd aN() {
        return this.am;
    }

    public bhn aO() {
        return this.a(byn.a).T();
    }

    public rm aP() {
        return this.al;
    }

    public boolean aQ() {
        return this.aq;
    }

    public void n(boolean bl2) {
        this.aq = bl2;
    }

    public float aR() {
        return this.at;
    }

    public int a(GameProfile gameProfile) {
        if (this.ae().h(gameProfile)) {
            xx xx2 = (xx)this.ae().l().b(gameProfile);
            if (xx2 != null) {
                return xx2.a();
            }
            if (this.b(gameProfile)) {
                return 4;
            }
            if (this.J()) {
                return this.ae().v() ? 4 : 0;
            }
            return this.j();
        }
        return 0;
    }

    public agj aT() {
        return this.n;
    }

    public Executor aU() {
        return this.au;
    }

    public abstract boolean b(GameProfile var1);

    @Override
    public void a(Path path) throws IOException {
        \u2603 = path.resolve("levels");
        for (Map.Entry<byn, vk> entry : this.u.entrySet()) {
            qv qv2 = byn.a(entry.getKey());
            Path \u26032 = \u2603.resolve(qv2.b()).resolve(qv2.a());
            Files.createDirectories(\u26032, new FileAttribute[0]);
            entry.getValue().a(\u26032);
        }
        this.d(path.resolve("gamerules.txt"));
        this.e(path.resolve("classpath.txt"));
        this.c(path.resolve("example_crash.txt"));
        this.b(path.resolve("stats.txt"));
        this.f(path.resolve("threads.txt"));
    }

    private void b(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format("pending_tasks: %d\n", this.be()));
            bufferedWriter.write(String.format("average_tick_time: %f\n", Float.valueOf(this.aR())));
            bufferedWriter.write(String.format("tick_times: %s\n", Arrays.toString(this.f)));
            bufferedWriter.write(String.format("queue: %s\n", p.e()));
        }
    }

    private void c(Path path) throws IOException {
        d d2 = new d("Server dump", new Exception("dummy"));
        this.b(d2);
        try (BufferedWriter \u26032 = Files.newBufferedWriter(path, new OpenOption[0]);){
            \u26032.write(d2.e());
        }
    }

    private void d(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList arrayList = Lists.newArrayList();
            final bhn \u26032 = this.aO();
            bhn.a(new bhn.b(){

                @Override
                public <T extends bhn.f<T>> void a(bhn.d<T> d2, bhn.e<T> e2) {
                    arrayList.add(String.format("%s=%s\n", d2.a(), ((bhn.f)\u26032.a(d2)).toString()));
                }
            });
            for (String string : arrayList) {
                bufferedWriter.write(string);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            String string = System.getProperty("java.class.path");
            \u2603 = System.getProperty("path.separator");
            for (String string2 : Splitter.on((String)\u2603).split((CharSequence)string)) {
                bufferedWriter.write(string2);
                bufferedWriter.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] \u26032 = threadMXBean.dumpAllThreads(true, true);
        Arrays.sort(\u26032, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter \u26033 = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadInfo : \u26032) {
                \u26033.write(threadInfo.toString());
                ((Writer)\u26033).write(10);
            }
        }
    }

    @Override
    public /* synthetic */ boolean c(Runnable runnable) {
        return this.a((rk)runnable);
    }

    @Override
    public /* synthetic */ Runnable d(Runnable runnable) {
        return this.a(runnable);
    }
}

