/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.informationscreen.network;

import java.util.function.Supplier;
import mcjty.lib.McJtyLib;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolspower.modules.informationscreen.blocks.InformationScreenTileEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketMonitorLogReady {
    private BlockPos pos;
    private EnergyTools.EnergyLevel power;
    private long rfPerTickInserted;
    private long rfPerTickExtracted;
    private long roughMaxRfPerTick;

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeLong(this.rfPerTickExtracted);
        buf.writeLong(this.rfPerTickInserted);
        buf.writeLong(this.roughMaxRfPerTick);
        if (this.power != null) {
            buf.writeBoolean(true);
            buf.writeLong(this.power.getEnergy());
            buf.writeLong(this.power.getMaxEnergy());
        } else {
            buf.writeBoolean(false);
        }
    }

    public PacketMonitorLogReady(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.rfPerTickExtracted = buf.readLong();
        this.rfPerTickInserted = buf.readLong();
        this.roughMaxRfPerTick = buf.readLong();
        this.power = buf.readBoolean() ? new EnergyTools.EnergyLevel(buf.readLong(), buf.readLong()) : null;
    }

    public PacketMonitorLogReady(BlockPos pos, EnergyTools.EnergyLevel power, long rfPerTickInserted, long rfPerTickExtracted, long roughMaxRfPerTick) {
        this.pos = pos;
        this.power = power;
        this.rfPerTickExtracted = rfPerTickExtracted;
        this.rfPerTickInserted = rfPerTickInserted;
        this.roughMaxRfPerTick = roughMaxRfPerTick;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = McJtyLib.proxy.getClientWorld().func_175625_s(this.pos);
            if (te instanceof InformationScreenTileEntity) {
                InformationScreenTileEntity info = (InformationScreenTileEntity)te;
                info.setClientPower(this.power, this.rfPerTickInserted, this.rfPerTickExtracted, this.roughMaxRfPerTick);
            }
        });
        ctx.setPacketHandled(true);
    }
}

