/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs.registry.json;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.blay09.mods.kleeslabs.KleeSlabs;
import net.blay09.mods.kleeslabs.KleeSlabsConfig;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.blay09.mods.kleeslabs.registry.SlabRegistry;
import net.blay09.mods.kleeslabs.registry.SlabRegistryData;
import net.blay09.mods.kleeslabs.registry.json.JsonCompatData;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class JsonCompatLoader
implements IResourceManagerReloadListener {
    private static final Gson gson = new Gson();

    public void func_195410_a(IResourceManager resourceManager) {
        for (ResourceLocation resourceLocation : resourceManager.func_199003_a("kleeslabs_compat", it -> it.endsWith(".json"))) {
            try {
                IResource resource = resourceManager.func_199002_a(resourceLocation);
                Throwable throwable = null;
                try {
                    InputStreamReader reader = new InputStreamReader(resource.func_199027_b());
                    JsonCompatLoader.load((JsonCompatData)gson.fromJson((Reader)reader, JsonCompatData.class));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (IOException e) {
                KleeSlabs.logger.error("Parsing error loading KleeSlabs Data File at {}", (Object)resourceLocation, (Object)e);
            }
        }
    }

    private static void parse(Reader reader) {
        JsonCompatLoader.load((JsonCompatData)gson.fromJson(reader, JsonCompatData.class));
    }

    private static boolean isCompatEnabled(String modId) {
        return !((List)KleeSlabsConfig.COMMON.disabledCompat.get()).contains(modId);
    }

    private static void load(JsonCompatData data) {
        Map<String, String> mappedSlabs;
        Class<?> converterClass;
        String modId = data.getModId();
        if (!modId.equals("minecraft") && !ModList.get().isLoaded(modId) || !JsonCompatLoader.isCompatEnabled(modId)) {
            return;
        }
        boolean isSilent = data.isSilent();
        String converterName = data.getConverter();
        try {
            converterClass = Class.forName("net.blay09.mods.kleeslabs.converter." + converterName);
        }
        catch (ClassNotFoundException ignored) {
            try {
                converterClass = Class.forName(converterName);
            }
            catch (ClassNotFoundException e) {
                KleeSlabs.logger.error("Slab converter class was not found: {}", (Object)converterName);
                return;
            }
        }
        if (!SlabConverter.class.isAssignableFrom(converterClass)) {
            KleeSlabs.logger.error("Slab converter class was not found: {}", (Object)converterName);
            return;
        }
        Set<String> slabs = data.getSlabs();
        if (slabs != null) {
            for (String string : slabs) {
                Block block = JsonCompatLoader.parseBlock(modId, string);
                if (block != Blocks.field_150350_a) {
                    SlabRegistry.registerSlab(new SlabRegistryData(converterClass, block, block));
                    continue;
                }
                if (isSilent) continue;
                KleeSlabs.logger.error("Slab {} could not be found.", (Object)string);
            }
        }
        if ((mappedSlabs = data.getMappedSlabs()) != null) {
            for (Map.Entry<String, String> entry : mappedSlabs.entrySet()) {
                String singleSlabName = entry.getKey();
                Block singleSlab = JsonCompatLoader.parseBlock(modId, singleSlabName);
                if (singleSlab == Blocks.field_150350_a) {
                    KleeSlabs.logger.error("Slab {} could not be found.", (Object)singleSlabName);
                    continue;
                }
                String doubleSlabName = entry.getValue();
                Block doubleSlab = JsonCompatLoader.parseBlock(modId, doubleSlabName);
                if (doubleSlab == Blocks.field_150350_a) {
                    KleeSlabs.logger.error("Slab {} could not be found.", (Object)doubleSlabName);
                    continue;
                }
                SlabRegistry.registerSlab(new SlabRegistryData(converterClass, singleSlab, doubleSlab));
            }
        }
        String string = data.getPatternSearch() != null ? data.getPatternSearch() : ".+";
        Pattern pattern = Pattern.compile(string);
        Matcher matcherSearch = pattern.matcher("");
        String patternReplace = data.getPatternReplace() != null ? data.getPatternReplace() : "$0_double";
        Set<String> patternSlabs = data.getPatternSlabs();
        if (patternSlabs != null) {
            for (String singleSlabName : patternSlabs) {
                matcherSearch.reset(singleSlabName);
                String doubleSlabName = matcherSearch.replaceFirst(patternReplace);
                Block singleSlab = JsonCompatLoader.parseBlock(modId, singleSlabName);
                if (singleSlab == Blocks.field_150350_a) {
                    KleeSlabs.logger.error("Slab {} could not be found.", (Object)singleSlabName);
                    continue;
                }
                Block doubleSlab = JsonCompatLoader.parseBlock(modId, doubleSlabName);
                if (doubleSlab == Blocks.field_150350_a) {
                    KleeSlabs.logger.error("Slab {} could not be found.", (Object)doubleSlabName);
                    continue;
                }
                SlabRegistry.registerSlab(new SlabRegistryData(converterClass, singleSlab, doubleSlab));
            }
        }
    }

    private static Block parseBlock(String modId, String name) {
        Block block;
        int colon = name.indexOf(58);
        if (colon != -1) {
            modId = name.substring(0, colon);
            name = name.substring(colon + 1);
        }
        return (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modId, name))) != null ? block : Blocks.field_150350_a;
    }
}

