/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.config.property.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropBase;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropParserBase;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import org.jetbrains.annotations.NotNull;

public final class PropByte
extends PropBase<Byte> {
    public static final PropByteParser PARSER = new PropByteParser();
    protected byte min;
    protected byte max;

    public PropByte(byte value, byte min, byte max) {
        super(value);
        this.min = min;
        this.max = max;
    }

    public PropByte(byte value) {
        this(value, -128, 127);
    }

    @Override
    public String getExtra() {
        return "[" + this.min + "~" + this.max + "]";
    }

    @Override
    protected Byte validateData(Byte data) {
        return MathUtil.clamp(data, this.min, this.max);
    }

    @Override
    public PropParserBase getParser() {
        return PARSER;
    }

    protected static final class PropByteParser
    extends PropParserBase<PropByte> {
        public PropByteParser() {
            super("by");
        }

        @Override
        public PropByte fromJson(@NotNull JsonElement json) throws Exception {
            return new PropByte(json.getAsByte());
        }

        @Override
        public JsonElement toJson(@NotNull PropByte prop) throws Exception {
            return new JsonPrimitive((Number)prop.getValue());
        }
    }
}

