/*
 * Decompiled with CFR 0.152.
 */
package atm.bloodworkxgaming.serverstarter;

import atm.bloodworkxgaming.serverstarter.FileManager;
import atm.bloodworkxgaming.serverstarter.ForgeManager;
import atm.bloodworkxgaming.serverstarter.InitException;
import atm.bloodworkxgaming.serverstarter.InternetManager;
import atm.bloodworkxgaming.serverstarter.config.ConfigFile;
import atm.bloodworkxgaming.serverstarter.config.LockFile;
import atm.bloodworkxgaming.serverstarter.logger.PrimitiveLogger;
import atm.bloodworkxgaming.serverstarter.packtype.IPackType;
import atm.bloodworkxgaming.serverstarter.yaml.CustomConstructor;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.fusesource.jansi.Ansi;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Latm/bloodworkxgaming/serverstarter/ServerStarter;", "", "args", "", "", "([Ljava/lang/String;)V", "installOnly", "", "greet", "", "startLoading", "Companion", "serverstarter"})
public final class ServerStarter {
    private final boolean installOnly;
    private static final Representer rep;
    private static final DumperOptions options;
    @NotNull
    private static final PrimitiveLogger LOGGER;
    @NotNull
    private static LockFile lockFile;
    @NotNull
    private static final ConfigFile config;
    public static final Companion Companion;

    public final void greet() {
        PrimitiveLogger primitiveLogger;
        PrimitiveLogger $receiver = primitiveLogger = LOGGER;
        $receiver.info("ConfigFile: " + config, true);
        $receiver.info("LockFile: " + lockFile, true);
        PrimitiveLogger.info$default($receiver, Ansi.ansi().fgRed().a("::::::::::::::::::::::::::::::::::::::::::::::::::::"), false, 2, null);
        PrimitiveLogger.info$default($receiver, Ansi.ansi().fgBrightBlue().a("   Minecraft-Forge Server install/launcher jar"), false, 2, null);
        PrimitiveLogger.info$default($receiver, Ansi.ansi().fgBrightBlue().a("   (Created by the ").fgGreen().a("\"All The Mods\"").fgBrightBlue().a(" modpack team)"), false, 2, null);
        PrimitiveLogger.info$default($receiver, Ansi.ansi().fgRed().a("::::::::::::::::::::::::::::::::::::::::::::::::::::"), false, 2, null);
        PrimitiveLogger.info$default($receiver, "", false, 2, null);
        PrimitiveLogger.info$default($receiver, "   This jar will launch a Minecraft Forge Modded server", false, 2, null);
        PrimitiveLogger.info$default($receiver, "", false, 2, null);
        PrimitiveLogger.info$default($receiver, Ansi.ansi().a("   Github:    ").fgBrightBlue().a("https://github.com/AllTheMods/ServerStarter"), false, 2, null);
        PrimitiveLogger.info$default($receiver, Ansi.ansi().a("   Discord:   ").fgBrightBlue().a("http://discord.allthepacks.com"), false, 2, null);
        PrimitiveLogger.info$default($receiver, "", false, 2, null);
        PrimitiveLogger.info$default($receiver, Ansi.ansi().a("You are playing ").fgGreen().a(config.getModpack().getName()), false, 2, null);
        PrimitiveLogger.info$default($receiver, "Starting to install/launch the server, lean back!", false, 2, null);
        PrimitiveLogger.info$default($receiver, Ansi.ansi().fgRed().a("::::::::::::::::::::::::::::::::::::::::::::::::::::"), false, 2, null);
        PrimitiveLogger.info$default($receiver, "", false, 2, null);
    }

    public final void startLoading() {
        if (!InternetManager.INSTANCE.checkConnection() && config.getLaunch().getCheckOffline()) {
            PrimitiveLogger.error$default(LOGGER, "Problems with the Internet connection, shutting down.", null, 2, null);
            System.exit(-1);
        }
        ForgeManager forgeManager = new ForgeManager(config);
        if (lockFile.checkShouldInstall(config) || this.installOnly) {
            IPackType iPackType = IPackType.Companion.createPackType(config.getInstall().getModpackFormat(), config);
            if (iPackType == null) {
                throw (Throwable)new InitException("Unknown pack format given in config, shutting down.", null, 2, null);
            }
            IPackType packtype2 = iPackType;
            packtype2.installPack();
            lockFile.setPackInstalled(true);
            lockFile.setPackUrl(config.getInstall().getModpackUrl());
            Companion.saveLockFile(lockFile);
            if (config.getInstall().getInstallForge()) {
                String forgeVersion = packtype2.getForgeVersion();
                String mcVersion = packtype2.getMCVersion();
                forgeManager.installForge(config.getInstall().getBaseInstallPath(), forgeVersion, mcVersion);
            }
            if (config.getLaunch().getSpongefix()) {
                lockFile.setSpongeBootstrapper(forgeManager.installSpongeBootstrapper(config.getInstall().getBaseInstallPath()));
                Companion.saveLockFile(lockFile);
            }
            FileManager filemanger = new FileManager(config);
            filemanger.installAdditionalFiles();
            filemanger.installLocalFiles();
        } else {
            PrimitiveLogger.info$default(LOGGER, "Server is already installed to correct version, to force install delete the serverstarter.lock File.", false, 2, null);
        }
        if (this.installOnly) {
            PrimitiveLogger.info$default(LOGGER, "Install only mod, exiting now.", false, 2, null);
            System.exit(0);
        }
        forgeManager.handleServer();
    }

    public ServerStarter(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        this.installOnly = Intrinsics.areEqual(ArraysKt.getOrNull(args, 0), "install");
    }

    static {
        Companion = new Companion(null);
        rep = new Representer();
        options = new DumperOptions();
        LOGGER = new PrimitiveLogger(new File("serverstarter.log"));
        rep.addClassTag(ConfigFile.class, Tag.MAP);
        rep.addClassTag(LockFile.class, Tag.MAP);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        try {
            lockFile = ServerStarter.Companion.readLockFile();
            config = ServerStarter.Companion.readConfig();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load Yaml", e);
            throw (Throwable)new InitException("Failed to load class", e);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\bH\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Latm/bloodworkxgaming/serverstarter/ServerStarter$Companion;", "", "()V", "LOGGER", "Latm/bloodworkxgaming/serverstarter/logger/PrimitiveLogger;", "getLOGGER", "()Latm/bloodworkxgaming/serverstarter/logger/PrimitiveLogger;", "config", "Latm/bloodworkxgaming/serverstarter/config/ConfigFile;", "getConfig", "()Latm/bloodworkxgaming/serverstarter/config/ConfigFile;", "<set-?>", "Latm/bloodworkxgaming/serverstarter/config/LockFile;", "lockFile", "getLockFile", "()Latm/bloodworkxgaming/serverstarter/config/LockFile;", "setLockFile", "(Latm/bloodworkxgaming/serverstarter/config/LockFile;)V", "options", "Lorg/yaml/snakeyaml/DumperOptions;", "rep", "Lorg/yaml/snakeyaml/representer/Representer;", "readConfig", "readLockFile", "saveLockFile", "", "serverstarter"})
    public static final class Companion {
        @NotNull
        public final PrimitiveLogger getLOGGER() {
            return LOGGER;
        }

        @NotNull
        public final LockFile getLockFile() {
            return lockFile;
        }

        private final void setLockFile(LockFile lockFile) {
            ServerStarter.lockFile = lockFile;
        }

        @NotNull
        public final ConfigFile getConfig() {
            return config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ConfigFile readConfig() throws RuntimeException {
            ConfigFile file;
            Yaml yaml = new Yaml(new CustomConstructor(ConfigFile.class), rep, options);
            try {
                ConfigFile configFile;
                Object object = new File("server-setup-config.yaml");
                object = new FileInputStream((File)object);
                Throwable throwable = null;
                try {
                    FileInputStream it = (FileInputStream)object;
                    Object t = yaml.load(it);
                    Intrinsics.checkExpressionValueIsNotNull(t, "yaml.load<ConfigFile>(it)");
                    ConfigFile configFile2 = (ConfigFile)t;
                    configFile = configFile2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, throwable);
                }
                Intrinsics.checkExpressionValueIsNotNull(configFile, "File(\"server-setup-confi\u2026ml.load<ConfigFile>(it) }");
                file = configFile;
            }
            catch (FileNotFoundException e) {
                this.getLOGGER().error("There is no config file given.", e);
                throw (Throwable)new RuntimeException("No config file given.", e);
            }
            catch (IOException e) {
                this.getLOGGER().error("Could not read config file.", e);
                throw (Throwable)new RuntimeException("Failed to read config file", e);
            }
            if (file == null) {
                throw (Throwable)new RuntimeException("Config file was null while reading.");
            }
            return file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final LockFile readLockFile() {
            Yaml yaml = new Yaml(new Constructor(LockFile.class), rep, options);
            File file = new File("serverstarter.lock");
            if (file.exists()) {
                try {
                    Closeable closeable = new FileInputStream(file);
                    Throwable throwable = null;
                    try {
                        FileInputStream stream = (FileInputStream)closeable;
                        Object t = yaml.load(stream);
                        Intrinsics.checkExpressionValueIsNotNull(t, "yaml.load(stream)");
                        LockFile lockFile = (LockFile)t;
                        return lockFile;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                }
                catch (FileNotFoundException e) {
                    return new LockFile(false, false, null, null, null, null, 63, null);
                }
                catch (IOException e) {
                    this.getLOGGER().error("Error while reading Lock file", e);
                    throw (Throwable)new RuntimeException("Error while reading Lock file", e);
                }
            }
            return new LockFile(false, false, null, null, null, null, 63, null);
        }

        public final void saveLockFile(@NotNull LockFile lockFile) {
            Intrinsics.checkParameterIsNotNull(lockFile, "lockFile");
            Yaml yaml = new Yaml(new Constructor(LockFile.class), rep, options);
            File file = new File("serverstarter.lock");
            this.setLockFile(lockFile);
            String lock = "#Auto genereated file, DO NOT EDIT!\n" + yaml.dump(lockFile);
            try {
                FileUtils.write(file, (CharSequence)lock, "utf-8", false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

